/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceInput;
import org.richfaces.renderkit.ScriptOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceInputBaseRenderer
extends HeaderResourcesRendererBase {
    private static Log logger = LogFactory.getLog(InplaceInputBaseRenderer.class);
    private static final String CONTROLS_FACET = "controls";
    private static final int NORMAL_KEY = 0;
    private static final int HOVERED_KEY = 1;
    private static final int EDITABLE_KEY = 2;
    private static final String INPLACE_COMPONENT = "COMPONENT";
    private static final String INPLACE_CHANGED = "CHANGED";
    private static final String INPLACE_VIEW = "VIEW";
    private static final String INPLACE_EDITABLE = "EDITABLE";
    private static final String INPLACE_NORMAL = "NORMAL";
    private static final String INPLACE_HOVERED = "HOVERED";
    private static final String INPLACE_CSS_PUBLIC = "rich-inplace";
    private static final String INPLACE_CSS_VIEW = "view";
    private static final String INPLACE_CSS_EDITABLE = "edit";
    private static final String INPLACE_CSS_CHANGE = "changed";
    private static final String INPLACE_CSS_HOVER = "hover";

    protected Class<UIInplaceInput> getComponentClass() {
        return UIInplaceInput.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        UIInplaceInput inplaceInput = null;
        if (!(component instanceof UIInplaceInput)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceInput"));
            }
            return;
        }
        inplaceInput = (UIInplaceInput)component;
        if ((InputUtils.isDisabled((UIComponent)inplaceInput) || InputUtils.isReadOnly((UIComponent)inplaceInput)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((clientId = component.getClientId(context)) == null) {
            throw new NullPointerException("component " + inplaceInput.getClientId(context) + " client id is NULL");
        }
        clientId = clientId + "value";
        Map request = context.getExternalContext().getRequestParameterMap();
        if (request.containsKey(clientId)) {
            String newValue = (String)request.get(clientId);
            inplaceInput.setSubmittedValue(newValue);
        }
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    public String encodeScriptAttributes(FacesContext context, UIComponent component) {
        StringBuffer attributes = new StringBuffer();
        attributes.append("var attributes = ");
        ScriptOptions options = new ScriptOptions(component);
        options.addOption("defaultLabel");
        options.addOption("showControls");
        options.addOption("editEvent");
        options.addOption("selectOnEdit");
        options.addOption("verticalPosition", component.getAttributes().get("controlsVerticalPosition"));
        options.addOption("horizontalPosition", component.getAttributes().get("controlsHorizontalPosition"));
        options.addOption("inputWidth");
        options.addOption("minInputWidth");
        options.addOption("maxInputWidth");
        attributes.append(options.toScript());
        return attributes.toString();
    }

    public String encodeScriptEvents(FacesContext context, UIComponent component) {
        StringBuffer events = new StringBuffer();
        events.append("var events = ");
        ScriptOptions options = new ScriptOptions(component);
        options.addEventHandler("oneditactivation");
        options.addEventHandler("onviewactivation");
        options.addEventHandler("oneditactivated");
        options.addEventHandler("onviewactivated");
        events.append(options.toScript());
        return events.toString();
    }

    public String encodeInplaceInputCss(FacesContext context, UIComponent component) {
        StringBuffer cssMap = new StringBuffer();
        cssMap.append("var classes = ");
        ScriptOptions mainMap = new ScriptOptions(component);
        ScriptOptions componentClasses = new ScriptOptions(component);
        ScriptOptions changedClasses = new ScriptOptions(component);
        ScriptOptions viewClasses = new ScriptOptions(component);
        changedClasses.addOption(INPLACE_NORMAL, (Object)this.buildCss(component, 0, INPLACE_CSS_CHANGE));
        changedClasses.addOption(INPLACE_HOVERED, (Object)this.buildCss(component, 1, INPLACE_CSS_CHANGE));
        viewClasses.addOption(INPLACE_NORMAL, (Object)this.buildCss(component, 0, INPLACE_CSS_VIEW));
        viewClasses.addOption(INPLACE_HOVERED, (Object)this.buildCss(component, 1, INPLACE_CSS_VIEW));
        componentClasses.addOption(INPLACE_CHANGED, (Object)changedClasses);
        componentClasses.addOption(INPLACE_VIEW, (Object)viewClasses);
        componentClasses.addOption(INPLACE_EDITABLE, (Object)this.buildCss(component, 2, INPLACE_CSS_EDITABLE));
        mainMap.addOption(INPLACE_COMPONENT, (Object)componentClasses);
        cssMap.append(mainMap.toString());
        return cssMap.toString();
    }

    private String buildCss(UIComponent component, int key, String suffix) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (key) {
            case 0: {
                stringBuffer.append(INPLACE_CSS_PUBLIC);
                stringBuffer.append(" ");
                stringBuffer.append("rich-inplace-" + suffix);
                Object value = component.getAttributes().get(suffix + "Class");
                if (value == null) break;
                stringBuffer.append(" ");
                stringBuffer.append(value);
                break;
            }
            case 1: {
                stringBuffer.append("rich-inplace-input-" + suffix + "-" + INPLACE_CSS_HOVER);
                Object value = component.getAttributes().get(suffix + "HoverClass");
                if (value == null) break;
                stringBuffer.append(" ");
                stringBuffer.append(value);
                break;
            }
            case 2: {
                stringBuffer.append(INPLACE_CSS_PUBLIC);
                stringBuffer.append(" ");
                stringBuffer.append("rich-inplace-" + suffix);
                Object value = component.getAttributes().get(suffix + "Class");
                if (value == null) break;
                stringBuffer.append(" ");
                stringBuffer.append(value);
            }
        }
        return stringBuffer.toString();
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        String event = (String)component.getAttributes().get(attributeName);
        String result = null;
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition();
            function.addParameter((Object)"event");
            function.addToBody((Object)event);
            result = function.toScript();
        }
        return result;
    }

    protected String getConvertedStringValue(FacesContext context, UIInplaceInput component, Object value) {
        Converter converter = component.getConverter();
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Class<?> converterType = value.getClass();
            if (converterType != null) {
                converter = context.getApplication().createConverter(converterType);
            }
            if (converter == null) {
                return value.toString();
            }
        }
        return converter.getAsString(context, (UIComponent)component, value);
    }
}

