/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxBaseRenderer
extends HeaderResourcesRendererBase {
    private List valuesList = null;
    private final String RICH_COMBOBOX_ITEM_CLASSES = "rich-combobox-item rich-combobox-item-normal";
    private static Log logger = LogFactory.getLog(ComboBoxBaseRenderer.class);

    protected Class<? extends UIComponent> getComponentClass() {
        return UIComboBox.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        UIComboBox comboBox = null;
        if (!(component instanceof UIComboBox)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIComboBox"));
            }
            return;
        }
        comboBox = (UIComboBox)component;
        if ((InputUtils.isDisabled((UIComponent)comboBox) || InputUtils.isReadOnly((UIComponent)comboBox)) && logger.isDebugEnabled()) {
            logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
        }
        if ((clientId = component.getClientId(context)) == null) {
            throw new NullPointerException("component " + comboBox.getClientId(context) + " client id is NULL");
        }
        clientId = "comboboxValue" + clientId;
        Map request = context.getExternalContext().getRequestParameterMap();
        if (request.containsKey(clientId)) {
            String newValue = (String)request.get(clientId);
            comboBox.setSubmittedValue(newValue);
        }
    }

    public void encodeItems(FacesContext context, UIComponent component) throws IOException {
        List selectItems;
        UIComboBox comboBox = (UIComboBox)component;
        Object suggestionValues = comboBox.getSuggestionValues();
        ResponseWriter writer = context.getResponseWriter();
        ArrayList<String> values = new ArrayList<String>();
        if (suggestionValues != null) {
            if (suggestionValues instanceof Collection) {
                Iterator iterator = ((Collection)suggestionValues).iterator();
                while (iterator.hasNext()) {
                    String value = this.getConvertedStringValue(context, (UIComponent)comboBox, iterator.next());
                    values.add(value);
                    this.encodeSuggestion(writer, (UIComponent)comboBox, value, "rich-combobox-item rich-combobox-item-normal");
                }
            } else if (suggestionValues.getClass().isArray()) {
                Object[] suggestions = (Object[])suggestionValues;
                for (int i = 0; i < suggestions.length; ++i) {
                    String value = this.getConvertedStringValue(context, (UIComponent)comboBox, suggestions[i]);
                    values.add(value);
                    this.encodeSuggestion(writer, (UIComponent)comboBox, value, "rich-combobox-item rich-combobox-item-normal");
                }
            } else {
                throw new IllegalArgumentException("suggestionValues should be Collection or array");
            }
        }
        if (!(selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component)).isEmpty()) {
            for (SelectItem selectItem : selectItems) {
                String value = this.getConvertedStringValue(context, (UIComponent)comboBox, selectItem.getValue());
                values.add(value);
                this.encodeSuggestion(writer, (UIComponent)comboBox, value, "rich-combobox-item rich-combobox-item-normal");
            }
        }
        this.setValuesList(values);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIComboBox comboBox = null;
        Converter converter = null;
        if (component instanceof UIComboBox) {
            comboBox = (UIComboBox)component;
            converter = comboBox.getConverter();
        }
        return this.getConvertedValue(context, component, submittedValue, converter);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue, Converter converter) {
        Object convertedValue = null;
        String newValue = (String)submittedValue;
        ValueExpression valueExpression = component.getValueExpression("value");
        if (converter == null && valueExpression != null) {
            Class valueType = valueExpression.getType(context.getELContext());
            if (valueType == null || String.class.equals((Object)valueType) || Object.class.equals((Object)valueType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No conversion necessary for value " + newValue + " of component " + component.getClientId(context)));
                }
            } else {
                converter = context.getApplication().createConverter(valueType);
                if (converter == null) {
                    throw new ConverterException(Messages.getMessage((String)"NO_CONVERTER_FOUND_ERROR", (Object)valueType.getName()));
                }
            }
        }
        convertedValue = converter != null ? converter.getAsObject(context, component, newValue) : newValue;
        return convertedValue;
    }

    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        Converter converter = null;
        if (component instanceof UIComboBox) {
            UIComboBox comboBox = (UIComboBox)component;
            converter = comboBox.getConverter();
        }
        return this.getConvertedStringValue(context, component, value, converter);
    }

    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value, Converter converter) {
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Class<?> converterType = value.getClass();
            if (converterType != null) {
                converter = context.getApplication().createConverter(converterType);
            }
            if (converter == null) {
                return value.toString();
            }
        }
        return converter.getAsString(context, component, value);
    }

    public void encodeSuggestion(ResponseWriter writer, UIComponent component, String value, String classes) throws IOException {
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)classes, null);
        writer.write(value);
        writer.endElement("span");
    }

    public String getItemsTextAsJSArray(FacesContext context, UIComponent component) {
        return ScriptUtils.toScript((Object)this.valuesList);
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        String event = (String)component.getAttributes().get(attributeName);
        JSReference result = JSReference.NULL;
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition();
            function.addParameter((Object)"event");
            function.addToBody((Object)event);
            result = function;
        }
        return ScriptUtils.toScript((Object)result);
    }

    public List getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List valuesList) {
        this.valuesList = valuesList;
    }
}

