/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.richfaces.component.Column;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.model.Ordering;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.ScriptOptions;
import org.richfaces.renderkit.TableHolder;

public abstract class AbstractTableRenderer
extends AbstractRowsRenderer {
    private static final String SORT_FILTER_PARAMETER = "fsp";
    private static final String FILTER_INPUT_FACET_NAME = "filterValueInput";
    private static final String SPACER_PATH = "/org/richfaces/renderkit/html/images/spacer.gif";

    public void encodeTableStructure(FacesContext context, UIDataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = this.getColumnsCount(table);
        writer.startElement("colgroup", (UIComponent)table);
        writer.writeAttribute("span", (Object)String.valueOf(columns), null);
        String columnsWidth = (String)table.getAttributes().get("columnsWidth");
        if (null != columnsWidth) {
            String[] widths = columnsWidth.split(",");
            for (int i = 0; i < widths.length; ++i) {
                writer.startElement("col", (UIComponent)table);
                writer.writeAttribute("width", (Object)widths[i], null);
                writer.endElement("col");
            }
        }
        writer.endElement("colgroup");
        this.encodeCaption(context, table);
        this.encodeHeader(context, table, columns);
        this.encodeFooter(context, table, columns);
    }

    public void encodeHeader(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getHeader();
        Iterator headers = this.columnFacets(table, "header");
        Iterator<UIComponent> colums = table.columns();
        int colCount = this.calculateRowColumns(table.columns());
        if (header != null || headers.hasNext()) {
            writer.startElement("thead", (UIComponent)table);
            writer.writeAttribute("class", (Object)"dr-table-thead", null);
            String headerClass = (String)table.getAttributes().get("headerClass");
            if (header != null) {
                this.encodeTableHeaderFacet(context, columns, writer, header, "dr-table-header rich-table-header", "dr-table-header-continue rich-table-header-continue", "dr-table-headercell rich-table-headercell", headerClass, "th");
            }
            if (headers.hasNext()) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subheader rich-table-subheader", null, headerClass);
                this.encodeHeaderFacets(context, writer, colums, "dr-table-subheadercell rich-table-subheadercell", headerClass, "header", "th", colCount);
                writer.endElement("tr");
            }
            writer.endElement("thead");
        }
    }

    public boolean findFacet(UIDataTable table, String facetName) {
        return this.columnFacets(table, facetName).hasNext();
    }

    protected void encodeHeaderFacets(FacesContext context, ResponseWriter writer, Iterator headers, String skinCellClass, String headerClass, String facetName, String element, int colCount) throws IOException {
        int t_colCount = 0;
        String spacerUrl = this.getResource(SPACER_PATH).getUri(context, null);
        RichHeaderEncodeStrategy richEncodeStrategy = new RichHeaderEncodeStrategy();
        SimpleHeaderEncodeStrategy simpleEncodeStrategy = new SimpleHeaderEncodeStrategy();
        while (headers.hasNext()) {
            UIComponent column = (UIComponent)headers.next();
            t_colCount = (Integer)column.getAttributes().get("colspan") != null ? (t_colCount += ((Integer)column.getAttributes().get("colspan")).intValue()) : ++t_colCount;
            if (t_colCount > colCount) break;
            String classAttribute = facetName + "Class";
            String columnHeaderClass = (String)column.getAttributes().get(classAttribute);
            writer.startElement(element, column);
            this.encodeStyleClass(writer, null, skinCellClass, headerClass, columnHeaderClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, column, "colspan");
            boolean sortableColumn = column.getValueExpression("comparator") != null || column.getValueExpression("sortBy") != null;
            SimpleHeaderEncodeStrategy strategy = column instanceof org.richfaces.component.UIColumn && "header".equals(facetName) ? richEncodeStrategy : simpleEncodeStrategy;
            strategy.encodeBegin(context, writer, column, facetName, sortableColumn);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null) {
                this.renderChild(context, facet);
            }
            strategy.encodeEnd(context, writer, column, facetName, sortableColumn, spacerUrl);
            writer.endElement(element);
        }
    }

    public void encodeFooter(FacesContext context, UIDataTable table, int columns) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        Iterator footers = this.columnFacets(table, "footer");
        Iterator<UIComponent> tableColumns = table.columns();
        int colCount = this.calculateRowColumns(table.columns());
        if (footer != null || footers.hasNext()) {
            writer.startElement("tfoot", (UIComponent)table);
            String footerClass = (String)table.getAttributes().get("footerClass");
            if (footers.hasNext() && this.findFacet(table, "footer")) {
                writer.startElement("tr", (UIComponent)table);
                this.encodeStyleClass(writer, null, "dr-table-subfooter rich-table-subfooter", null, footerClass);
                this.encodeHeaderFacets(context, writer, tableColumns, "dr-table-subfootercell rich-table-subfootercell", footerClass, "footer", "td", colCount);
                writer.endElement("tr");
            }
            if (footer != null) {
                this.encodeTableHeaderFacet(context, columns, writer, footer, "dr-table-footer rich-table-footer", "dr-table-footer-continue rich-table-footer-continue", "dr-table-footercell rich-table-footercell", footerClass, "td");
            }
            writer.endElement("tfoot");
        }
    }

    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        UIDataTable table = (UIDataTable)holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Iterator<UIComponent> iter = table.columns();
        boolean first = true;
        int currentColumn = 0;
        UIComponent column = null;
        while (iter.hasNext()) {
            column = iter.next();
            if (first && !(column instanceof Row)) {
                this.encodeRowStart(context, this.getFirstRowSkinClass(), holder.getRowClass(), table, writer);
            }
            if (column instanceof Column) {
                boolean breakBefore;
                boolean bl = breakBefore = ((Column)column).isBreakBefore() || column instanceof Row;
                if (breakBefore && !first) {
                    writer.endElement("tr");
                    currentColumn = 0;
                    if (!(column instanceof Row)) {
                        holder.nextRow();
                        this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    }
                }
                this.encodeCellChildren(context, column, first ? this.getFirstRowSkinClass() : null, this.getRowSkinClass(), holder.getRowClass(), this.getCellSkinClass(), holder.getColumnClass(currentColumn));
                if (column instanceof Row && iter.hasNext()) {
                    holder.nextRow();
                    this.encodeRowStart(context, holder.getRowClass(), table, writer);
                    currentColumn = -1;
                }
            } else if (column.isRendered()) {
                writer.startElement("td", (UIComponent)table);
                this.getUtils().encodeId(context, column);
                String columnClass = holder.getColumnClass(currentColumn);
                this.encodeStyleClass(writer, null, this.getCellSkinClass(), null, columnClass);
                this.renderChildren(context, column);
                writer.endElement("td");
            }
            ++currentColumn;
            first = false;
        }
        if (!first && !(column instanceof Row)) {
            writer.endElement("tr");
        }
    }

    protected void encodeRowStart(FacesContext context, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        this.encodeRowStart(context, this.getRowSkinClass(), rowClass, table, writer);
    }

    protected String getRowSkinClass() {
        return "dr-table-row rich-table-row";
    }

    protected String getFirstRowSkinClass() {
        return "dr-table-firstrow rich-table-firstrow";
    }

    protected String getCellSkinClass() {
        return "dr-table-cell rich-table-cell";
    }

    protected void encodeRowStart(FacesContext context, String skinClass, String rowClass, UIDataTable table, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)table);
        this.encodeStyleClass(writer, null, skinClass, null, rowClass);
        this.encodeRowEvents(context, (UIDataAdaptor)table);
    }

    protected Iterator columnFacets(UIDataTable table, final String name) {
        return new FilterIterator(table.columns(), new Predicate(){

            public boolean evaluate(Object input) {
                UIComponent component = (UIComponent)input;
                if (component instanceof Column || component instanceof UIColumn) {
                    return component.isRendered() && component.getFacet(name) != null;
                }
                return false;
            }
        });
    }

    protected int getColumnsCount(UIDataTable table) {
        int count = 0;
        Integer span = (Integer)table.getAttributes().get("columns");
        if (null != span && span != Integer.MIN_VALUE) {
            count = span;
        } else {
            Iterator<UIComponent> col = table.columns();
            count = this.calculateRowColumns(col);
        }
        return count;
    }

    protected int calculateRowColumns(Iterator col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent column = (UIComponent)col.next();
            if (!column.isRendered()) continue;
            if (column instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.calculateRowColumns(((Row)column).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (column instanceof Column) {
                Integer colspan;
                Column tableColumn = (Column)column;
                if (tableColumn.isBreakBefore()) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)column.getAttributes().get("colspan")) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(column instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }

    public void encodeScriptIfNecessary(FacesContext context, UIDataTable component) throws IOException {
        boolean shouldRender = false;
        Iterator<UIComponent> columns = component.columns();
        while (columns.hasNext() && !shouldRender) {
            UIComponent next = columns.next();
            shouldRender = next instanceof Column && ((Column)next).isSortable();
        }
        if (shouldRender) {
            JSFunction function = new JSFunction("new RichFaces.DataTable");
            function.addParameter((Object)component.getBaseClientId(context));
            ScriptOptions scriptOptions = new ScriptOptions((UIComponent)component);
            scriptOptions.addOption("sortMode", (Object)new JSFunction("new RichFaces.SortMode.Single"));
            function.addParameter((Object)scriptOptions);
            this.getUtils().writeScript(context, (UIComponent)component, (Object)function.toScript());
        }
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        String clientId;
        Map map = context.getExternalContext().getRequestParameterMap();
        if (SORT_FILTER_PARAMETER.equals(map.get(clientId = component.getClientId(context)))) {
            String sortColumnId = (String)map.get(SORT_FILTER_PARAMETER);
            List list = component.getChildren();
            UIDataTable table = (UIDataTable)component;
            boolean isSingleSortMode = !"multi".equals(table.getSortMode());
            for (UIComponent child : list) {
                UIInput filterValueInput;
                if (!(child instanceof org.richfaces.component.UIColumn)) continue;
                org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)child;
                child.setId(child.getId());
                if (sortColumnId != null) {
                    if (sortColumnId.equals(child.getClientId(context))) {
                        String id = child.getId();
                        Collection<Object> sortPriority = table.getSortPriority();
                        if (isSingleSortMode) {
                            sortPriority.clear();
                        }
                        if (!sortPriority.contains(id)) {
                            sortPriority.add(id);
                        }
                        column.toggleSortOrder();
                    } else if (isSingleSortMode) {
                        column.setSortOrder(Ordering.UNSORTED);
                    }
                }
                if (null == (filterValueInput = (UIInput)child.getFacet(FILTER_INPUT_FACET_NAME))) continue;
                filterValueInput.decode(context);
                Object submittedValue = filterValueInput.getSubmittedValue();
                if (null == submittedValue) continue;
                column.setFilterValue(filterValueInput.getSubmittedValue().toString());
            }
            AjaxContext.getCurrentInstance().addComponentToAjaxRender(component);
            AjaxContext.getCurrentInstance().addRenderedArea(clientId + ":tb");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        String clientId = component.getClientId(context);
        Set ajaxRenderedAreas = AjaxContext.getCurrentInstance().getAjaxRenderedAreas();
        if (ajaxRenderedAreas.contains(clientId + ":tb")) {
            ajaxRenderedAreas.remove(clientId);
        }
    }

    protected void addInplaceInput(FacesContext context, UIComponent column, String buffer) throws IOException {
        UIInput filterValueInput = (UIInput)column.getFacet(FILTER_INPUT_FACET_NAME);
        boolean inplaceInput = true;
        if (null == filterValueInput) {
            try {
                filterValueInput = (UIInput)context.getApplication().createComponent("org.richfaces.InplaceInput");
            }
            catch (FacesException e) {
                filterValueInput = (UIInput)context.getApplication().createComponent("javax.faces.Input");
                inplaceInput = false;
            }
            filterValueInput.setId(column.getId() + SORT_FILTER_PARAMETER);
            filterValueInput.setImmediate(true);
            column.getFacets().put(FILTER_INPUT_FACET_NAME, filterValueInput);
            filterValueInput.getAttributes().put("onclick", "Event.stop(event);");
        }
        String onkeydownEvent = inplaceInput ? "oninputkeydown" : "onkeydown";
        String filterEvent = (String)column.getAttributes().get("filterEvent");
        if (null == filterEvent || "".equals(filterEvent)) {
            filterEvent = "onchange";
        }
        filterValueInput.getAttributes().put(filterEvent, buffer);
        filterValueInput.getAttributes().put(onkeydownEvent, "RichFaces.blurFilterInput(event);");
        filterValueInput.setValue(column.getAttributes().get("filterValue"));
        this.getUtils().encodeBeginFormIfNessesary(context, column);
        this.renderChild(context, (UIComponent)filterValueInput);
        this.getUtils().encodeEndFormIfNessesary(context, column);
    }

    protected String buildAjaxFunction(FacesContext context, UIComponent column, boolean sortable) {
        UIComponent table = column.getParent();
        String id = table.getClientId(context);
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((UIComponent)table, (FacesContext)context);
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)table);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(id, SORT_FILTER_PARAMETER);
        if (sortable) {
            parameters.put(SORT_FILTER_PARAMETER, column.getClientId(context));
        }
        ajaxFunction.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        ajaxFunction.appendScript(buffer);
        return buffer.toString();
    }

    protected class RichHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected RichHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            String clientId = col.getClientId(context) + facetName;
            writer.writeAttribute("id", (Object)clientId, null);
            if (sortableColumn && col.isSelfSorted()) {
                writer.writeAttribute("onclick", (Object)AbstractTableRenderer.this.buildAjaxFunction(context, column, true).toString(), null);
                writer.writeAttribute("style", (Object)"cursor: pointer;", null);
            }
            writer.startElement("div", column);
            if (sortableColumn) {
                writer.startElement("span", column);
                String spanClass = "";
                if (Ordering.ASCENDING.equals((Object)col.getSortOrder())) {
                    spanClass = "dr-table-header-sort-up dr-table-sortable-header";
                } else if (Ordering.DESCENDING.equals((Object)col.getSortOrder())) {
                    spanClass = "dr-table-header-sort-down dr-table-sortable-header";
                }
                writer.writeAttribute("class", (Object)spanClass, null);
            }
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn, String spacerUrl) throws IOException {
            org.richfaces.component.UIColumn col = (org.richfaces.component.UIColumn)column;
            if (sortableColumn) {
                if (Ordering.ASCENDING.equals((Object)col.getSortOrder()) || Ordering.DESCENDING.equals((Object)col.getSortOrder())) {
                    writer.startElement("img", column);
                    writer.writeAttribute("src", (Object)spacerUrl, null);
                    writer.writeAttribute("width", (Object)"16", null);
                    writer.endElement("img");
                }
                writer.endElement("span");
            }
            writer.endElement("div");
            if (col.getFilterMethod() == null && col.getValueExpression("filterExpression") == null && col.getValueExpression("filterBy") != null) {
                writer.startElement("div", column);
                AbstractTableRenderer.this.addInplaceInput(context, column, AbstractTableRenderer.this.buildAjaxFunction(context, column, false));
                writer.endElement("div");
            }
        }
    }

    protected class SimpleHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected SimpleHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn) throws IOException {
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean sortableColumn, String spacelUrl) throws IOException {
        }
    }
}

