/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.org.jboss.seam.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.richfaces.org.jboss.seam.web.MultipartRequest;

public class MultipartFilter
implements Filter {
    public static final String MULTIPART = "multipart/";
    public static final String REQUESTS_SESSIONS_BEAN_NAME = "_richfaces_upload_sessions";
    public static final String PERCENT_BEAN_NAME = "_richfaces_upload_percents";
    private boolean createTempFiles = false;
    private int maxRequestSize = 0;

    public boolean getCreateTempFiles() {
        return this.createTempFiles;
    }

    public void setCreateTempFiles(boolean createTempFiles) {
        this.createTempFiles = createTempFiles;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(int maxFileSize) {
        this.maxRequestSize = maxFileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uid = httpRequest.getParameter("uid");
        if (this.isMultipartRequest(httpRequest)) {
            MultipartRequest multipartRequest = new MultipartRequest(httpRequest, this.createTempFiles, this.maxRequestSize, uid);
            Map<String, MultipartRequest> sessionsMap = null;
            HashMap<String, Integer> percentMap = null;
            try {
                if (!this.isFileSizeRestricted(request, this.maxRequestSize)) {
                    HttpSession session;
                    HttpSession httpSession = session = httpRequest.getSession();
                    synchronized (httpSession) {
                        sessionsMap = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
                        percentMap = (Map)session.getAttribute(PERCENT_BEAN_NAME);
                        if (sessionsMap == null) {
                            sessionsMap = Collections.synchronizedMap(new HashMap());
                            session.setAttribute(REQUESTS_SESSIONS_BEAN_NAME, sessionsMap);
                        }
                        if (percentMap == null) {
                            percentMap = new HashMap<String, Integer>();
                            session.setAttribute(PERCENT_BEAN_NAME, percentMap);
                        }
                    }
                    percentMap.put(uid, 0);
                    sessionsMap.put(uid, multipartRequest);
                    if (multipartRequest.parseRequest()) {
                        chain.doFilter((ServletRequest)multipartRequest, response);
                    }
                    this.printResponse(response, "<html id=\"_richfaces_file_upload_stopped\"></html>");
                }
                this.printResponse(response, "<html id=\"_richfaces_file_upload_size_restricted\"></html>");
            }
            finally {
                if (sessionsMap != null) {
                    sessionsMap.remove(uid);
                    percentMap.remove(uid);
                }
            }
        } else if ("stop".equals(httpRequest.getParameter("action"))) {
            MultipartRequest multipartRequest;
            HttpSession session = httpRequest.getSession();
            Map sessions = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
            if (sessions != null && (multipartRequest = (MultipartRequest)((Object)sessions.get(uid))) != null) {
                multipartRequest.stop();
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setStatus(204);
                httpResponse.getOutputStream().close();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isFileSizeRestricted(ServletRequest request, int maxSize) {
        return request.getContentLength() > maxSize;
    }

    private void printResponse(ServletResponse response, String message) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(200);
        httpResponse.setContentType("text/html");
        PrintWriter writer = httpResponse.getWriter();
        writer.write(message);
        writer.close();
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String param = filterConfig.getInitParameter("createTempFiles");
        if (param != null) {
            this.createTempFiles = Boolean.parseBoolean(param);
        }
        if ((param = filterConfig.getInitParameter("maxRequestSize")) != null) {
            this.maxRequestSize = Integer.parseInt(param);
        }
    }
}

