package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIScrollableDataTable;
import org.richfaces.model.SortOrder;
import org.richfaces.model.selection.Selection;

public class HtmlScrollableDataTable extends UIScrollableDataTable{

public final static  String COMPONENT_FAMILY = "org.richfaces.component.ScrollableDataTable";

public final static  String COMPONENT_TYPE = "org.richfaces.component.ScrollableDataTable";

/*
* A CSS class to be applied to an active row
*/
private  String _activeClass = null;

/*
* activeRowKey
*/
private  Object _activeRowKey = null;

/*
* if "true", submits ONLY one field/link, instead of all form controls
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* Space-separated list of CSS style class(es) that are be applied to caption for this component
*/
private  String _captionClass = null;

/*
* Comma-delimited list of CSS style classes that are be applied to the columns of this table. A space separated list of classes may also be specified for any individual column. If the number of elements in this list is less than the number of columns specified in the "columns" attribute, no "class" attribute is output for each column greater than the number of elements in the list. If the number of elements in the list is greater than the number of columns specified in the "columns" attribute, the elements at the position in the list after the value of the "columns" attribute are ignored
*/
private  String _columnClasses = null;

/*
* Serialized (on default with JSON) data passed on the client by a developer on AJAX request. It's accessible via "data.foo" syntax
*/
private  Object _data = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* Space-separated list of CSS style class(es) that are be applied to any footer generated for this table
*/
private  String _footerClass = null;

/*
* Defines the number of the fixed columns from the left side that will not be scrolled via horizontal scroll.
			Default value is '0'
*/
private  int _frozenColCount = 0;

private  boolean _frozenColCountSet = false;

/*
* Space-separated list of CSS style class(es) that are be applied to any header generated for this table
*/
private  String _headerClass = null;

/*
* Defines a height of the component. Default value is 500px
*/
private  String _height = null;

/*
* If 'true' data will be hidden during scrolling. Can be used for increase performance.
			Default value is 'false'
*/
private  boolean _hideWhenScrolling = false;

private  boolean _hideWhenScrollingSet = false;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* If "true", updates on client side ONLY elements from this 'reRender' property. If "false" (default) updates all rendered by ajax region components
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* HTML: a script expression; a pointer button is clicked on row
*/
private  String _onRowClick = null;

/*
* HTML: a script expression; a pointer button is double-clicked on row
*/
private  String _onRowDblClick = null;

/*
* HTML: script expression; a pointer button is pressed down on row
*/
private  String _onRowMouseDown = null;

/*
* HTML: script expression; a pointer button is released on row
*/
private  String _onRowMouseUp = null;

/*
* JavaScript code for call before DOM has been updated on client side
*/
private  String _onbeforedomupdate = null;

/*
* JavaScript code for call after request completed on client side
*/
private  String _oncomplete = null;

/*
* HTML: script expression to invoke on changing of rows selection
*/
private  String _onselectionchange = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* A comma-delimited list of CSS style classes that is applied to popup table rows. A space separated list of classes may also be specified for any individual row. The styles are applied, in turn, to each row in the table. For example, if the list has two elements, the first style class in the list is applied to the first row, the second to the second row, the first to the third row, the second to the fourth row, etc. In other words, we keep iterating through the list until we reach the end, and then we start at the beginning again
*/
private  String _rowClasses = null;

/*
* Name of JavaScript variable corresponding to component
*/
private  String _scriptVar = null;

/*
* Name of the CSS class for a selected row
*/
private  String _selectedClass = null;

/*
* Value binding representing selected rows
*/
private  Selection _selection = null;

/*
* Defines mode of sorting. Possible values are 'single' for sorting of one column and 'multi' for some.
*/
private  String _sortMode = null;

/*
* ValueBinding pointing at a property of a class to manage rows sorting
*/
private  SortOrder _sortOrder = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* Defines a width of the component. Default value is 700px
*/
private  String _width = null;


public HtmlScrollableDataTable(){
setRendererType("org.richfaces.renderkit.html.ScrollableDataTableRenderer");
}

public String getActiveClass(){
	if (this._activeClass != null) {
		return this._activeClass;
	}
	ValueExpression ve = getValueExpression("activeClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setActiveClass(String _activeClass){
this._activeClass = _activeClass;
}

public Object getActiveRowKey(){
	if (this._activeRowKey != null) {
		return this._activeRowKey;
	}
	ValueExpression ve = getValueExpression("activeRowKey");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setActiveRowKey(Object _activeRowKey){
this._activeRowKey = _activeRowKey;
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public String getCaptionClass(){
	if (this._captionClass != null) {
		return this._captionClass;
	}
	ValueExpression ve = getValueExpression("captionClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCaptionClass(String _captionClass){
this._captionClass = _captionClass;
}

public String getColumnClasses(){
	if (this._columnClasses != null) {
		return this._columnClasses;
	}
	ValueExpression ve = getValueExpression("columnClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setColumnClasses(String _columnClasses){
this._columnClasses = _columnClasses;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getFooterClass(){
	if (this._footerClass != null) {
		return this._footerClass;
	}
	ValueExpression ve = getValueExpression("footerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFooterClass(String _footerClass){
this._footerClass = _footerClass;
}

public int getFrozenColCount(){
	if (this._frozenColCountSet) {
	    return (this._frozenColCount);
	}
	ValueExpression ve = getValueExpression("frozenColCount");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._frozenColCount);
	    }
	    
	    return value;
	} else {
	    return (this._frozenColCount);
	}

}

public void setFrozenColCount(int _frozenColCount){
this._frozenColCount = _frozenColCount;
this._frozenColCountSet = true;
}

public String getHeaderClass(){
	if (this._headerClass != null) {
		return this._headerClass;
	}
	ValueExpression ve = getValueExpression("headerClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHeaderClass(String _headerClass){
this._headerClass = _headerClass;
}

public String getHeight(){
	if (this._height != null) {
		return this._height;
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "500px";
	

}

public void setHeight(String _height){
this._height = _height;
}

public boolean isHideWhenScrolling(){
	if (this._hideWhenScrollingSet) {
	    return (this._hideWhenScrolling);
	}
	ValueExpression ve = getValueExpression("hideWhenScrolling");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._hideWhenScrolling);
	    }
	    
	    return value;
	} else {
	    return (this._hideWhenScrolling);
	}

}

public void setHideWhenScrolling(boolean _hideWhenScrolling){
this._hideWhenScrolling = _hideWhenScrolling;
this._hideWhenScrollingSet = true;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getOnRowClick(){
	if (this._onRowClick != null) {
		return this._onRowClick;
	}
	ValueExpression ve = getValueExpression("onRowClick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowClick(String _onRowClick){
this._onRowClick = _onRowClick;
}

public String getOnRowDblClick(){
	if (this._onRowDblClick != null) {
		return this._onRowDblClick;
	}
	ValueExpression ve = getValueExpression("onRowDblClick");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowDblClick(String _onRowDblClick){
this._onRowDblClick = _onRowDblClick;
}

public String getOnRowMouseDown(){
	if (this._onRowMouseDown != null) {
		return this._onRowMouseDown;
	}
	ValueExpression ve = getValueExpression("onRowMouseDown");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseDown(String _onRowMouseDown){
this._onRowMouseDown = _onRowMouseDown;
}

public String getOnRowMouseUp(){
	if (this._onRowMouseUp != null) {
		return this._onRowMouseUp;
	}
	ValueExpression ve = getValueExpression("onRowMouseUp");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnRowMouseUp(String _onRowMouseUp){
this._onRowMouseUp = _onRowMouseUp;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOnselectionchange(){
	if (this._onselectionchange != null) {
		return this._onselectionchange;
	}
	ValueExpression ve = getValueExpression("onselectionchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselectionchange(String _onselectionchange){
this._onselectionchange = _onselectionchange;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public String getScriptVar(){
	if (this._scriptVar != null) {
		return this._scriptVar;
	}
	ValueExpression ve = getValueExpression("scriptVar");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setScriptVar(String _scriptVar){
this._scriptVar = _scriptVar;
}

public String getSelectedClass(){
	if (this._selectedClass != null) {
		return this._selectedClass;
	}
	ValueExpression ve = getValueExpression("selectedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelectedClass(String _selectedClass){
this._selectedClass = _selectedClass;
}

public Selection getSelection(){
	if (this._selection != null) {
		return this._selection;
	}
	ValueExpression ve = getValueExpression("selection");
	if (ve != null) {
	    Selection value = null;
	    
	    try {
			value = (Selection) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelection(Selection _selection){
this._selection = _selection;
}

public String getSortMode(){
	if (this._sortMode != null) {
		return this._sortMode;
	}
	ValueExpression ve = getValueExpression("sortMode");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortMode(String _sortMode){
this._sortMode = _sortMode;
}

public SortOrder getSortOrder(){
	if (this._sortOrder != null) {
		return this._sortOrder;
	}
	ValueExpression ve = getValueExpression("sortOrder");
	if (ve != null) {
	    SortOrder value = null;
	    
	    try {
			value = (SortOrder) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSortOrder(SortOrder _sortOrder){
this._sortOrder = _sortOrder;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "700px";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[45];
state[0] = super.saveState(context);
state[1] = _activeClass;
state[2] = saveAttachedState(context, _activeRowKey);
state[3] = Boolean.valueOf(_ajaxSingle);
state[4] = Boolean.valueOf(_ajaxSingleSet);
state[5] = Boolean.valueOf(_bypassUpdates);
state[6] = Boolean.valueOf(_bypassUpdatesSet);
state[7] = _captionClass;
state[8] = _columnClasses;
state[9] = saveAttachedState(context, _data);
state[10] = _eventsQueue;
state[11] = _focus;
state[12] = _footerClass;
state[13] = Integer.valueOf(_frozenColCount);
state[14] = Boolean.valueOf(_frozenColCountSet);
state[15] = _headerClass;
state[16] = _height;
state[17] = Boolean.valueOf(_hideWhenScrolling);
state[18] = Boolean.valueOf(_hideWhenScrollingSet);
state[19] = Boolean.valueOf(_ignoreDupResponses);
state[20] = Boolean.valueOf(_ignoreDupResponsesSet);
state[21] = Boolean.valueOf(_limitToList);
state[22] = Boolean.valueOf(_limitToListSet);
state[23] = _onRowClick;
state[24] = _onRowDblClick;
state[25] = _onRowMouseDown;
state[26] = _onRowMouseUp;
state[27] = _onbeforedomupdate;
state[28] = _oncomplete;
state[29] = _onselectionchange;
state[30] = saveAttachedState(context, _reRender);
state[31] = Integer.valueOf(_requestDelay);
state[32] = Boolean.valueOf(_requestDelaySet);
state[33] = _rowClasses;
state[34] = _scriptVar;
state[35] = _selectedClass;
state[36] = saveAttachedState(context, _selection);
state[37] = _sortMode;
state[38] = saveAttachedState(context, _sortOrder);
state[39] = _status;
state[40] = _style;
state[41] = _styleClass;
state[42] = Integer.valueOf(_timeout);
state[43] = Boolean.valueOf(_timeoutSet);
state[44] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_activeClass = (String)states[1];;
		_activeRowKey = (Object)restoreAttachedState(context, states[2]);
		_ajaxSingle = ((Boolean)states[3]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[4]).booleanValue();
		_bypassUpdates = ((Boolean)states[5]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[6]).booleanValue();
		_captionClass = (String)states[7];;
		_columnClasses = (String)states[8];;
		_data = (Object)restoreAttachedState(context, states[9]);
		_eventsQueue = (String)states[10];;
		_focus = (String)states[11];;
		_footerClass = (String)states[12];;
		_frozenColCount = ((Integer)states[13]).intValue();
		_frozenColCountSet = ((Boolean)states[14]).booleanValue();
		_headerClass = (String)states[15];;
		_height = (String)states[16];;
		_hideWhenScrolling = ((Boolean)states[17]).booleanValue();
		_hideWhenScrollingSet = ((Boolean)states[18]).booleanValue();
		_ignoreDupResponses = ((Boolean)states[19]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[20]).booleanValue();
		_limitToList = ((Boolean)states[21]).booleanValue();
		_limitToListSet = ((Boolean)states[22]).booleanValue();
		_onRowClick = (String)states[23];;
		_onRowDblClick = (String)states[24];;
		_onRowMouseDown = (String)states[25];;
		_onRowMouseUp = (String)states[26];;
		_onbeforedomupdate = (String)states[27];;
		_oncomplete = (String)states[28];;
		_onselectionchange = (String)states[29];;
		_reRender = (Object)restoreAttachedState(context, states[30]);
		_requestDelay = ((Integer)states[31]).intValue();
		_requestDelaySet = ((Boolean)states[32]).booleanValue();
		_rowClasses = (String)states[33];;
		_scriptVar = (String)states[34];;
		_selectedClass = (String)states[35];;
		_selection = (Selection)restoreAttachedState(context, states[36]);
		_sortMode = (String)states[37];;
		_sortOrder = (SortOrder)restoreAttachedState(context, states[38]);
		_status = (String)states[39];;
		_style = (String)states[40];;
		_styleClass = (String)states[41];;
		_timeout = ((Integer)states[42]).intValue();
		_timeoutSet = ((Boolean)states[43]).booleanValue();
		_width = (String)states[44];;
	
}

}
