/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.html.DataScrollerRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.DatascrollerTemplate
 */
public class DatascrollerTemplate extends DataScrollerRenderer {

	public DatascrollerTemplate () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/datascroller.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				new org.ajax4jsf.javascript.AjaxScript()
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	private boolean isEmpty(Object o) {
		if (null == o) {
			return true;
		}
		if (o instanceof String ) {
			return (0 == ((String)o).length());
		}
		if (o instanceof Collection) {
			return (0 == ((Collection)o).size());
		}
		if (o instanceof Map) {
			return (0 == ((Map)o).size());
		}
		if (o.getClass().isArray()) {
			return (0 == ((Object [])o).length);
		}
		return false;
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIDatascroller.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIDatascroller component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);

		org.richfaces.component.util.FormUtil.throwEnclFormReqExceptionIfNeed(context,component);		                                               
    
java.lang.String singlePageRenderStyle = "";

		
		javax.faces.component.UIData dataTable = component.getDataTable();
        boolean singlePageRender = true;
		
		if (!isRenderedOnSinglePage(component, dataTable)) {
        	singlePageRenderStyle = "; display: none";
        	singlePageRender = false;
        }
				                                               
    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-dscr rich-datascr " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("style")) + " " + convertToString(singlePageRenderStyle) );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "align" ,
	    "dir" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "title" ,
	    "xml:lang" });
//
//
//


			
			if (singlePageRender) {
					                                               
	    
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "align", component.getAttributes().get("align") );
						getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "1" );
						getUtils().writeAttribute(writer, "class", "dr-dscr-t rich-dtascroller-table " + convertToString(component.getAttributes().get("tableStyleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "_table" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);


	                String facet;                         
	                org.richfaces.renderkit.html.ControlsState controlsState = getControlsState(context, component, dataTable);     
	                
	                if (controlsState.isFirstRendered()){                       
	                if (controlsState.isFirstEnabled()){
	                  variables.setVariable("buttonClass", "");                  
	                  variables.setVariable("onclick", getOnClick(context,component,component.FIRST_FACET_NAME));                        
	                  variables.setVariable("facet", component.FIRST_FACET_NAME);                  
	                  facet=component.FIRST_FACET_NAME;
	                }else{
	                  variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                  variables.setVariable("onclick", "");                                            
	                  variables.setVariable("facet", component.FIRST_DISABLED_FACET_NAME);                                    
	                  facet=component.FIRST_DISABLED_FACET_NAME;
	                };                
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.FIRST_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_9 = component.getFacet("first");
if (null != indexChildren_9 && indexChildren_9 .isRendered()) {
	renderChild(context, indexChildren_9);
}


						     }else{
					       
UIComponent indexChildren_10 = component.getFacet("first_disabled");
if (null != indexChildren_10 && indexChildren_10 .isRendered()) {
	renderChild(context, indexChildren_10);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
                    
	                      writer.write("&#171;&#171;");                      
	                    
writer.endElement("td");

	                } 
	                if (controlsState.isControlsSeparatorRendered() && 
	                		(controlsState.isFastRewindRendered() || controlsState.isPreviousRendered())) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-dscr-sepctrl rich-datascr-ctrls-separator" );
			
UIComponent indexChildren_11 = component.getFacet("controlsSeparator");
if (null != indexChildren_11 && indexChildren_11 .isRendered()) {
	renderChild(context, indexChildren_11);
}

writer.endElement("td");

	                }
	                }
	                
                
	                if (controlsState.isFastRewindRendered()){                       
	                if (controlsState.isFastRewindEnabled()){
	                  variables.setVariable("buttonClass", "");  
	                  variables.setVariable("onclick", getOnClick(context,component,component.FAST_REWIND_FACET_NAME));                                                                
	                  variables.setVariable("facet", component.FAST_REWIND_FACET_NAME);                                    
	                  facet=component.FAST_REWIND_FACET_NAME;                  
	                }else{
	                    variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                    variables.setVariable("onclick", "");                                                                                    
	                    variables.setVariable("facet", component.FAST_REWIND_DISABLED_FACET_NAME);                                    
	                    facet=component.FAST_REWIND_DISABLED_FACET_NAME;                                      
	                }
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.FAST_REWIND_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_12 = component.getFacet("fastrewind");
if (null != indexChildren_12 && indexChildren_12 .isRendered()) {
	renderChild(context, indexChildren_12);
}


						     }else{
					       
UIComponent indexChildren_13 = component.getFacet("fastrewind_disabled");
if (null != indexChildren_13 && indexChildren_13 .isRendered()) {
	renderChild(context, indexChildren_13);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
                    
	                      writer.write("&#171;");                      
	                    
writer.endElement("td");

	                }
	                
	                if (controlsState.isControlsSeparatorRendered() && controlsState.isPreviousRendered()) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-dscr-sepctrl rich-datascr-ctrls-separator" );
			
UIComponent indexChildren_14 = component.getFacet("controlsSeparator");
if (null != indexChildren_14 && indexChildren_14 .isRendered()) {
	renderChild(context, indexChildren_14);
}

writer.endElement("td");

	                }
	                }                
	                
                                                                                 
	                if (controlsState.isPreviousRendered()){                       
	                if (controlsState.isPreviousEnabled()){                     
	                  variables.setVariable("buttonClass", "");  
	                  variables.setVariable("onclick", getOnClick(context,component,component.PREVIOUS_FACET_NAME));                                                                
	                  variables.setVariable("facet", component.PREVIOUS_FACET_NAME);                                    
	                  facet=component.PREVIOUS_FACET_NAME;                                    
	                }else{
	                  variables.setVariable("onclick", "");                                                                                    
	                  variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                  variables.setVariable("facet", component.PREVIOUS_DISABLED_FACET_NAME);                                    
	                  facet=component.PREVIOUS_DISABLED_FACET_NAME;                  
	                }
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.PREVIOUS_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_15 = component.getFacet("previous");
if (null != indexChildren_15 && indexChildren_15 .isRendered()) {
	renderChild(context, indexChildren_15);
}


						     }else{
					       
UIComponent indexChildren_16 = component.getFacet("previous_disabled");
if (null != indexChildren_16 && indexChildren_16 .isRendered()) {
	renderChild(context, indexChildren_16);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
writer.endElement("td");

	                 }
	                 }                
	                 

						renderPages(context,component,dataTable);
	   			        UIComponent pagesFacet = component.getFacet("pages");
	   			        if (pagesFacet !=null && pagesFacet.isRendered()) {
	                
writer.startElement("td", component);


						renderChild(context, pagesFacet);
					
writer.endElement("td");

	   			        } else {
	   			        	renderPager(context,component,dataTable);
	   			        }
	                

	                if (controlsState.isNextRendered()){                       
	                if (controlsState.isNextEnabled()){                                                                               
	                  variables.setVariable("onclick", getOnClick(context,component,component.NEXT_FACET_NAME));                                        
	                  variables.setVariable("buttonClass", "");  
	                  variables.setVariable("facet", component.NEXT_FACET_NAME);                                    
	                  facet=component.NEXT_FACET_NAME;                                                      
	                }else{
	                  variables.setVariable("onclick", "");  
	                  variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                  variables.setVariable("facet", component.NEXT_DISABLED_FACET_NAME);                                    
	                  facet=component.NEXT_DISABLED_FACET_NAME;                                    
	                }
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.NEXT_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_17 = component.getFacet("next");
if (null != indexChildren_17 && indexChildren_17 .isRendered()) {
	renderChild(context, indexChildren_17);
}


						     }else{
					       
UIComponent indexChildren_18 = component.getFacet("next_disabled");
if (null != indexChildren_18 && indexChildren_18 .isRendered()) {
	renderChild(context, indexChildren_18);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
writer.endElement("td");

	                }
	                
	                if (controlsState.isControlsSeparatorRendered() && 
	                		(controlsState.isFastForwardRendered() || controlsState.isLastRendered())) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-dscr-sepctrl rich-datascr-ctrls-separator" );
			
UIComponent indexChildren_19 = component.getFacet("controlsSeparator");
if (null != indexChildren_19 && indexChildren_19 .isRendered()) {
	renderChild(context, indexChildren_19);
}

writer.endElement("td");

	                }
	                }                
	                

	                if (controlsState.isFastForwardRendered()){                       
	                if (controlsState.isFastForwardEnabled()){                                                                                                                       
	                  variables.setVariable("onclick", getOnClick(context,component,component.FAST_FORWARD_FACET_NAME));
	                  variables.setVariable("buttonClass", "");  
	                  variables.setVariable("facet", component.FAST_FORWARD_FACET_NAME);                                    
	                  facet=component.FAST_FORWARD_FACET_NAME;                                                      
	                }
	                else{
	                  variables.setVariable("onclick", "");  
	                  variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                  variables.setVariable("facet", component.FAST_FORWARD_DISABLED_FACET_NAME);                                    
	                  facet=component.FAST_FORWARD_DISABLED_FACET_NAME;                                                      
	                }
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.FAST_FORWARD_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_20 = component.getFacet("fastforward");
if (null != indexChildren_20 && indexChildren_20 .isRendered()) {
	renderChild(context, indexChildren_20);
}


						     }else{
					       
UIComponent indexChildren_21 = component.getFacet("fastforward_disabled");
if (null != indexChildren_21 && indexChildren_21 .isRendered()) {
	renderChild(context, indexChildren_21);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
                    
	                      writer.write("&#187;");                      
	                    
writer.endElement("td");

	                }
	                
	                if (controlsState.isControlsSeparatorRendered() && controlsState.isLastRendered()) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-dscr-sepctrl rich-datascr-ctrls-separator" );
			
UIComponent indexChildren_22 = component.getFacet("controlsSeparator");
if (null != indexChildren_22 && indexChildren_22 .isRendered()) {
	renderChild(context, indexChildren_22);
}

writer.endElement("td");

	                }
	                }                
	                

	                if (controlsState.isLastRendered()){                       
	                if (controlsState.isLastEnabled()){                                                                                                                                                             
	                  variables.setVariable("onclick", getOnClick(context,component,component.LAST_FACET_NAME));                                        
	                  variables.setVariable("buttonClass", "");  
	                  variables.setVariable("facet", component.LAST_FACET_NAME);                                    
	                  facet=component.LAST_FACET_NAME;                                                                                          
	                }else{
	                  variables.setVariable("onclick", "");                                                            
	                  variables.setVariable("buttonClass", "dr-dscr-button-dsbld rich-datascr-button-dsbld");  
	                  variables.setVariable("facet", component.LAST_DISABLED_FACET_NAME);                                    
	                  facet=component.LAST_DISABLED_FACET_NAME;                                                                        
	                }
	                if(component.getFacet(facet)!=null ) {
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			

						     if(component.LAST_FACET_NAME.equals(facet)){
					       
UIComponent indexChildren_23 = component.getFacet("last");
if (null != indexChildren_23 && indexChildren_23 .isRendered()) {
	renderChild(context, indexChildren_23);
}


						     }else{
					       
UIComponent indexChildren_24 = component.getFacet("last_disabled");
if (null != indexChildren_24 && indexChildren_24 .isRendered()) {
	renderChild(context, indexChildren_24);
}


						     }
					       
writer.endElement("td");

	                }else{
	                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", convertToString(variables.getVariable("buttonClass")) + " dr-dscr-button rich-datascr-button" );
						getUtils().writeAttribute(writer, "onclick", variables.getVariable("onclick") );
			
                    
	                          writer.write("&#187;&#187;");                      
	                        
writer.endElement("td");

	                }
	                }                
	                
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

			
			}
					                                               
	    
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIDatascroller)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
