package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIToolBar;

public class HtmlToolBar extends UIToolBar{

public final static  String COMPONENT_FAMILY = "org.richfaces.ToolBar";

public final static  String COMPONENT_TYPE = "org.richfaces.ToolBar";

/*
* A CSS style is to be applied to each element of tool bar content. 
    		Use this style, for example, to setup parameters of the font.
*/
private  String _contentClass = null;

/*
* A CSS style is to be applied to each element of tool bar content.
*/
private  String _contentStyle = null;

/*
* A height of a bar in pixels. If a height is not defined,
    		a bar height depends of the "headerFontSize" skin parameter.
*/
private  String _height = null;

/*
* A separator between items on a bar. Possible values
    		are none, line, square, disc and grid.
*/
private  String _itemSeparator = null;

/*
* A CSS class to be applied to tool bar separators.
*/
private  String _separatorClass = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* A width of a bar that can be defined in pixels or as percentage. The default value is 100%.
*/
private  String _width = null;


public HtmlToolBar(){
setRendererType("org.richfaces.ToolBarRenderer");
}

public String getContentClass(){
	if (this._contentClass != null) {
		return this._contentClass;
	}
	ValueExpression ve = getValueExpression("contentClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentClass(String _contentClass){
this._contentClass = _contentClass;
}

public String getContentStyle(){
	if (this._contentStyle != null) {
		return this._contentStyle;
	}
	ValueExpression ve = getValueExpression("contentStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setContentStyle(String _contentStyle){
this._contentStyle = _contentStyle;
}

public String getHeight(){
	if (this._height != null) {
		return this._height;
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setHeight(String _height){
this._height = _height;
}

public String getItemSeparator(){
	if (this._itemSeparator != null) {
		return this._itemSeparator;
	}
	ValueExpression ve = getValueExpression("itemSeparator");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "none";
	

}

public void setItemSeparator(String _itemSeparator){
this._itemSeparator = _itemSeparator;
}

public String getSeparatorClass(){
	if (this._separatorClass != null) {
		return this._separatorClass;
	}
	ValueExpression ve = getValueExpression("separatorClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSeparatorClass(String _separatorClass){
this._separatorClass = _separatorClass;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "100%";
	

}

public void setWidth(String _width){
this._width = _width;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[9];
state[0] = super.saveState(context);
state[1] = _contentClass;
state[2] = _contentStyle;
state[3] = _height;
state[4] = _itemSeparator;
state[5] = _separatorClass;
state[6] = _style;
state[7] = _styleClass;
state[8] = _width;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_contentClass = (String)states[1];;
		_contentStyle = (String)states[2];;
		_height = (String)states[3];;
		_itemSeparator = (String)states[4];;
		_separatorClass = (String)states[5];;
		_style = (String)states[6];;
		_styleClass = (String)states[7];;
		_width = (String)states[8];;
	
}

}
