package org.richfaces.renderkit.html.iconimages;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

import org.ajax4jsf.resource.ResourceContext;

public class ScrollableDataTableIconSplit extends ScrollableDataTableIconBasic {

	public Dimension calculateDimensions() {
		return new Dimension(2, 13);
	}
	
	protected void paint(ResourceContext context, Graphics2D g2d) {
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
		
		Object [] data = (Object[]) restoreData(context);
		Color col1 = (Color)data[0];
		Color col2 = (Color)data[1];
		
		g2d.setColor(col2);
		g2d.drawLine(0, 0, 0, 12);
		g2d.setColor(col1);
		g2d.drawLine(1, 0, 1, 12);
	}
	
}
