/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.InputNumberSliderRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.InputNumberSliderRenderer
 */
public class InputNumberSliderRenderer extends InputNumberSliderRendererBase {

	public InputNumberSliderRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/slider.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("script/SliderScript.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/events.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIInputNumberSlider.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIInputNumberSlider component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("spacer", getResource( "/org/richfaces/renderkit/html/images/spacer.gif" ).getUri(context, component) );

variables.setVariable("arrow", getResource( "org.richfaces.renderkit.html.images.SliderArrowImage" ).getUri(context, component) );

variables.setVariable("arrowSelected", getResource( "org.richfaces.renderkit.html.images.SliderArrowSelectedImage" ).getUri(context, component) );


        String inputPosition = (String)component.getAttributes().get("inputPosition");
        if (!"left".equals(inputPosition) && !"right".equals(inputPosition)) {
        	inputPosition = "right";
        }

        boolean disabled = attributeToBoolean(component, "disabled");
        boolean showInput = attributeToBoolean(component, "showInput");
        boolean manualInput = attributeToBoolean(component, "enableManualInput");

        variables.setVariable("inputReadOnly",new Boolean(!manualInput));
        variables.setVariable("inputDisabled",new Boolean(disabled));

        if (!manualInput || disabled){
            variables.setVariable("color", "color: gray;");
        }
        else{
            variables.setVariable("color", "");
        }

        variables.setVariable("inputSize", component.getAttributes().get("inputSize"));
	variables.setVariable("style", this.getStyleValue(context, component));

    
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "dr-insldr rich-slider " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", variables.getVariable("style") );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "border" ,
	    "cellpadding" ,
	    "cellspacing" ,
	    "dir" ,
	    "frame" ,
	    "lang" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "rules" ,
	    "summary" ,
	    "title" ,
	    "xml:lang" });
//
//
//

writer.startElement("tbody", component);

writer.startElement("tr", component);


                    if ("left".equalsIgnoreCase(inputPosition)) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "rowspan", "2" );
						getUtils().writeAttribute(writer, "style", "text-align: right; vertical-align: bottom" );
			

                    if (showInput) {
                    
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "dr-insldr-field dr-insldr-field-left rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                            } else {
                                
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

                    }
                    
writer.endElement("td");

                    }
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-left-num rich-inslider-left-num " + convertToString(component.getAttributes().get("boundClass")) );
			

				    if (attributeToBoolean(component, "showBoundaryValues")){
                
writer.writeText(convertToString(component.getAttributes().get("minValue")),null);


				    }
                
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-right-num rich-inslider-right-num " + convertToString(component.getAttributes().get("boundClass")) );
			

				    if (attributeToBoolean(component, "showBoundaryValues")){
                
writer.writeText(convertToString(component.getAttributes().get("maxValue")),null);


				    }
                
writer.endElement("td");

                    if ("right".equalsIgnoreCase(inputPosition)) {
                
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "rowspan", "2" );
						getUtils().writeAttribute(writer, "style", "text-align: left; vertical-align: bottom" );
			

					if (showInput) {
					
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "dr-insldr-field dr-insldr-field-right rich-inslider-field " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "disabled", variables.getVariable("inputDisabled") );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "maxlength", component.getAttributes().get("maxlength") );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onclick", component.getAttributes().get("oninputclick") );
						getUtils().writeAttribute(writer, "ondblclick", component.getAttributes().get("oninputdblclick") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("oninputkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("oninputkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("oninputkeyup") );
						getUtils().writeAttribute(writer, "onmousedown", component.getAttributes().get("oninputmousedown") );
						getUtils().writeAttribute(writer, "onmousemove", component.getAttributes().get("oninputmousemove") );
						getUtils().writeAttribute(writer, "onmouseout", component.getAttributes().get("oninputmouseout") );
						getUtils().writeAttribute(writer, "onmouseover", component.getAttributes().get("oninputmouseover") );
						getUtils().writeAttribute(writer, "onmouseup", component.getAttributes().get("oninputmouseup") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "readonly", variables.getVariable("inputReadOnly") );
						getUtils().writeAttribute(writer, "size", variables.getVariable("inputSize") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("inputStyle")) + "; " + convertToString(variables.getVariable("color")) );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

							} else {
								
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Input" );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");

					}
					
writer.endElement("td");

                    }
                
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-size dr-insldr-vert-spacer" );
						getUtils().writeAttribute(writer, "colspan", "2" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "dr-insldr-size" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Track" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "style", "position : relative" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-tip rich-inslider-tip " + convertToString(component.getAttributes().get("tipClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Tip" );
						getUtils().writeAttribute(writer, "style", "display: none;" + convertToString(component.getAttributes().get("tipStyle")) );
			

                                              writer.write("&nbsp;");
                                            
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-handler rich-inslider-handler " + convertToString(component.getAttributes().get("handleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Handle" );
			

                                              writer.write("&nbsp;");
                                            
writer.endElement("div");
writer.endElement("div");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-track rich-inslider-track " + convertToString(component.getAttributes().get("barClass")) );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("barStyle") );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "dr-insldr-track-decor-1" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-insldr-track-decor-2" );
			
writer.startElement("img", component);
			getUtils().writeAttribute(writer, "src", variables.getVariable("spacer") );
						getUtils().writeAttribute(writer, "style", "display: block;" );
			
writer.endElement("img");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.Slider(\n															\"" + convertToString(clientId) + "Handle\",\n															\"" + convertToString(clientId) + "Track\",\n															\"" + convertToString(clientId) + "Tip\",\n															\"" + convertToString(clientId) + "\",\n															\"" + convertToString(component.getAttributes().get("handleSelectedClass")) + "\",\n															{\n																range			: $R(" + convertToString(component.getAttributes().get("minValue")) + "," + convertToString(component.getAttributes().get("maxValue")) + "),\n																step			: \"" + convertToString(component.getAttributes().get("step")) + "\",\n																sliderValue		: \"" + convertToString(getInputValue(context,component)) + "\",\n																disabled		: " + convertToString(component.getAttributes().get("disabled")) + ",\n																currValue		: " + convertToString(component.getAttributes().get("showToolTip")) + ",\n																inputId			: \"" + convertToString(clientId) + "Input\",\n																arrowSelected	: \"" + convertToString(variables.getVariable("arrowSelected")) + "\",\n																onerr			: \"" + convertToString(component.getAttributes().get("onerror")) + "\",\n																onchange		: \"" + convertToString(component.getAttributes().get("onchange")) + "\",\n																required		:	" + convertToString(component.getAttributes().get("required")) + "\n															})"),null);

writer.endElement("script");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIInputNumberSlider)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
