/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.Draggable;
import org.richfaces.component.Dropzone;
import org.richfaces.event.DnDEvent;
import org.richfaces.event.DragEvent;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDEventsExchangeMailer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DraggableRendererContributor
implements RendererContributor {
    public static final String DRAG_SOURCE_ID = "dragSourceId";
    private static final DnDEventsExchangeMailer.EventCallback dragEventsCallback = new DnDEventsExchangeMailer.EventCallback(){

        void processEvent(DnDEvent dndEvent, UIComponent source, FacesContext facesContext, Object type, Object value) {
            DragEvent dragEvent = (DragEvent)dndEvent;
            dragEvent.setDropTarget((Dropzone)source);
            dragEvent.setDropValue(value);
            dragEvent.setAcceptedTypes(type);
        }
    };
    private static DraggableRendererContributor instance;
    static /* synthetic */ Class class$org$ajax4jsf$javascript$PrototypeScript;
    static /* synthetic */ Class class$org$ajax4jsf$javascript$DnDScript;
    static /* synthetic */ Class class$org$richfaces$component$Draggable;

    private DraggableRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DraggableRendererContributor();
        }
        return instance;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        Map paramMap;
        DnDEventsExchangeMailer eventsExchanger = DnDEventsExchangeMailer.getInstance(context);
        String clientId = component.getClientId(context);
        if (clientId.equals((paramMap = context.getExternalContext().getRequestParameterMap()).get(DRAG_SOURCE_ID))) {
            String dropTargetId = (String)paramMap.get("dropTargetId");
            if (compositeRenderer != null) {
                compositeRenderer.contributorDecodeCallback(component, context, (RendererContributor)this, (Object)dropTargetId);
            }
            Draggable draggable = (Draggable)component;
            eventsExchanger.mailEvent(dropTargetId, component, context, (DnDEvent)new DragEvent(component), dragEventsCallback, draggable.getDragType(), draggable.getDragValue(), true);
        }
    }

    public String[] getStyleDependencies() {
        return new String[]{"/org/richfaces/renderkit/html/css/dragIndicator.xcss"};
    }

    public String[] getScriptDependencies() {
        return new String[]{(class$org$ajax4jsf$javascript$PrototypeScript == null ? (class$org$ajax4jsf$javascript$PrototypeScript = DraggableRendererContributor.class$("org.ajax4jsf.javascript.PrototypeScript")) : class$org$ajax4jsf$javascript$PrototypeScript).getName(), "/org/richfaces/renderkit/html/scripts/json/json-mini.js", (class$org$ajax4jsf$javascript$DnDScript == null ? (class$org$ajax4jsf$javascript$DnDScript = DraggableRendererContributor.class$("org.ajax4jsf.javascript.DnDScript")) : class$org$ajax4jsf$javascript$DnDScript).getName(), "/org/richfaces/renderkit/html/scripts/utils.js", "/org/richfaces/renderkit/html/scripts/json/json-dom.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-draggable.js"};
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent component) {
        if (component instanceof Draggable) {
            UIComponent indicator;
            String simpleId;
            Draggable draggable = (Draggable)component;
            DraggableOptions options = new DraggableOptions(draggable);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
            HashMap<String, String> parameters = (HashMap<String, String>)eventOptions.get("parameters");
            if (parameters == null) {
                parameters = new HashMap<String, String>();
            }
            String clientId = component.getClientId(context);
            parameters.put(DRAG_SOURCE_ID, clientId);
            options.addOption("parameters", parameters);
            String indicatorId = draggable.getResolvedDragIndicator(context);
            if (indicatorId == null && (simpleId = draggable.getDragIndicator()) != null && (indicator = RendererUtils.getInstance().findComponentFor(component, simpleId)) != null) {
                indicatorId = indicator.getClientId(context);
            }
            if (indicatorId != null) {
                options.addOption("dragIndicator", indicatorId);
            }
            return options;
        }
        return null;
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public Class getAcceptableClass() {
        return class$org$richfaces$component$Draggable == null ? (class$org$richfaces$component$Draggable = DraggableRendererContributor.class$("org.richfaces.component.Draggable")) : class$org$richfaces$component$Draggable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DraggableOptions
    extends ScriptOptions {
        public DraggableOptions(Draggable draggable) {
            super((UIComponent)draggable);
            this.addOption("dragType", draggable.getDragType());
            this.addEventHandler("ondragstart", draggable.getOndragstart());
            this.addEventHandler("ondragend", draggable.getOndragend());
        }
    }
}

