if(!window.Richfaces) window.Richfaces = {};
Richfaces.disableSelectionText = function(target) {
	target.onselectstart = function(e) {
		e = window.event||e;
		if (e.srcElement) {
			if (e.srcElement.tagName) {
				var tagName = e.srcElement.tagName.toUpperCase();
				
				if (tagName != "INPUT" && tagName != "TEXTAREA" /* any items more? */) {
					return false;
				}
			}
		}
	}
}

Richfaces.ListBase = Class.create();

Richfaces.ListBase.compare = function(obj1, obj2) {
	return ((obj1 == obj2) ? 0 : ((obj1 < obj2) ? -1 : 1));
}

Richfaces.ListBase.ORDERING_LIST_CLASSES = {
	normal : "rich-ordering-list-items",
	disabled : "rich-ordering-list-disabled",
	active :  "rich-ordering-list-active"
}

Richfaces.ListBase.ASC = "acs";
Richfaces.ListBase.DESC = "desc";

Richfaces.ListBase.CONTROL_SET = ["A", "INPUT", "TEXTAREA", "SELECT", "OPTION", "BUTTON"];

Richfaces.ListBase.prototype = {
	initialize : function(containerId, contentTableId, headerTableId, focusKeeperId, 
				   		  onclickControlId, controlClass) {
		this.selectedItems = new Array();
		
		//this.layoutManager = layoutManager;
		this.container = $(containerId);
		this.shuttleTable = $(contentTableId);
		Richfaces.disableSelectionText(this.shuttleTable);
		this.focusKeeper = $(focusKeeperId);
		this.focusKeeper.focused = false;
		//this.setFocus();
		this.focusKeeper.observe("keydown", (function(e) {this.onkeydownHandler(window.event || e)}).bindAsEventListener(this));
		this.focusKeeper.observe("blur", function (e) {this.focusListener(e);}.bindAsEventListener(this));
		this.focusKeeper.observe("focus", function (e) {this.onfocusHandler(e);}.bindAsEventListener(this));
		
		this.shuttleTbody = this.shuttleTable.tBodies[0];
		
		this.activeItem = null;
		this.items = null;

		this.retrieveShuttleItems(containerId, controlClass);
		
		this.shuttle = null;
		this.sortOrder = Richfaces.ListBase.ASC;
		this.clckHandler = function(e) {this.onclickHandler(window.event || e)}.bindAsEventListener(this);
		this.shuttleTable.observe("click", this.clckHandler);
	},
	
	retrieveShuttleItems : function(containerId, controlClass) {
		var rows = this.shuttleTbody.rows;
		this.shuttleItems = new Array();
		var id;
		
		for (var i = 0; i < rows.length; i++) {
			var row = rows[i];
			id = row.id.split(containerId + ":")[1];
			var item = new controlClass(null, (id || i), row);
			if (item.isSelected()) {
				this.selectedItems.push(row);
			}									  
			if (item.isActive()) {
				this.activeItem = row;
			}
			this.shuttleItems[i] = item;
		}	
	},
	
	getExtremeItem : function(position) { //FIXME
		var extremeItem = this.selectedItems[0];
		var currentItem;
		
		for (var i = 1; i < this.selectedItems.length; i++) {
			currentItem = this.selectedItems[i];
			if (position == "first") {
				if (currentItem.rowIndex < extremeItem.rowIndex) {
					extremeItem = currentItem;
				}
			} else {
				if (currentItem.rowIndex > extremeItem.rowIndex) {
					extremeItem = currentItem;
				}
			}
		}
		return extremeItem; 
	},
	
	getEventTargetRow : function(event) {
		var activeElem;
		if (event.rangeParent) {
			//activeElem = event.rangeParent.parentNode;
			activeElem = event.target;		
		} else {
			activeElem = event.srcElement;
		}
		
		if (activeElem == null) {
			return;
		}
		
		if (activeElem.tagName && Richfaces.ListBase.CONTROL_SET.indexOf(activeElem.tagName) != -1) {
			return;
		}
			
		while (activeElem.tagName.toLowerCase() != "tr") {
			activeElem = activeElem.parentNode;
			if (!activeElem.tagName) {
				return; //for IE
			}
		}
		return activeElem;
	},
	
	onfocusHandler: function (event) {
		if (!this.activeItem && this.shuttleItems.length != 0) {
			this.activeItem = this.shuttleItems[0]._node;
			
		}

		if (this.activeItem) {
			this.activeItem.item.doActive();
		}
	},
	
	onclickHandler : function(event) {
		if (event.srcElement && (event.srcElement.tagName.toLowerCase() == "tbody")) {
			return;
		}
		var activeElem = this.getEventTargetRow(event);
		if (activeElem != null) {
			
			if (event.ctrlKey) {
			 	this.addSelectedItem(activeElem);
				this.activeItem = activeElem;
			} else if (event.shiftKey) {
				this.selectItemGroup(activeElem);
			} else {
				this.selectionItem(activeElem);
				this.activeItem = activeElem;		
			}
			
			
			this.setFocus();
			
			this.saveState();
			//this.layoutManager.widthSynchronization();
		}
	},

	onkeydownHandler : function(event) {
		var action = null;
		switch (event.keyCode) {
			case 38 : //up arrow
					  action = 'up';
					  this.moveActiveItem(action, event);
					  break;
			case 40 : //down arrow
					  action = 'down';
					  this.moveActiveItem(action, event);
					  break;
			case 65 : // Ctrl + A
					  if (event.ctrlKey) { 
						this.selectAll();
						Event.stop(event);
					  } 
					  this.activeItem.item.doActive();
					  this.saveState();
					  break; 
		}
	},
	
	moveActiveItem : function(action, event) {
		var item = this.activeItem;
		var rows = this.shuttleTbody.rows;
		if ((action == 'up') && (item.rowIndex > 0)) {
			this.changeActiveItems(rows[item.rowIndex - 1], item);
		} else if ((action == 'down') && (item.rowIndex < this.shuttleItems.length - 1)) {
			this.changeActiveItems(rows[item.rowIndex + 1], item);
		}
		
		this.autoScrolling(action, event);
		
		this.saveState();
		//this.layoutManager.widthSynchronization();
	},

	changeActiveItems : function(newItem, item) {
		this.resetMarked();
		
		newItem.item.doSelect();
		newItem.item.doActive();
		this.activeItem = newItem;
		this.selectedItems.push(newItem);
	},
	
	selectAll : function() {
		var startIndex = 0;
		var endIndex = this.shuttleItems.length - 1;
		this.selectItemRange(startIndex, endIndex);
	},
	
	/**
	 * Click handler
	 */
	selectionItem : function(activeItem) {
		//var markedItem = this.getSelectItemByNode(activeItem);
		var markedShuttleItem = activeItem;
		
		//if (markedItem != null) {
			this.resetMarked();
			/*if (markedItem._selected) {
				markedItem._selected = false;
			} else {
				markedItem._selected = true;
				this.selectedItems[0] = markedShuttleItem;
			}*/
			if (activeItem.item.isSelected()) {
				activeItem.item.doNormal();
			} else {
				activeItem.item.doSelect();
				this.selectedItems[0] = markedShuttleItem; //TODO: delete 
			}
		//}
	},
	
	/**
	 * CTRL+Click handler
	 */
	addSelectedItem : function(activeItem) {
		//var markedItem = this.getSelectItemByNode(activeItem);
		var markedShuttleItem = activeItem;
		
		/*if (markedItem._selected) {
			this.selectedItems.remove(markedShuttleItem);
			markedItem._selected = false;
		} else {
			markedItem._selected = true;
			this.selectedItems.push(markedShuttleItem);
		}*/
		
		if (activeItem.item.isSelected()) {
			this.selectedItems.remove(markedShuttleItem); //TODO :delete
			activeItem.item.doNormal();
		} else {
			activeItem.item.doSelect();
			this.selectedItems.push(markedShuttleItem); //TODO :delete
		}
		
		if ((this.activeItem != null) && (this.activeItem.rowIndex != activeItem.rowIndex)) {
			//reset activity of an element
			if (this.activeItem.item.isSelected()) {
				this.activeItem.item.doSelect(); 			
			} else {
				this.activeItem.item.doNormal();				
			}
		}
		
		/*if (this.activeItem && !this.getSelectItemByNode(this.activeItem)._selected) {
			Richfaces.SelectItems.doNormal(this.activeItem);
		}*/
		this.saveState();
	},
	
	/**
	 * Shift+Click handler
	 */
	selectItemGroup : function(currentItem) {
		//FIXME
		var activeItemIndex = this.activeItem.rowIndex;
		var startIndex;
		var endIndex;
		
		if (currentItem.rowIndex > activeItemIndex) {
			startIndex = activeItemIndex;
			endIndex = currentItem.rowIndex;
		} else {
			startIndex = currentItem.rowIndex;
			endIndex = activeItemIndex;
		}
		
		this.resetMarked();
		
		this.selectItemRange(startIndex, endIndex);
	},
	
	selectItemRange : function(startIndex, endIndex) {
		var rows = this.shuttleTbody.rows;
		for (var i = startIndex; i <= endIndex; i++) {
			rows[i].item.doSelect();
			if (this.selectedItems.indexOf(rows[i]) == -1) {
				this.selectedItems.push(rows[i]);
				//this.getSelectItemByNode(rows[i])._selected = true;
			}
		}	
		
		this.saveState();
	},
	
	resetMarked : function() {
		var rows = this.shuttleTbody.rows;
		for (var i = 0; i < rows.length; i++) {
			var shuttleItem = rows[i]; 
			shuttleItem.item.doNormal();
			//this.getSelectItemByNode(shuttleItem)._selected = false; //FIXME
		}	
		this.selectedItems.length = 0;
		
		//need to reset active item
	},
	
	getSelectItemByNode : function(selectItemNode) {
		for (var i = 0; i < this.shuttleItems.length; i++) {
			var item = this.shuttleItems[i];
			if (selectItemNode.rowIndex == item._node.rowIndex) {
				return item;
			}
		}
		return null;
	},
	
	autoScrolling : function(action, event) {
		this.selectedItems.sort(this.compareByRowIndex);
		var increment;
		var scrollTop = this.shuttleTable.parentNode.scrollTop;
		
		var shuttleTop = LayoutManager.getElemXY(this.shuttleTable.parentNode).top;
		
		if (action == 'up' || action == 'first') {
			var targetItemTop = LayoutManager.getElemXY(this.selectedItems[0]).top;
			increment = (targetItemTop - scrollTop) - shuttleTop;
			if (increment < 0) {
				this.shuttleTable.parentNode.scrollTop += increment;			
			}
		} else if (action == 'down' || action == 'last') {
			var item = this.selectedItems[this.selectedItems.length - 1];
			var targetItemBottom = LayoutManager.getElemXY(this.selectedItems[this.selectedItems.length - 1]).top + item.offsetHeight;
			var increment = (targetItemBottom - scrollTop) - (shuttleTop + this.shuttleTable.parentNode.clientHeight);
			if (increment > 0) {
				this.shuttleTable.parentNode.scrollTop += increment;			
			} 
		}
		Event.stop(event);
	},
	
	setFocus : function() {
		this.focusKeeper.focus();
		this.focusKeeper.focused = true;
		//if (this.isListActive()) {
		//	this.shuttleTable.className = Richfaces.ListBase.ORDERING_LIST_CLASSES.active;
		//}
	},
	
	focusListener : function(e) {
		e = e || window.event;
		this.focusKeeper.focused = false;
		//this.shuttleTable.className = Richfaces.ListBase.ORDERING_LIST_CLASSES.normal;
		
		if (this.activeItem) {
			if (this.activeItem.item.isSelected()) {
				this.activeItem.item.doSelect();			
			} else {
				this.activeItem.item.doNormal();
			}
		}
	},
	
	compareByLabel : function(obj1, obj2) {
		obj1 = obj1._label;
		obj2 = obj2._label;
		return Richfaces.ListBase.compare(obj1, obj2);
	},
	
	compareByRowIndex : function(obj1, obj2) {
		obj1 = obj1.rowIndex;
		obj2 = obj2.rowIndex;
		return Richfaces.ListBase.compare(obj1, obj2);
	},
	
	isListActive : function() {
		if ((this.activeItem != null || this.selectedItems.length != 0) && this.focusKeeper.focused) {
			return true;
		}
		return false;
	},
	
	saveState : function() {
		for (var i = 0; i < this.shuttleItems.length; i++) {
			var item = this.shuttleItems[i];
			
			item.saveState();
		}		
	}
	
}


