/**
 * 
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.richfaces.component.UIRichMessages;
import org.richfaces.renderkit.RichMessageBaseRenderer;

/**
 * @author Anton Belevich
 *
 */
public class HtmlRichMessagesRenderer extends RichMessageBaseRenderer {
	
	private boolean isWroteTable = false;
	
	protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		
		String forIds = null;
		Iterator messagesIter = null;
		
		
		UIRichMessages uiMessages = (UIRichMessages)component;
		
		if(uiMessages.isGlobalOnly()){
			forIds = "";
		}
		
		messagesIter = getMessageIterator(context, forIds, component);
		
		renderComponentUI(writer, context, component, messagesIter);
	}
	
	public void renderComponentUI(ResponseWriter writer, FacesContext context, UIComponent component, Iterator messagesIter) throws IOException{
		
		String layout = null;
		

		UIRichMessages uiMessages = (UIRichMessages)component;
		 
		boolean isDisplayNone = (!messagesIter.hasNext() && !uiMessages.isPassed()) ? true : false; 
		
		if(!isDisplayNone){
			String [] levels = uiMessages.getLevel().split(","); 
			acceptLevels = creatAcceptLevels(levels);
		}
				
		layout = (String)uiMessages.getAttributes().get("layout");
		if((layout != null) && (layout.equals("table"))){
			 
			writer.startElement("table", uiMessages);
			getUtils().writeAttribute(writer,HTML.id_ATTRIBUTE ,uiMessages.getClientId(context));
			getUtils().writeAttribute(writer, HTML.cellpadding_ATTRIBUTE, "0");
			getUtils().writeAttribute(writer, HTML.cellspacing_ATTRIBUTE, "0");
			renderComponentOuterStyles(uiMessages, context, writer, isDisplayNone);
			writer.startElement("tbody", uiMessages);
			isWroteTable = true;

		}else if((layout != null) && (layout.equals("list"))){
			
			isWroteTable = false;
			writer.startElement("dl", uiMessages);
			getUtils().writeAttribute(writer,HTML.id_ATTRIBUTE ,uiMessages.getClientId(context));
			renderComponentOuterStyles(uiMessages, context, writer, isDisplayNone);
		
		}
				
		if(!messagesIter.hasNext()){
			renderBody(uiMessages, context, writer, null);
		}else{
			
			while(messagesIter.hasNext()){
				FacesMessage facesMsg = (FacesMessage)(messagesIter.next());
							
				renderBody(uiMessages, context, writer, facesMsg);
			}
		
		}	
		
		if(isWroteTable){
			writer.endElement("tbody");
			writer.endElement("table");
		}else{
			writer.endElement("dl");
		}
	
	}
	
	
	
	public void renderLabelHtml(UIComponent component, FacesContext context, ResponseWriter writer, 
								FacesMessage facesMsg, String labelClass, String labelStyle, String passLabel) throws IOException {
		
		String summary = null;
		
		String detail = null; 
		
		String title = null;
		
		UIRichMessages uiMessages = null;
		
		
		if(!(component instanceof UIRichMessages)){
			return;
		}
		
		uiMessages = (UIRichMessages)component;
		
		boolean isTooltip = getUtils().isBooleanAttribute(uiMessages, "tooltip");
		boolean showSummary = uiMessages.isShowSummary();
		boolean showDetail = uiMessages.isShowDetail();
		
		if(facesMsg != null){
			summary = (null != (summary = facesMsg.getSummary())) ? summary : "";
			detail = (null != (detail = facesMsg.getDetail())) ? detail : "";
		}	   
		   
		labelClass = labelClass == null ? "rich-messages-label" : "rich-messages-label " + labelClass;
		writer.startElement(HTML.SPAN_ELEM, uiMessages);
		getUtils().writeAttribute(writer, HTML.class_ATTRIBUTE,labelClass);
		getUtils().writeAttribute(writer, HTML.style_ATTRIBUTE, labelStyle);
		
		if(facesMsg != null){
			
			if(isTooltip){
					
				title = (String) uiMessages.getAttributes().get("title");
				if(title != null){
					getUtils().writeAttribute(writer, HTML.title_ATTRIBUTE, title);
				}else{
					getUtils().writeAttribute(writer, HTML.title_ATTRIBUTE, summary); 
				}
				
			}
		   
			if(showDetail){
				writer.writeText(detail, null);
				writer.writeText("\t", null);
			}
			   
			if(showSummary){
				writer.writeText(summary, null);
				writer.writeText("\t", null);
			}
			
		}else {    
			   
			if(passLabel != null){
				writer.writeText(passLabel, null);
				writer.writeText("\t", null);
			}
			
		}
		
		writer.endElement(HTML.SPAN_ELEM);
		
	}

	public void renderMarkerHtml(UIComponent component, UIComponent markerFacet, FacesContext context,
								 ResponseWriter writer, String markerClass, String markerStyle)throws IOException {
		
		UIRichMessages uiMessages = null;
		
		if(!(component instanceof UIRichMessages)){
			return;
		}
		
		uiMessages = (UIRichMessages)component;
		writer.startElement(HTML.SPAN_ELEM, uiMessages);
		String classes = markerClass == null ? "rich-messages-marker" : "rich-messages-marker " + markerClass;
		getUtils().writeAttribute(writer, HTML.class_ATTRIBUTE, classes);
		getUtils().writeAttribute(writer, HTML.style_ATTRIBUTE, markerStyle);
		renderChild(context, markerFacet);
		writer.endElement(HTML.SPAN_ELEM);
		
	}
	
	public void renderComponentOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, boolean isDisplayNone)	throws IOException {
		
		UIRichMessages uiMessages = null;
		String displayStyle = null;
		
		
		if(!(component instanceof UIRichMessages)){
			return;
		}
		
		uiMessages = (UIRichMessages)component;
	
		if(isDisplayNone){
			displayStyle = "display: none";
		}
		
		String parentStyle = (String)uiMessages.getAttributes().get("style");
		String parentClass = (String)uiMessages.getAttributes().get("styleClass");
		
		if(displayStyle != null){
			parentStyle = (displayStyle != null) ? displayStyle + ";" + parentStyle : parentStyle;
		}
		
		String richMessageClass = "rich-messages";
		parentClass = parentClass != null ? (richMessageClass + " " + parentClass) : richMessageClass;    
		   
		getUtils().writeAttribute(writer, HTML.class_ATTRIBUTE, parentClass);
		getUtils().writeAttribute(writer, HTML.style_ATTRIBUTE, parentStyle);
		
	}
	
	public void renderOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, 
	           					  String outerStyle, String outerClass)	throws IOException {
		
		String richMessageClass = null != outerClass ? outerClass:"";
		String richMessageStyle = (null != outerStyle ? outerStyle : "");
		  
		getUtils().writeAttribute(writer, HTML.class_ATTRIBUTE, richMessageClass);
		getUtils().writeAttribute(writer, HTML.style_ATTRIBUTE, richMessageStyle);
		
	}
	
	public void renderBody(UIRichMessages uiMessages, FacesContext context, ResponseWriter writer,FacesMessage facesMsg) throws IOException{
		
		if(uiMessages.isPassed() || facesMsg != null ){		
		
			if(isAcceptableMessage(facesMsg)){
			
				if(isWroteTable){
					writer.startElement(HTML.TR_ELEMENT, uiMessages);
					writer.startElement(HTML.td_ELEM, uiMessages);
				}else{
					writer.startElement("dt", uiMessages);
				}
			
				outerStyles(uiMessages, context, writer, facesMsg);
				renderMarkerFacet(uiMessages, context, writer, facesMsg);	
				renderLabel(uiMessages, context, writer, facesMsg);
				
				if(isWroteTable){
					writer.endElement(HTML.td_ELEM);
					writer.endElement(HTML.TR_ELEMENT);
				}else{
					writer.endElement("dt");
				}
			}		
		}	
	
	}
	
	protected Class getComponentClass() {
		return UIMessages.class;
	}
	
}
