/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.InputRendererBase;



/**
 * Renderer for component class org.richfaces.renderkit.html.InputNumberSpinnerRenderer
 */
public class InputNumberSpinnerRenderer extends InputRendererBase {

	public InputNumberSpinnerRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("script/SpinnerScript.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	private final InternetResource[] styles = {
						getResource("css/spinner.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIInputNumberSpinner.class;
	}


	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIInputNumberSpinner component, ComponentVariables variables) throws IOException {
	  java.lang.String clientId = component.getClientId(context);
variables.setVariable("up_arrow", getResource( "org.richfaces.renderkit.html.images.buttons.SpinnerButtonUp" ).getUri(context, component) );

variables.setVariable("down_arrow", getResource( "org.richfaces.renderkit.html.images.buttons.SpinnerButtonDown" ).getUri(context, component) );

writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "dr-spnr-c rich-spinner-c " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("style") );
						getUtils().writeAttribute(writer, "width", "2%" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-spnr-e  rich-spinner-input-container" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Edit" );
						getUtils().writeAttribute(writer, "width", "1%" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "accesskey", component.getAttributes().get("accesskey") );
						getUtils().writeAttribute(writer, "class", "dr-spnr-i rich-spinner-input " + convertToString(component.getAttributes().get("inputClass")) );
						getUtils().writeAttribute(writer, "name", clientId );
						getUtils().writeAttribute(writer, "onblur", component.getAttributes().get("onblur") );
						getUtils().writeAttribute(writer, "onchange", component.getAttributes().get("onchange") );
						getUtils().writeAttribute(writer, "onfocus", component.getAttributes().get("onfocus") );
						getUtils().writeAttribute(writer, "onselect", component.getAttributes().get("onselect") );
						getUtils().writeAttribute(writer, "size", component.getAttributes().get("inputSize") );
						getUtils().writeAttribute(writer, "style", component.getInputStyle() );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "text" );
						getUtils().writeAttribute(writer, "value", getInputValue(context,component) );
			
writer.endElement("input");
writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-spnr-b" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "For" );
						getUtils().writeAttribute(writer, "width", "1%" );
			
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + "Buttons" );
			
writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);


				                	boolean disabled = ((Boolean) component.getAttributes().get("disabled")).booleanValue();
				                	if (! disabled) {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "class", "dr-spnr-bn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='dr-spnr-bp rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='dr-spnr-bn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='dr-spnr-bn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("up_arrow") );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	} else {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "class", "dr-spnr-bn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("up_arrow") );
						getUtils().writeAttribute(writer, "tabindex", component.getAttributes().get("tabindex") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	}
                				
writer.endElement("td");
writer.endElement("tr");
writer.startElement("tr", component);

writer.startElement("td", component);

				                	
				                	if (! disabled) {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "class", "dr-spnr-bn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "onmousedown", "this.className='dr-spnr-bp rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseout", "this.className='dr-spnr-bn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "onmouseup", "this.className='dr-spnr-bn rich-spinner-button'" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("down_arrow") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	} else {
                				
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "class", "dr-spnr-bn rich-spinner-button" );
						getUtils().writeAttribute(writer, "onclick", "return false" );
						getUtils().writeAttribute(writer, "src", variables.getVariable("down_arrow") );
						getUtils().writeAttribute(writer, "type", "image" );
			
writer.endElement("input");

				                	}
                				
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("new Richfaces.Spinner(\n					{\n						edit:\"" + convertToString(clientId) + "Edit\",\n						buttons:\"" + convertToString(clientId) + "Buttons\",\n						forIE:\"" + convertToString(clientId) + "For\"\n					},\n					{\n						cycled:" + convertToString(component.getAttributes().get("cycled")) + ",\n						edited:" + convertToString(component.getAttributes().get("enableManualInput")) + ",\n						disabled:" + convertToString(component.getAttributes().get("disabled")) + ",\n						chameleon:false,\n						required:	" + convertToString(component.getAttributes().get("required")) + "\n					},				\n					{\n						min:" + convertToString(component.getAttributes().get("minValue")) + ",\n						max:" + convertToString(component.getAttributes().get("maxValue")) + ",\n						delta:" + convertToString(component.getAttributes().get("step")) + "\n					},\n					{\n						onup:\"" + convertToString(component.getAttributes().get("onupclick")) + "\",\n						ondown:\"" + convertToString(component.getAttributes().get("ondownclick")) + "\",\n						onerr:\"" + convertToString(component.getAttributes().get("onerror")) + "\"\n					},\n					{\n						up:\"" + convertToString(variables.getVariable("upButton")) + "\",\n						down:\"" + convertToString(variables.getVariable("downButton")) + "\",\n						upP:\"" + convertToString(variables.getVariable("upButtonPressed")) + "\",\n						downP:\"" + convertToString(variables.getVariable("downButtonPressed")) + "\",\n						upH:\"" + convertToString(variables.getVariable("upButtonHovered")) + "\",\n						downH:\"" + convertToString(variables.getVariable("downButtonHovered")) + "\"\n					}\n					);"),null);

writer.endElement("script");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
writer.endElement("table");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIInputNumberSpinner)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
