/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.resource.InternetResource;
import org.richfaces.component.UIRichMessage;
import org.richfaces.renderkit.RichMessageBaseRenderer;

public class HtmlRichMessageRenderer
extends RichMessageBaseRenderer {
    private final InternetResource[] styles = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/css/msg.css")};
    private InternetResource[] stylesAll = null;
    static /* synthetic */ Class class$javax$faces$component$UIMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        HtmlRichMessageRenderer htmlRichMessageRenderer = this;
        synchronized (htmlRichMessageRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        Iterator msgIter = null;
        UIRichMessage msgComponent = (UIRichMessage)component;
        String forClientId = msgComponent.getFor();
        if (forClientId == null) {
            if (RichMessageBaseRenderer.log.isErrorEnabled()) {
                RichMessageBaseRenderer.log.error((Object)"null parameter ERROR");
            }
        } else {
            msgIter = this.getMessageIterator(context, forClientId, (UIComponent)msgComponent);
            writer.startElement("span", (UIComponent)msgComponent);
            this.getUtils().writeAttribute(writer, "id", (Object)msgComponent.getClientId(context));
            if (!msgIter.hasNext() && msgComponent.isPassed()) {
                this.encodingUIContent(msgComponent, context, null);
            } else if (msgIter.hasNext()) {
                FacesMessage message = (FacesMessage)msgIter.next();
                this.encodingUIContent(msgComponent, context, message);
            }
            writer.endElement("span");
        }
    }

    protected void encodingUIContent(UIRichMessage uiMsg, FacesContext context, FacesMessage facesMsg) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.outerStyles((UIComponent)uiMsg, context, writer, facesMsg);
        this.renderMarkerFacet((UIComponent)uiMsg, context, writer, facesMsg);
        this.renderLabel((UIComponent)uiMsg, context, writer, facesMsg);
    }

    public void renderOuterStyles(UIComponent component, FacesContext context, ResponseWriter writer, String outerStyle, String outerClass) throws IOException {
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        String parentStyle = (String)uiMsg.getAttributes().get("style");
        String parentClass = (String)uiMsg.getAttributes().get("styleClass");
        String richMessageClass = "rich-message" + (null != outerClass ? " " + outerClass : "");
        String richMessageStyle = null != outerStyle ? outerStyle + "," : "";
        parentStyle = parentStyle != null ? richMessageStyle + parentStyle : richMessageStyle;
        parentClass = parentClass != null ? richMessageClass + " " + parentClass : richMessageClass;
        this.getUtils().writeAttribute(writer, "class", (Object)parentClass);
        this.getUtils().writeAttribute(writer, "style", (Object)parentStyle);
    }

    public void renderMarkerHtml(UIComponent component, UIComponent marker, FacesContext context, ResponseWriter writer, String markerClass, String markerStyle) throws IOException {
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        writer.startElement("span", (UIComponent)uiMsg);
        String classes = markerClass == null ? "rich-message-marker" : "rich-message-marker " + markerClass;
        this.getUtils().writeAttribute(writer, "class", (Object)classes);
        this.getUtils().writeAttribute(writer, "style", (Object)markerStyle);
        this.renderChild(context, marker);
        writer.endElement("span");
    }

    public void renderLabelHtml(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg, String labelClass, String labelStyle, String passLabel) throws IOException {
        String summary = null;
        String detail = null;
        String title = null;
        UIRichMessage uiMsg = null;
        if (!(component instanceof UIRichMessage)) {
            return;
        }
        uiMsg = (UIRichMessage)component;
        boolean isTooltip = this.getUtils().isBooleanAttribute((UIComponent)uiMsg, "tooltip");
        boolean showSummary = uiMsg.isShowSummary();
        boolean showDetail = uiMsg.isShowDetail();
        if (facesMsg != null) {
            summary = facesMsg.getSummary();
            summary = null != summary ? summary : "";
            detail = facesMsg.getDetail();
            detail = null != detail ? detail : "";
        }
        String classes = labelClass == null ? "rich-message-label" : "rich-message-label " + labelClass;
        writer.startElement("span", (UIComponent)uiMsg);
        this.getUtils().writeAttribute(writer, "class", (Object)classes);
        this.getUtils().writeAttribute(writer, "style", (Object)labelStyle);
        if (facesMsg != null) {
            if (isTooltip) {
                title = (String)uiMsg.getAttributes().get("title");
                if (title != null) {
                    this.getUtils().writeAttribute(writer, "title", (Object)title);
                } else {
                    this.getUtils().writeAttribute(writer, "title", (Object)summary);
                }
            }
            if (showDetail) {
                writer.writeText((Object)detail, null);
                writer.writeText((Object)"\t", null);
            }
            if (showSummary) {
                writer.writeText((Object)summary, null);
                writer.writeText((Object)"\t", null);
            }
        } else if (passLabel != null) {
            writer.writeText((Object)passLabel, null);
            writer.writeText((Object)"\t", null);
        }
        writer.endElement("span");
    }

    protected Class getComponentClass() {
        return class$javax$faces$component$UIMessage == null ? (class$javax$faces$component$UIMessage = HtmlRichMessageRenderer.class$("javax.faces.component.UIMessage")) : class$javax$faces$component$UIMessage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

