/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.model.ListDataModel;
import org.richfaces.event.DataFilterSliderAdapter;
import org.richfaces.event.DataFilterSliderEvent;
import org.richfaces.event.DataFilterSliderListener;
import org.richfaces.event.DataFilterSliderSource;

public abstract class UIDataFltrSlider
extends UIComponentBase
implements DataFilterSliderSource {
    public static final String COMPONENT_TYPE = "org.richfaces.DataFilterSlider";
    public static final String COMPONENT_FAMILY = "org.richfaces.DataFilterSlider";
    private transient boolean _active = false;
    private transient UIData _UIData;
    static /* synthetic */ Class class$org$richfaces$event$DataFilterSliderListener;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public boolean getRendersChildren() {
        return true;
    }

    public void addSliderListener(DataFilterSliderListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public DataFilterSliderListener[] getSliderListeners() {
        return (DataFilterSliderListener[])this.getFacesListeners(class$org$richfaces$event$DataFilterSliderListener == null ? (class$org$richfaces$event$DataFilterSliderListener = UIDataFltrSlider.class$("org.richfaces.event.DataFilterSliderListener")) : class$org$richfaces$event$DataFilterSliderListener);
    }

    public void removeSliderListener(DataFilterSliderListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataFilterSliderEvent && this.getSliderListeners().length < 1) {
            this.addSliderListener(new DataFilterSliderAdapter(this.getSliderListener()));
        }
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.decode(context);
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    private Map getSession() {
        return this.getFacesContext().getExternalContext().getSessionMap();
    }

    public UIData getUIData() {
        ArrayList ajaxSliderList = (ArrayList)this.getSession().get("UISliderList");
        this._UIData = this.getDataTable();
        if (ajaxSliderList == null) {
            ListDataModel ajaxSliderLDM = new ListDataModel();
            ajaxSliderLDM.setWrappedData(this._UIData.getValue());
            this.getSession().put("UISliderList", ajaxSliderLDM.getWrappedData());
        } else {
            this._UIData.setValue((Object)ajaxSliderList);
        }
        return this._UIData;
    }

    protected UIData getDataTable() {
        String forAttribute = this.getFor();
        UIComponent forComp = forAttribute == null ? this.getParent() : this.findComponent(forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find dataTable with id '" + forAttribute + "'. If you are outside the naming container, try prepending the form name like for=\"form1:tableName\"");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + (class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = UIDataFltrSlider.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData).getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public void resetDataTable() {
        this.getSession().remove("UISliderList");
        this.getDataTable().setValue((Object)this.getDataTable().getValueBinding("#{" + this.getForValRef() + "}"));
    }

    public void filterDataTable(int sliderVal) {
        UIData dataTable = this.getUIData();
        ArrayList filteredDataTable = new ArrayList();
        ArrayList dataTableList = (ArrayList)dataTable.getValue();
        for (int i = 0; i < dataTableList.size(); ++i) {
            Object o = dataTableList.get(i);
            try {
                int objectVal;
                String filterByString = o.getClass().getMethod(this.getFilterBy(), null).invoke(o, null).toString();
                if (filterByString.indexOf(".") > 0) {
                    filterByString = filterByString.substring(0, filterByString.indexOf("."));
                }
                if ((objectVal = Integer.parseInt(filterByString)) >= sliderVal) continue;
                filteredDataTable.add(o);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getDataTable().setValue(filteredDataTable);
    }

    public String getSliderRange() {
        int segmentTotalStart;
        int segmentTotal;
        String sliderValues = "";
        if (this.getStartRange() == 0) {
            segmentTotal = this.getEndRange() / this.getIncrement();
            segmentTotalStart = 0;
        } else {
            segmentTotal = this.getEndRange() / this.getIncrement() - 1;
            segmentTotalStart = this.getStartRange();
        }
        int j = segmentTotalStart;
        for (int i = segmentTotalStart; i <= segmentTotal; ++i) {
            if (i != 0) {
                if (i != j) {
                    j += this.getIncrement().intValue();
                }
            } else {
                j = this.getStartRange();
            }
            sliderValues = i == segmentTotal ? sliderValues + this.getEndRange() : sliderValues + j + ",";
        }
        return sliderValues;
    }

    public abstract void setSliderListener(MethodBinding var1);

    public abstract MethodBinding getSliderListener();

    public abstract String getTrackStyleClass();

    public abstract void setTrackStyleClass(String var1);

    public abstract boolean isOnSlide();

    public abstract void setOnSlide(boolean var1);

    public abstract boolean isOnChange();

    public abstract void setOnChange(boolean var1);

    public abstract boolean isStoreResults();

    public abstract void setStoreResults(boolean var1);

    public abstract String getForValRef();

    public abstract void setForValRef(String var1);

    public abstract String getFilterBy();

    public abstract void setFilterBy(String var1);

    public abstract String getFor();

    public abstract void setFor(String var1);

    public abstract void setStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract void setFieldStyleClass(String var1);

    public abstract String getFieldStyleClass();

    public abstract Integer getStartRange();

    public abstract void setStartRange(Integer var1);

    public abstract Integer getEndRange();

    public abstract void setEndRange(Integer var1);

    public abstract Integer getIncrement();

    public abstract void setIncrement(Integer var1);

    public abstract String getRangeStyleClass();

    public abstract void setRangeStyleClass(String var1);

    public abstract boolean isTrailer();

    public abstract void setTrailer(boolean var1);

    public abstract String getTrailerStyleClass();

    public abstract void setTrailerStyleClass(String var1);

    public abstract String getHandleStyleClass();

    public abstract void setHandleStyleClass(String var1);

    public abstract Integer getHandleValue();

    public abstract void setHandleValue(Integer var1);

    public abstract boolean isManualInput();

    public abstract void setManualInput(boolean var1);

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public void decode(FacesContext context) {
        super.decode(context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

