/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeNodeImpl;
import org.richfaces.model.TreeRowKey;

public class CacheableTreeDataModel
extends TreeDataModel {
    private TreeDataModel treeDataModel;

    public boolean isLeaf() {
        TreeRowKey rowKey = (TreeRowKey)this.getRowKey();
        TreeNode treeNode = this.locateTreeNode(rowKey);
        if (treeNode != null && !treeNode.isLeaf()) {
            return false;
        }
        treeNode = this.treeDataModel.locateTreeNode(rowKey);
        if (treeNode != null) {
            return treeNode.isLeaf();
        }
        return false;
    }

    public CacheableTreeDataModel(TreeDataModel model) {
        this.setWrappedData(new TreeNodeImpl());
        this.setTreeDataModel(model);
    }

    public void walkModel(FacesContext context, DataVisitor visitor, Range range, Object key, Object argument, boolean last) throws IOException {
        this.treeDataModel.walkModel(context, (DataVisitor)new Visitor(visitor), range, key, argument, last);
    }

    public void setTreeDataModel(TreeDataModel treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    public TreeDataModel getTreeDataModel() {
        return this.treeDataModel;
    }

    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        TreeNode cachedTreeNode = this.locateTreeNode((TreeRowKey)rowKey);
        TreeNode treeNode = this.treeDataModel.locateTreeNode((TreeRowKey)rowKey);
        if (treeNode != null) {
            if (cachedTreeNode == null || cachedTreeNode.isLeaf() && !treeNode.isLeaf()) {
                this.treeDataModel.walk(context, (DataVisitor)new Visitor(dataVisitor), range, rowKey, argument, last);
            } else {
                super.walk(context, dataVisitor, range, rowKey, argument, last);
            }
        }
    }

    public void setRowData(Object object) {
        this.locateTreeNode((TreeRowKey)this.getRowKey()).setData(object);
    }

    public boolean isTransient() {
        return true;
    }

    public void setTransient(boolean newTransientValue) {
        if (!newTransientValue) {
            throw new IllegalArgumentException("ReplaceableTreeDataModel shouldn't be transient!");
        }
    }

    private final class Visitor
    implements DataVisitor,
    LastElementAware {
        private final DataVisitor visitor;

        private Visitor(DataVisitor visitor) {
            this.visitor = visitor;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeRowKey treeRowKey = (TreeRowKey)rowKey;
            CacheableTreeDataModel.this.treeDataModel.setRowKey((Object)treeRowKey);
            CacheableTreeDataModel.this.locateTreeNode(treeRowKey, true).setData(CacheableTreeDataModel.this.treeDataModel.getRowData());
            if (this.visitor != null) {
                this.visitor.process(context, rowKey, argument);
            }
        }

        public void resetLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).resetLastElement();
            }
        }

        public void setLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).setLastElement();
            }
        }
    }
}

