/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
//
//
//


import org.richfaces.renderkit.html.PanelMenuGroupRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.HtmlPanelMenuGroupRenderer
 */
public class HtmlPanelMenuGroupRenderer extends PanelMenuGroupRenderer {

	public HtmlPanelMenuGroupRenderer () {
		super();
	}

	// 
	// Declarations
	//
	// 
	// 
	//


	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPanelMenuGroup.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPanelMenuGroup)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelMenuGroup component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", getDivClass(context,component) );
						getUtils().writeAttribute(writer, "id", "tdhide" + convertToString(clientId) );
						getUtils().writeAttribute(writer, "style", getHideStyle(context,component) );
			

		     
		          String isNodeOpened = isOpened(context, component) ? "opened" : "closed";
		      
		
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "border", "0" );
						getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", convertToString(getTableClass(context,component)) + " rich-pmenu-group " + convertToString(getFullStyleClass(context,component)) + " " );
						getUtils().writeAttribute(writer, "id", "tablehide" + convertToString(clientId) );
						getUtils().writeAttribute(writer, "style", getFullStyle(context,component) );
			
getUtils().encodePassThru(context, component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-pmenu-nowrap" );
			
insertSpacerImages(context, component);

insertImage(context, component, "left");

writer.endElement("td");
writer.startElement("td", component);
			getUtils().writeAttribute(writer, "class", "dr-pmenu-group-self-label " + convertToString(getLabelClass(context,component)) );
						getUtils().writeAttribute(writer, "id", "icon" + convertToString(clientId) );
						getUtils().writeAttribute(writer, "style", "width:100%" );
			
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "name", "panelMenuState" + convertToString(clientId) );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", variables.getVariable("isNodeOpened") );
			
writer.endElement("input");
writer.startElement("input", component);
			getUtils().writeAttribute(writer, "name", "panelMenuAction" + convertToString(clientId) );
						getUtils().writeAttribute(writer, "type", "hidden" );
						getUtils().writeAttribute(writer, "value", "" );
			
writer.endElement("input");
insertLabel(context, component);

writer.endElement("td");
writer.startElement("td", component);

insertImage(context, component, "right");

writer.endElement("td");
writer.endElement("tr");
writer.endElement("table");

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPanelMenuGroup)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelMenuGroup component, ComponentVariables variables) throws IOException {
	    
renderChildren(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPanelMenuGroup component, ComponentVariables variables) throws IOException {
	  
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPanelMenuGroup)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
