/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html.images.buttons;

import java.util.Date;

import javax.faces.context.FacesContext;

import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class SpinnerButtonImage extends Java2Dresource {

	public SpinnerButtonImage() {
		setRenderer(new GifRenderer());
		setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
	}
	
	protected Object deserializeData(byte[] objectArray) {
		if (objectArray == null) {
			return null;
		}
		
		return new Integer(new Zipper2(objectArray).nextIntColor());
	}
	
	protected Object getDataToStore(FacesContext context, Object data) {
		Skin skin = SkinFactory.getInstance().getSkin(context);
		
		String skinParameter = "headerTextColor";
		String headerTextColor = (String) skin.getParameter(context, skinParameter);
		if (null == headerTextColor || "".equals(headerTextColor)) {
			Skin defaultSkin = SkinFactory.getInstance().getDefaultSkin(context);
			headerTextColor = (String) defaultSkin.getParameter(context, skinParameter);
		}
		
		int intValue = HtmlColor.decode( headerTextColor == null ? "#000000":headerTextColor ).getRGB();
		byte[] ret = new byte[3];
		new Zipper2(ret).addColor(intValue);
		
		return ret;
	}
	
}
