/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.richfaces.exception.FileUploadException;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.UploadedFile;
import org.richfaces.request.Param;

class FileParam
implements Param,
UploadedFile {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private String name;
    private String contentType;
    private OutputStream outputStream;
    private File file;
    private byte[] data;

    public FileParam(String name, String contentType, boolean createTempFiles, String tempFilesDirectory) {
        if (createTempFiles) {
            try {
                File dir = null;
                if (tempFilesDirectory != null) {
                    dir = new File(tempFilesDirectory);
                }
                this.file = File.createTempFile("richfaces_uploaded_file_", null, dir);
                this.file.deleteOnExit();
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (IOException ex) {
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
                throw new FileUploadException("Could not create temporary file");
            }
        }
        this.outputStream = new ByteArrayOutputStream();
        this.name = name;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        long size = -1L;
        size = this.data != null ? (long)this.data.length : this.file.length();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData() {
        byte[] result = null;
        if (this.data != null) {
            result = this.data;
        } else {
            long fileLength = this.file.length();
            if (fileLength > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("File content is too long to be allocated as byte[]");
            }
            FileInputStream inputStream = null;
            try {
                int read;
                inputStream = new FileInputStream(this.file);
                byte[] fileData = new byte[(int)fileLength];
                int totalRead = 0;
                do {
                    read = inputStream.read(fileData, totalRead, fileData.length - totalRead);
                    totalRead += read;
                } while (read > 0);
                result = fileData;
            }
            catch (IOException ex) {
                LOGGER.error((CharSequence)ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public InputStream getInputStream() {
        InputStream stream = null;
        if (this.data != null) {
            stream = new ByteArrayInputStream(this.data);
        } else {
            try {
                stream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException ex) {
                LOGGER.error((CharSequence)ex.getMessage(), (Throwable)ex);
            }
        }
        return stream;
    }

    public void complete() throws IOException {
        if (this.outputStream instanceof ByteArrayOutputStream) {
            this.data = ((ByteArrayOutputStream)this.outputStream).toByteArray();
        } else {
            try {
                this.outputStream.close();
            }
            catch (IOException ex) {
                LOGGER.error((CharSequence)ex.getMessage(), (Throwable)ex);
            }
        }
        this.outputStream = null;
    }

    public void clear() {
        if (this.data != null) {
            this.data = null;
        } else {
            this.file.delete();
        }
    }

    public void handle(byte[] bytes, int length) throws IOException {
        this.outputStream.write(bytes, 0, length);
        this.outputStream.flush();
    }
}

