/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.component.AbstractPush;
import org.richfaces.resource.PushResource;

public class PushRendererBase
extends Renderer {
    private static final String PUSH_URL_ENCODED_ATTRIBUTE = PushRendererBase.class.getName();

    protected String getPushUrl(FacesContext context) {
        ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
        Resource pushResource = resourceHandler.createResource(PushResource.class.getName());
        return pushResource.getRequestPath();
    }

    protected boolean shouldEncodePushUrl(FacesContext context) {
        Map attributes = context.getAttributes();
        if (attributes.get(PUSH_URL_ENCODED_ATTRIBUTE) == null) {
            attributes.put(PUSH_URL_ENCODED_ATTRIBUTE, Boolean.TRUE);
            return true;
        }
        return false;
    }

    protected String getOptionsString(FacesContext context, UIComponent component) {
        AbstractPush push = (AbstractPush)component;
        HashMap<String, String> options = new HashMap<String, String>(2);
        options.put("address", push.getAddress());
        options.put("dataHandler", push.getOndataavailable());
        options.put("errorHandler", push.getOnerror());
        return ScriptUtils.toScript(options);
    }
}

