/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.util.Iterator;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.event.SwitchablePanelSwitchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UISwitchablePanel
extends UIInput {
    public static final String CLIENT_METHOD = "client";
    public static final String SERVER_METHOD = "server";
    public static final String AJAX_METHOD = "ajax";
    public static final String DEFAULT_METHOD = "server";
    private String switchType;

    public String getSwitchType() {
        if (this.switchType != null) {
            return this.switchType;
        }
        ValueBinding switchTypeBinding = this.getValueBinding("switchType");
        if (switchTypeBinding != null) {
            return (String)switchTypeBinding.getValue(FacesContext.getCurrentInstance());
        }
        return "server";
    }

    public void setSwitchType(String switchType) {
        this.switchType = switchType;
    }

    public Object convertSwitchValue(UIComponent component, Object object) {
        return object;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof SwitchablePanelSwitchEvent && ((Object)((Object)this)).equals(event.getComponent())) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        FacesContext facesContext;
        if (facesEvent instanceof ActionEvent && this.isImmediate()) {
            facesContext = FacesContext.getCurrentInstance();
            facesContext.renderResponse();
        }
        if (facesEvent instanceof SwitchablePanelSwitchEvent) {
            if (this.isRendered()) {
                ValueExpression valueBinding;
                facesContext = FacesContext.getCurrentInstance();
                SwitchablePanelSwitchEvent switchEvent = (SwitchablePanelSwitchEvent)facesEvent;
                Object newValue = this.convertSwitchValue(switchEvent.getEventSource(), switchEvent.getValue());
                Object oldValue = this.getValue();
                if (oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue)) {
                    this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, oldValue, newValue));
                }
                if ((valueBinding = this.getValueExpression("value")) != null) {
                    valueBinding.setValue(facesContext.getELContext(), newValue);
                    this.setValue(null);
                    this.setLocalValueSet(false);
                } else {
                    this.setValue(newValue);
                }
                if (AjaxRendererUtils.isAjaxRequest(facesContext)) {
                    AjaxRendererUtils.addRegionByName(facesContext, (UIComponent)this, this.getId());
                }
            }
        } else {
            super.broadcast(facesEvent);
        }
    }

    public void updateModel(FacesContext context) {
    }

    protected Iterator<UIComponent> getSwitchedFacetsAndChildren() {
        return this.getFacetsAndChildren();
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processDecodes(context);
        }
        try {
            this.decode(context);
            if (this.isImmediate()) {
                this.validate(context);
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processUpdates(context);
        }
        try {
            this.updateModel(context);
            if (!this.isValid()) {
                context.renderResponse();
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("FacesContext is null!");
        }
        if (!this.isRendered()) {
            return;
        }
        Iterator<UIComponent> kids = this.getSwitchedFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processValidators(context);
        }
        try {
            if (!this.isImmediate()) {
                this.validate(context);
                if (!this.isValid()) {
                    context.renderResponse();
                }
            }
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public Object saveState(FacesContext context) {
        Object[] states = new Object[]{super.saveState(context), this.switchType};
        return states;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        super.restoreState(context, states[0]);
        this.switchType = (String)states[1];
    }
}

