/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class BaseSkinImage
extends Java2Dresource {
    public BaseSkinImage() {
        this.setRenderer(new PngRenderer());
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return this.getDimension();
    }

    protected abstract Dimension getDimension();

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimension();
    }

    protected void drawRectangle(Graphics2D g2d, Rectangle2D rect, GradientType.BiColor biColor, boolean useTop) {
        if (biColor != null) {
            Color color = useTop ? biColor.getTopColor() : biColor.getBottomColor();
            g2d.setColor(color);
            g2d.fill(rect);
        }
    }

    protected void drawGradient(Graphics2D g2d, Rectangle2D rectangle, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(rectangle);
        }
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.paintImage(resourceContext, g2d);
    }

    protected abstract void paintImage(ResourceContext var1, Graphics2D var2);

    private Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    private Integer decodeHeight(String value) {
        if (value != null && value.length() != 0) {
            return HtmlDimensions.decode(value).intValue();
        }
        return null;
    }

    protected static String safeTrim(String s) {
        return s != null ? s.trim() : null;
    }

    protected Object getDataToStore(FacesContext context, Object parameterData) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        int hashCode = skin.hashCode(context);
        byte[] data = new byte[4];
        ByteBuffer.wrap(data).asIntBuffer().put(hashCode);
        return data;
    }

    public boolean isCacheable() {
        return true;
    }

    public boolean requireFacesContext() {
        return true;
    }

    protected Integer getSkinColor(String name) {
        return this.decodeColor(this.getSkinParameter(name));
    }

    protected Integer getSkinSize(String name) {
        return this.decodeHeight(this.getSkinParameter(name));
    }

    protected String getSkinParameter(String name) {
        SkinFactory skinFactory;
        Skin skin;
        String value = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (null != context && ((value = (String)(skin = (skinFactory = SkinFactory.getInstance()).getSkin(context)).getParameter(context, name)) == null || value.length() == 0)) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }
}

