/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Date;
import java.util.Map;

import javax.faces.context.FacesContext;

import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.images.GradientAlignment;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.renderkit.html.images.GradientType.BiColor;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/**
 * @author asmirnov
 *
 */
public abstract class BaseSkinImage extends Java2Dresource {


	public BaseSkinImage() {
		super();
		setRenderer(new PngRenderer());
	}

	public Dimension getDimensions(FacesContext facesContext, Object data) {
		return getDimension();
	}

	/**
	 * Hook method to define constant dimension.
	 * 
	 * @return
	 */
	protected abstract Dimension getDimension();

	protected Dimension getDimensions(ResourceContext resourceContext) {
		return getDimension();
	}

	protected void drawRectangle(Graphics2D g2d, Rectangle2D rect,
			BiColor biColor, boolean useTop) {
		if (biColor != null) {
			Color color = useTop ? biColor.getTopColor() : biColor
					.getBottomColor();
			g2d.setColor(color);
			g2d.fill(rect);
		}
	}

	protected void drawGradient(Graphics2D g2d, Rectangle2D rectangle,
			BiColor colors, int height) {
		if (colors != null) {
			GradientPaint gragient = new GradientPaint(0, 0, colors
					.getTopColor(), 0, height, colors.getBottomColor());
			g2d.setPaint(gragient);
			g2d.fill(rectangle);
		}
	}

	protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
		g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g2d.setRenderingHint(RenderingHints.KEY_DITHERING,
				RenderingHints.VALUE_DITHER_ENABLE);

		g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION,
				RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
		g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING,
				RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		g2d.setRenderingHint(RenderingHints.KEY_RENDERING,
				RenderingHints.VALUE_RENDER_QUALITY);
		paintImage(resourceContext,g2d);
	}

	/**
	 * @param resourceContext
	 * @param g2d
	 */
	protected abstract void paintImage(ResourceContext resourceContext, Graphics2D g2d);

	private Integer decodeColor(String value) {
		if (value != null && value.length() != 0) {
			return Integer.valueOf(HtmlColor.decode(value).getRGB());
		} else {
			return null;
		}
	}

	private Integer decodeHeight(String value) {
		if (value != null && value.length() != 0) {
			return HtmlDimensions.decode(value).intValue();
		} else {
			return null;
		}
	}

	protected static String safeTrim(String s) {
		return s != null ? s.trim() : null;
	}

	protected Object getDataToStore(FacesContext context, Object parameterData) {
		SkinFactory skinFactory = SkinFactory.getInstance();

		Skin skin = skinFactory.getSkin(context);

		int hashCode = skin.hashCode(context);
		byte[] data = new byte[4];
		ByteBuffer.wrap(data).asIntBuffer().put(hashCode);
		return data;
	}

	public boolean isCacheable() {
		return true;
	}

	@Override
	public boolean requireFacesContext() {
		return true;
	}

	protected Integer getSkinColor(String name) {
		return decodeColor(getSkinParameter(name));
	}
	
	protected Integer getSkinSize(String name) {
		return decodeHeight(getSkinParameter(name));
	}
	protected String getSkinParameter(String name) {
		String value = null;
		FacesContext context = FacesContext.getCurrentInstance();
		if (null != context) {
			SkinFactory skinFactory = SkinFactory.getInstance();
			Skin skin = skinFactory.getSkin(context);
			value = (String) skin.getParameter(context, name);

			if (value == null || value.length() == 0) {
				skin = skinFactory.getDefaultSkin(context);
				value = (String) skin.getParameter(context, name);
			}

		}
		return value;
	}

}
