/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.AbstractChainableSkinImpl;
import org.richfaces.skin.BaseSkinImpl;
import org.richfaces.skin.DefaultSkinImpl;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinImpl;
import org.richfaces.skin.SkinNotFoundException;
import org.richfaces.skin.Theme;
import org.richfaces.skin.ThemeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinFactoryImpl
extends SkinFactory {
    public static final String RENDER_KIT_PARAMETER = "org.ajax4jsf.RENDERKIT_DEFINITION";
    private static final String DEFAULT_SKIN_PATH = "META-INF/skins/%s.skin.properties";
    private static final String USER_SKIN_PATH = "%s.skin.properties";
    private static final String DEFAULT_SKIN_NAME = "DEFAULT";
    private static final String[] SKINS_PATHS = new String[]{"META-INF/skins/%s.skin.properties", "%s.skin.properties"};
    private static final String[] THEME_PATHS = new String[]{"META-INF/themes/%s.theme.properties", "%s.theme.properties"};
    private Map<String, Skin> skins = new HashMap<String, Skin>();
    private Map<String, Skin> baseSkins = new HashMap<String, Skin>();
    private Map<String, Properties> sourceProperties = new HashMap<String, Properties>();
    private Map<String, Theme> themes = new HashMap<String, Theme>();
    private String skinName = null;
    private ValueExpression skinBinding = null;
    private String baseSkinName = null;
    private ValueExpression baseSkinBinding = null;
    private static final Log log = LogFactory.getLog(SkinFactoryImpl.class);
    private static final String A4J_BASE_SKIN_PARAMETER = "org.ajax4jsf.BASE_SKIN";
    private static final String A4J_SKIN_PARAMETER = "org.ajax4jsf.SKIN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Skin getSkinByName(FacesContext facesContext, Object currentSkinOrName, boolean isBase) {
        if (null == currentSkinOrName) {
            throw new SkinNotFoundException(Messages.getMessage((String)"NULL_SKIN_NAME_ERROR"));
        }
        Skin currentSkin = null;
        if (currentSkinOrName instanceof Skin) {
            currentSkin = (Skin)currentSkinOrName;
        } else {
            Map<String, Skin> skinsMap;
            String currentSkinName = currentSkinOrName.toString();
            Map<String, Skin> map = skinsMap = isBase ? this.baseSkins : this.skins;
            synchronized (map) {
                currentSkin = skinsMap.get(currentSkinName);
                if (currentSkin == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage((String)"CREATE_SKIN_INFO", (Object)currentSkinName));
                    }
                    currentSkin = this.buildSkin(facesContext, currentSkinName, isBase);
                    skinsMap.put(currentSkinName, currentSkin);
                }
            }
        }
        return currentSkin;
    }

    public Skin getDefaultSkin(FacesContext context) {
        return this.getSkinByName(context, DEFAULT_SKIN_NAME, false);
    }

    public Skin getSkin(FacesContext context) {
        Object currentSkinOrName = this.getSkinOrName(context, false);
        return this.getSkinByName(context, currentSkinOrName, false);
    }

    public Skin getBaseSkin(FacesContext context) {
        Object currentSkinOrName = this.getSkinOrName(context, true);
        return this.getSkinByName(context, currentSkinOrName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSkinOrName(FacesContext context, boolean useBase) {
        String skin;
        ValueExpression binding;
        SkinFactoryImpl skinFactoryImpl = this;
        synchronized (skinFactoryImpl) {
            if (useBase) {
                binding = this.baseSkinBinding;
                skin = this.baseSkinName;
            } else {
                binding = this.skinBinding;
                skin = this.skinName;
            }
            if (binding == null && skin == null) {
                String currentSkinName = context.getExternalContext().getInitParameter(useBase ? "org.richfaces.BASE_SKIN" : "org.richfaces.SKIN");
                if (null == currentSkinName && null != (currentSkinName = context.getExternalContext().getInitParameter(useBase ? A4J_BASE_SKIN_PARAMETER : A4J_SKIN_PARAMETER))) {
                    log.warn((Object)("Init parameter for a skin name changed to " + (useBase ? "org.richfaces.BASE_SKIN" : "org.richfaces.SKIN")));
                }
                if (currentSkinName == null) {
                    return DEFAULT_SKIN_NAME;
                }
                if (ELUtils.isValueReference(currentSkinName)) {
                    binding = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), currentSkinName, Object.class);
                } else {
                    skin = currentSkinName;
                }
                if (useBase) {
                    this.baseSkinBinding = binding;
                    this.baseSkinName = skin;
                } else {
                    this.skinBinding = binding;
                    this.skinName = skin;
                }
            }
        }
        if (binding != null) {
            return binding.getValue(context.getELContext());
        }
        return skin;
    }

    private void processProperties(FacesContext context, Map<Object, Object> properties) {
        ELContext elContext = context.getELContext();
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = factory.getApplication();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object propertyObject = entry.getValue();
            if (!(propertyObject instanceof String)) continue;
            String property = (String)propertyObject;
            if (ELUtils.isValueReference(property)) {
                ExpressionFactory expressionFactory = app.getExpressionFactory();
                entry.setValue(expressionFactory.createValueExpression(elContext, property, Object.class));
                continue;
            }
            entry.setValue(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Skin buildSkin(FacesContext context, String name, boolean isBase) throws SkinNotFoundException {
        Properties skinParams;
        Map<String, Properties> map = this.sourceProperties;
        synchronized (map) {
            skinParams = this.sourceProperties.get(name);
            if (skinParams == null) {
                skinParams = this.loadProperties(name, SKINS_PATHS);
                this.processProperties(context, skinParams);
                this.sourceProperties.put(name, skinParams);
            }
        }
        AbstractChainableSkinImpl skinImpl = DEFAULT_SKIN_NAME.equals(name) ? new DefaultSkinImpl(skinParams) : (isBase ? new BaseSkinImpl(skinParams, this) : new SkinImpl(skinParams, this));
        return skinImpl;
    }

    protected Properties loadProperties(String name, String[] paths) throws SkinNotFoundException, FacesException {
        ClassLoader loader = this.getClassLoader();
        Properties skinProperties = new Properties();
        int loadedPropertiesCount = 0;
        for (int i = 0; i < paths.length; ++i) {
            String skinPropertiesLocation = paths[i].replaceAll("%s", name);
            if (!this.loadProperties(loader, skinProperties, skinPropertiesLocation)) continue;
            ++loadedPropertiesCount;
        }
        if (loadedPropertiesCount == 0) {
            throw new SkinNotFoundException(Messages.getMessage((String)"SKIN_NOT_FOUND_ERROR", (Object)name));
        }
        return skinProperties;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadProperties(ClassLoader loader, Properties properties, String location) {
        boolean loaded;
        block8: {
            loaded = false;
            try {
                Enumeration<URL> resources = loader.getResources(location);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream propertyStream = null;
                    try {
                        propertyStream = URLToStreamHelper.urlToStream((URL)url);
                        properties.load(propertyStream);
                        loaded = true;
                    }
                    catch (IOException e) {
                        log.warn((Object)Messages.getMessage((String)"SKIN_PROPERTIES_IO_ERROR"), (Throwable)e);
                    }
                    finally {
                        if (null == propertyStream) continue;
                        propertyStream.close();
                    }
                }
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) break block8;
                log.info((Object)Messages.getMessage((String)"SKIN_PROPERTIES_IO_ERROR"), (Throwable)e);
            }
        }
        return loaded;
    }

    public Theme getTheme(FacesContext facesContext, String name) {
        Theme theme = this.themes.get(name);
        if (null == theme) {
            Properties properties = this.loadProperties(name, THEME_PATHS);
            this.processProperties(facesContext, properties);
            theme = new ThemeImpl(properties);
            this.themes.put(name, theme);
        }
        return theme;
    }
}

