/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.request;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.ajax4jsf.exception.FileUploadException;
import org.ajax4jsf.request.MultipartRequestRegistry;
import org.richfaces.model.UploadItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final String PARAM_NAME = "name";
    private static final String PARAM_FILENAME = "filename";
    private static final String PARAM_CONTENT_TYPE = "Content-Type";
    private static final int BUFFER_SIZE = 2048;
    private static final int CHUNK_SIZE = 512;
    private boolean createTempFiles;
    private String uid;
    private String encoding = null;
    private Integer contentLength = 0;
    private int bytesRead = 0;
    private int read = 0;
    private Map<String, Param> parameters = null;
    private Map<String, Object> percentMap = null;
    private Map<String, Integer> requestSizeMap = null;
    private Map<String, String> requestKeysMap = null;
    private String requestKey = null;
    private MultipartRequestRegistry requestRegistry;
    private List<String> keys = new ArrayList<String>();
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CR_LF = new byte[]{13, 10};
    private boolean shouldStop = false;
    private byte[] boundaryMarker;
    private byte[] buffer;
    private ReadState readState;
    private InputStream input;
    private int pos = 0;
    private int zeroReadAttempts = 20;
    boolean initialized = false;
    private static final Pattern PARAM_VALUE_PATTERN = Pattern.compile("^\\s*([^\\s=]+)\\s*[=:]\\s*(.+)\\s*$");
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile(".*filename=\"(.*)\"");

    public MultipartRequest(HttpServletRequest request, boolean createTempFiles, int maxRequestSize, String uid) {
        super(request);
        this.createTempFiles = createTempFiles;
        this.uid = uid;
        String contentLength = request.getHeader("Content-Length");
        this.contentLength = Integer.parseInt(contentLength);
        if (contentLength == null || maxRequestSize <= 0 || this.contentLength > maxRequestSize) {
            // empty if block
        }
    }

    private String decodeFileName(String name) {
        String fileName = null;
        try {
            if (this.getRequest().getParameter("_richfaces_send_http_error") != null) {
                fileName = new String(name.getBytes(this.encoding), "UTF-8");
            } else {
                StringBuffer buffer = new StringBuffer();
                String[] codes = name.split(";");
                if (codes != null) {
                    for (String code : codes) {
                        if (code.startsWith("&")) {
                            String sCode = code.replaceAll("[&#]*", "");
                            Integer iCode = Integer.parseInt(sCode);
                            buffer.append(Character.toChars(iCode));
                            continue;
                        }
                        buffer.append(code);
                    }
                    fileName = buffer.toString();
                }
            }
        }
        catch (Exception e) {
            fileName = name;
        }
        return fileName;
    }

    public void cancel() {
        if (this.parameters != null) {
            for (Param p : this.parameters.values()) {
                if (!(p instanceof FileParam)) continue;
                ((FileParam)p).deleteFile();
            }
        }
    }

    private void fillBuffer() throws IOException {
        if (!this.shouldStop) {
            if (this.pos < this.read) {
                int bytesNotRead = this.read - this.pos;
                if (bytesNotRead != this.buffer.length) {
                    System.arraycopy(this.buffer, this.pos, this.buffer, 0, bytesNotRead);
                    this.read = this.input.read(this.buffer, bytesNotRead, this.buffer.length - bytesNotRead);
                    if (this.read != 0 || --this.zeroReadAttempts != 0) {
                        if (this.read > 0) {
                            this.bytesRead += this.read;
                        }
                        this.read += bytesNotRead;
                    }
                } else {
                    this.read = bytesNotRead;
                }
            } else {
                this.read = this.input.read(this.buffer);
                if (this.read > 0) {
                    this.bytesRead += this.read;
                }
            }
            this.fillProgressInfo();
            this.pos = 0;
        } else {
            this.cancel();
            this.read = -1;
        }
    }

    private void readNext() throws IOException {
        Param p = this.readHeader();
        this.readData(p);
    }

    private void readData(Param p) throws IOException {
        int localRead = this.read;
        while (localRead > 0) {
            for (int i = this.pos; i < localRead; ++i) {
                if (this.checkSequence(this.buffer, i - this.boundaryMarker.length - CR_LF.length, CR_LF) && this.checkSequence(this.buffer, i, this.boundaryMarker)) {
                    if (this.pos < i - this.boundaryMarker.length - CR_LF.length - 1) {
                        p.appendData(this.buffer, this.pos, i - this.pos - this.boundaryMarker.length - CR_LF.length - 1);
                    }
                    if (p instanceof ValueParam) {
                        ((ValueParam)p).complete();
                    }
                    this.pos = this.checkSequence(this.buffer, i + CR_LF.length, CR_LF) ? (i += CR_LF.length) + 1 : i;
                    this.readState = ReadState.HEADERS;
                    break;
                }
                if (i <= this.pos + this.boundaryMarker.length + 512 + CR_LF.length) continue;
                p.appendData(this.buffer, this.pos, 512);
                this.pos += 512;
            }
            if (!ReadState.DATA.equals((Object)this.readState)) break;
            this.fillBuffer();
            localRead = this.read;
        }
    }

    private Param readHeader() throws IOException {
        Param p = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        int localRead = this.read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        while (localRead > 0) {
            for (int i = this.pos; i < localRead; ++i) {
                if (!this.checkSequence(this.buffer, i, CR_LF)) continue;
                baos.write(this.buffer, this.pos, i - this.pos - 1);
                String param = this.encoding == null ? new String(baos.toByteArray()) : new String(baos.toByteArray(), this.encoding);
                this.parseParams(param, "; ", headers);
                if (this.checkSequence(this.buffer, i + CR_LF.length, CR_LF)) {
                    this.readState = ReadState.DATA;
                    this.pos = (i += CR_LF.length) + 1;
                    String paramName = (String)headers.get(PARAM_NAME);
                    if (paramName != null) {
                        if (headers.containsKey(PARAM_FILENAME)) {
                            FileParam fp = new FileParam(paramName);
                            if (this.createTempFiles) {
                                fp.createTempFile();
                            }
                            fp.setContentType((String)headers.get(PARAM_CONTENT_TYPE));
                            fp.setFilename(this.decodeFileName((String)headers.get(PARAM_FILENAME)));
                            p = fp;
                        } else {
                            p = this.parameters.containsKey(paramName) ? this.parameters.get(paramName) : new ValueParam(paramName);
                        }
                        if (!this.parameters.containsKey(paramName)) {
                            this.parameters.put(paramName, p);
                        }
                    }
                    headers.clear();
                    baos.reset();
                    break;
                }
                this.pos = i + 1;
                baos.reset();
            }
            if (!ReadState.HEADERS.equals((Object)this.readState)) break;
            baos.write(this.buffer, this.pos, this.read - this.pos);
            this.pos = this.read;
            this.fillBuffer();
            localRead = this.read;
        }
        return p;
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            this.initialized = true;
            this.boundaryMarker = this.getBoundaryMarker(super.getContentType());
            if (this.boundaryMarker == null) {
                throw new FileUploadException("The request was rejected because no multipart boundary was found");
            }
            this.encoding = this.getCharacterEncoding();
            this.parameters = new HashMap<String, Param>();
            this.buffer = new byte[2048];
            this.readState = ReadState.BOUNDARY;
            this.input = this.getInputStream();
            this.setupProgressData();
            this.fillBuffer();
            int localRead = this.read;
            while (localRead > 0) {
                for (int i = 0; i < localRead; ++i) {
                    if (!this.checkSequence(this.buffer, i, this.boundaryMarker) || !this.checkSequence(this.buffer, i + 2, CR_LF)) continue;
                    this.readState = ReadState.HEADERS;
                    this.pos = (i += 2) + 1;
                    break;
                }
                if (!ReadState.BOUNDARY.equals((Object)this.readState)) break;
                this.pos = this.read - (this.boundaryMarker.length + CR_LF.length) + 1;
                this.fillBuffer();
                localRead = this.read;
            }
        }
    }

    public void parseRequest() {
        try {
            this.initialize();
            while (this.read >= 0) {
                this.readNext();
            }
        }
        catch (IOException e) {
            throw new FileUploadException("IO Error parsing multipart request", e);
        }
    }

    public static MultipartRequest lookupRequest(FacesContext context, String uploadId) {
        MultipartRequest request;
        MultipartRequestRegistry requestRegistry;
        String requestKey;
        Map sessionMap = context.getExternalContext().getSessionMap();
        Map requestKeys = (Map)sessionMap.get("_richfaces_request_keys");
        if (requestKeys != null && (requestKey = (String)requestKeys.get(uploadId)) != null && (requestRegistry = MultipartRequestRegistry.getInstance(context)) != null && (request = requestRegistry.getRequest(requestKey)) != null) {
            return request;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupProgressData() {
        Map sessionMap;
        ExternalContext externalContext;
        FacesContext facesContext;
        if ((this.percentMap == null || this.requestSizeMap == null || this.requestKeysMap == null) && (facesContext = FacesContext.getCurrentInstance()) != null && (externalContext = facesContext.getExternalContext()) != null && (sessionMap = externalContext.getSessionMap()) != null) {
            String uploadId = this.getUploadId();
            Map map = sessionMap;
            synchronized (map) {
                if (this.percentMap == null) {
                    this.percentMap = (Map)sessionMap.get("_richfaces_upload_percents");
                    if (this.percentMap == null) {
                        this.percentMap = new ConcurrentHashMap<String, Object>();
                        sessionMap.put("_richfaces_upload_percents", this.percentMap);
                    }
                }
                if (this.requestSizeMap == null) {
                    this.requestSizeMap = (Map)sessionMap.get("_richfaces_request_size");
                    if (this.requestSizeMap == null) {
                        this.requestSizeMap = new ConcurrentHashMap<String, Integer>();
                        sessionMap.put("_richfaces_request_size", this.requestSizeMap);
                    }
                }
                if (this.requestKeysMap == null) {
                    this.requestKeysMap = (Map)sessionMap.get("_richfaces_request_keys");
                    if (this.requestKeysMap == null) {
                        this.requestKeysMap = new ConcurrentHashMap<String, String>();
                        sessionMap.put("_richfaces_request_keys", this.requestKeysMap);
                    }
                }
            }
            this.percentMap.put(uploadId, 0.0);
            this.requestSizeMap.put(uploadId, this.getSize());
            this.requestRegistry = MultipartRequestRegistry.getInstance(facesContext);
            this.requestKey = this.requestRegistry.registerRequest(this);
            this.requestKeysMap.put(uploadId, this.requestKey);
        }
    }

    private void fillProgressInfo() {
        this.setupProgressData();
        if (this.percentMap != null) {
            Double percent = 100.0 * (double)this.bytesRead / (double)this.contentLength.intValue();
            this.percentMap.put(this.uid, percent);
        }
    }

    private byte[] getBoundaryMarker(String contentType) {
        Map<String, String> params = this.parseParams(contentType, ";");
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            return boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return boundaryStr.getBytes();
        }
    }

    private boolean checkSequence(byte[] data, int pos, byte[] seq) {
        if (pos - seq.length < -1 || pos >= data.length) {
            return false;
        }
        for (int i = 0; i < seq.length; ++i) {
            if (data[pos - seq.length + i + 1] == seq[i]) continue;
            return false;
        }
        return true;
    }

    private Map<String, String> parseParams(String paramStr, String separator) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.parseParams(paramStr, separator, paramMap);
        return paramMap;
    }

    private void parseParams(String paramStr, String separator, Map<String, String> paramMap) {
        String[] parts;
        for (String part : parts = paramStr.split(separator)) {
            Matcher m = PARAM_VALUE_PATTERN.matcher(part);
            if (!m.matches()) continue;
            String key = m.group(1);
            String value = m.group(2);
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (!PARAM_FILENAME.equals(key)) {
                paramMap.put(key, value);
                continue;
            }
            paramMap.put(key, this.parseFileName(paramStr));
        }
    }

    private String parseFileName(String parseStr) {
        Matcher m = FILE_NAME_PATTERN.matcher(parseStr);
        if (m.matches()) {
            String name = m.group(1);
            if (name.startsWith("&")) {
                return this.decodeFileName(name);
            }
            return name;
        }
        return null;
    }

    private Param getParam(String name) {
        Param param = null;
        if (this.parameters != null) {
            param = this.parameters.get(name);
        }
        if (param == null) {
            try {
                this.initialize();
                while (param == null && this.read > 0) {
                    this.readNext();
                    param = this.parameters.get(name);
                }
            }
            catch (IOException e) {
                throw new FileUploadException("IO Error parsing multipart request", e);
            }
        }
        return param;
    }

    public Integer getSize() {
        return this.contentLength;
    }

    public Enumeration getParameterNames() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        return Collections.enumeration(this.parameters.keySet());
    }

    public byte[] getFileBytes(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getData() : null;
    }

    public InputStream getFileInputStream(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getInputStream() : null;
    }

    public String getFileContentType(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getContentType() : null;
    }

    public Object getFile(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFile() : null;
    }

    public String getFileName(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFilename() : null;
    }

    public int getFileSize(String name) {
        Param p = this.getParam(name);
        return p != null && p instanceof FileParam ? ((FileParam)p).getFileSize() : -1;
    }

    public String getParameter(String name) {
        Param p = this.getParam(name);
        if (p != null && p instanceof ValueParam) {
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof String) {
                return (String)vp.getValue();
            }
        } else {
            if (p != null && p instanceof FileParam) {
                return "---BINARY DATA---";
            }
            return super.getParameter(name);
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        this.parseRequest();
        Param p = this.getParam(name);
        if (p != null && p instanceof ValueParam) {
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof List) {
                List vals = (List)vp.getValue();
                String[] values = new String[vals.size()];
                vals.toArray(values);
                return values;
            }
            return new String[]{(String)vp.getValue()};
        }
        return super.getParameterValues(name);
    }

    public Map getParameterMap() {
        if (this.parameters == null) {
            this.parseRequest();
        }
        HashMap<String, Object> params = new HashMap<String, Object>(super.getParameterMap());
        for (String name : this.parameters.keySet()) {
            Param p = this.parameters.get(name);
            if (!(p instanceof ValueParam)) continue;
            ValueParam vp = (ValueParam)p;
            if (vp.getValue() instanceof String) {
                params.put(name, vp.getValue());
                continue;
            }
            if (!(vp.getValue() instanceof List)) continue;
            params.put(name, this.getParameterValues(name));
        }
        return params;
    }

    public List<UploadItem> getUploadItems() {
        ArrayList<UploadItem> uploadItems = new ArrayList<UploadItem>();
        for (String k : this.keys) {
            uploadItems.add(new UploadItem(this.getFileName(k), this.getFileSize(k), this.getFileContentType(k), this.getFile(k)));
        }
        return uploadItems;
    }

    public boolean isFormUpload() {
        return "_richfaces_form_upload".equals(this.uid);
    }

    public String getHeader(String name) {
        if (!"Accept".equals(name)) {
            return super.getHeader(name);
        }
        return "text/html";
    }

    public void stop() {
        this.shouldStop = true;
    }

    public boolean isStopped() {
        return this.shouldStop;
    }

    public String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    protected String getUploadId() {
        return this.uid;
    }

    public void clearRequestData() {
        String uploadId = this.getUploadId();
        if (this.percentMap != null) {
            this.percentMap.remove(uploadId);
        }
        if (this.requestSizeMap != null) {
            this.requestSizeMap.remove(uploadId);
        }
        if (this.requestKeysMap != null) {
            this.requestKeysMap.remove(uploadId);
        }
        if (this.requestRegistry != null) {
            this.requestRegistry.removeRequest(this.requestKey);
        }
    }

    private class FileParam
    extends Param {
        private String filename;
        private String contentType;
        private int fileSize;
        private ByteArrayOutputStream bOut;
        private FileOutputStream fOut;
        private File tempFile;

        public FileParam(String name) {
            super(name);
            this.bOut = null;
            this.fOut = null;
            this.tempFile = null;
            MultipartRequest.this.keys.add(name);
        }

        public Object getFile() {
            if (null != this.tempFile) {
                if (this.fOut != null) {
                    try {
                        this.fOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fOut = null;
                }
                return this.tempFile;
            }
            if (null != this.bOut) {
                return this.bOut.toByteArray();
            }
            return null;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public File createTempFile() {
            try {
                this.tempFile = File.createTempFile(new UID().toString().replace(":", "-"), ".upload");
                this.fOut = new FileOutputStream(this.tempFile);
            }
            catch (IOException ex) {
                throw new FileUploadException("Could not create temporary file");
            }
            return this.tempFile;
        }

        public void deleteFile() {
            try {
                if (this.fOut != null) {
                    this.fOut.close();
                    if (this.tempFile != null) {
                        this.tempFile.delete();
                    }
                }
            }
            catch (Exception e) {
                throw new FileUploadException("Could not delete temporary file");
            }
        }

        public void appendData(byte[] data, int start, int length) throws IOException {
            if (this.fOut != null) {
                this.fOut.write(data, start, length);
                this.fOut.flush();
            } else {
                if (this.bOut == null) {
                    this.bOut = new ByteArrayOutputStream();
                }
                this.bOut.write(data, start, length);
            }
            this.fileSize += length;
        }

        public byte[] getData() {
            if (this.fOut != null) {
                try {
                    this.fOut.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.fOut = null;
            }
            if (this.bOut != null) {
                return this.bOut.toByteArray();
            }
            if (this.tempFile != null && this.tempFile.exists()) {
                try {
                    FileInputStream fIn = new FileInputStream(this.tempFile);
                    ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                    byte[] buf = new byte[512];
                    int read = fIn.read(buf);
                    while (read != -1) {
                        bOut.write(buf, 0, read);
                        read = fIn.read(buf);
                    }
                    bOut.flush();
                    fIn.close();
                    this.tempFile.delete();
                    return bOut.toByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public InputStream getInputStream() {
            if (this.fOut != null) {
                try {
                    this.fOut.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.fOut = null;
            }
            if (this.bOut != null) {
                return new ByteArrayInputStream(this.bOut.toByteArray());
            }
            if (this.tempFile != null) {
                try {
                    return new FileInputStream(this.tempFile){

                        public void close() throws IOException {
                            super.close();
                            FileParam.this.tempFile.delete();
                        }
                    };
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private class ValueParam
    extends Param {
        private Object value;
        private ByteArrayOutputStream buf;

        public ValueParam(String name) {
            super(name);
            this.value = null;
            this.buf = new ByteArrayOutputStream();
        }

        public void appendData(byte[] data, int start, int length) throws IOException {
            this.buf.write(data, start, length);
        }

        public void complete() throws UnsupportedEncodingException {
            String val;
            String string = val = MultipartRequest.this.encoding == null ? new String(this.buf.toByteArray()) : new String(this.buf.toByteArray(), MultipartRequest.this.encoding);
            if (this.value == null) {
                this.value = val;
            } else {
                if (!(this.value instanceof List)) {
                    ArrayList<String> v = new ArrayList<String>();
                    v.add((String)this.value);
                    this.value = v;
                }
                ((List)this.value).add(val);
            }
            this.buf.reset();
        }

        public Object getValue() {
            return this.value;
        }
    }

    private abstract class Param {
        private String name;

        public Param(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract void appendData(byte[] var1, int var2, int var3) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadState {
        BOUNDARY,
        HEADERS,
        DATA;

    }
}

