/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModelListener;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.ajax4jsf.model.SerializableDataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.Field;
import org.richfaces.model.FilterField;
import org.richfaces.model.Modifiable;
import org.richfaces.model.SortField2;
import org.richfaces.model.impl.expressive.JavaBeanWrapper;
import org.richfaces.model.impl.expressive.ObjectWrapperFactory;
import org.richfaces.model.impl.expressive.WrappedBeanComparator2;
import org.richfaces.model.impl.expressive.WrappedBeanFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiableModel
extends ExtendedDataModel
implements Modifiable {
    private static final Log log = LogFactory.getLog(ModifiableModel.class);
    protected List<Object> rowKeys;
    protected ExtendedDataModel originalModel;
    protected String var;

    public ModifiableModel(ExtendedDataModel originalModel, String var) {
        this.originalModel = originalModel;
        this.var = var;
    }

    public void addDataModelListener(DataModelListener listener) {
        this.originalModel.addDataModelListener(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        return this.originalModel.getDataModelListeners();
    }

    public Object getRowKey() {
        return this.rowKeys.indexOf(this.originalModel.getRowKey());
    }

    public void setRowKey(Object key) {
        int i;
        Object originalKey = null;
        if (key != null && (i = ((Integer)key).intValue()) >= 0 && i < this.rowKeys.size()) {
            originalKey = this.rowKeys.get(i);
        }
        this.originalModel.setRowKey(originalKey);
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        SequenceRange seqRange = (SequenceRange)range;
        int rows = seqRange.getRows();
        int rowCount = this.getRowCount();
        int currentRow = seqRange.getFirstRow();
        if (rows > 0) {
            rows += currentRow;
            rows = Math.min(rows, rowCount);
        } else {
            rows = rowCount;
        }
        while (currentRow < rows) {
            visitor.process(context, (Object)currentRow, argument);
            ++currentRow;
        }
    }

    public int getRowCount() {
        if (this.rowKeys == null) {
            return -1;
        }
        return this.rowKeys.size();
    }

    public Object getRowData() {
        return this.originalModel.getRowData();
    }

    public int getRowIndex() {
        return this.rowKeys.indexOf(this.originalModel.getRowKey());
    }

    public Object getWrappedData() {
        return this.originalModel.getWrappedData();
    }

    public boolean isRowAvailable() {
        return this.originalModel.isRowAvailable();
    }

    public void setRowIndex(int rowIndex) {
        Object originalKey = null;
        if (rowIndex >= 0 && rowIndex < this.rowKeys.size()) {
            originalKey = this.rowKeys.get(rowIndex);
        }
        this.originalModel.setRowKey(originalKey);
    }

    public void setWrappedData(Object data) {
        this.originalModel.setWrappedData(data);
    }

    public SerializableDataModel getSerializableModel(Range range) {
        return this.originalModel.getSerializableModel(range);
    }

    public void removeDataModelListener(DataModelListener listener) {
        this.originalModel.removeDataModelListener(listener);
    }

    public void modify(List<FilterField> filterFields, List<SortField2> sortFields) {
        int rowCount = this.originalModel.getRowCount();
        this.rowKeys = rowCount > 0 ? new ArrayList<Object>(rowCount) : new ArrayList<Object>();
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            this.originalModel.walk(context, new DataVisitor(){

                public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                    ModifiableModel.this.originalModel.setRowKey(rowKey);
                    if (ModifiableModel.this.originalModel.isRowAvailable()) {
                        ModifiableModel.this.rowKeys.add(rowKey);
                    }
                }
            }, (Range)new SequenceRange(0, -1), null);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.filter(filterFields);
        this.sort(sortFields);
    }

    protected List<Object> filter(List<FilterField> filterFields) {
        if (filterFields != null && !filterFields.isEmpty()) {
            FacesContext context = FacesContext.getCurrentInstance();
            ArrayList<Object> filteredCollection = new ArrayList<Object>();
            RowKeyWrapperFactory wrapperFactory = new RowKeyWrapperFactory(context, this.var, filterFields);
            WrappedBeanFilter wrappedBeanFilter = new WrappedBeanFilter(filterFields);
            wrapperFactory.wrapList(this.rowKeys);
            for (Object object : this.rowKeys) {
                if (!wrappedBeanFilter.accept((JavaBeanWrapper)object)) continue;
                filteredCollection.add(object);
            }
            this.rowKeys = filteredCollection;
            wrapperFactory.unwrapList(this.rowKeys);
        }
        return this.rowKeys;
    }

    protected void sort(List<SortField2> sortFields) {
        if (sortFields != null && !sortFields.isEmpty()) {
            FacesContext context = FacesContext.getCurrentInstance();
            RowKeyWrapperFactory wrapperFactory = new RowKeyWrapperFactory(context, this.var, sortFields);
            WrappedBeanComparator2 wrappedBeanComparator = new WrappedBeanComparator2(sortFields);
            wrapperFactory.wrapList(this.rowKeys);
            Collections.sort(this.rowKeys, wrappedBeanComparator);
            wrapperFactory.unwrapList(this.rowKeys);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RowKeyWrapperFactory
    extends ObjectWrapperFactory {
        public RowKeyWrapperFactory(FacesContext context, String var, List<? extends Field> sortOrder) {
            super(context, var, sortOrder);
        }

        @Override
        public JavaBeanWrapper wrapObject(Object key) {
            ModifiableModel.this.originalModel.setRowKey(key);
            JavaBeanWrapper wrapObject = super.wrapObject(ModifiableModel.this.originalModel.getRowData());
            return new ExtendedJavaBeanWrapper(key, wrapObject.getWrappedObject(), wrapObject.getProperties());
        }

        @Override
        public Object unwrapObject(Object wrapper) {
            return ((ExtendedJavaBeanWrapper)wrapper).getKey();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ExtendedJavaBeanWrapper
        extends JavaBeanWrapper {
            private Object key;

            public ExtendedJavaBeanWrapper(Object key, Object o, Map<String, Object> props) {
                super(o, props);
                this.key = key;
            }

            public Object getKey() {
                return this.key;
            }
        }
    }
}

