/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueRegistry {
    public static final String GLOBAL_QUEUE_NAME = "org.richfaces.queue.global";
    private static final String REGISTRY_ATTRIBUTE_NAME = QueueRegistry.class.getName();
    private Map<String, Object> queuesData = new LinkedHashMap<String, Object>();

    private QueueRegistry() {
    }

    public static QueueRegistry getInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        QueueRegistry registry = (QueueRegistry)requestMap.get(REGISTRY_ATTRIBUTE_NAME);
        if (registry == null) {
            registry = new QueueRegistry();
            requestMap.put(REGISTRY_ATTRIBUTE_NAME, registry);
        }
        return registry;
    }

    public void registerQueue(FacesContext context, String clientName, Object data) {
        if (!this.queuesData.containsKey(clientName)) {
            this.queuesData.put(clientName, data);
        } else {
            context.getExternalContext().log("Queue with name '" + clientName + "' has already been registered");
        }
    }

    public Map<String, Object> getRegisteredQueues(FacesContext context) {
        return this.queuesData;
    }

    public void createGlobalDefaultQueue(FacesContext context) {
        String encodedGlobalQueueName = context.getExternalContext().encodeNamespace(GLOBAL_QUEUE_NAME);
        if (!this.queuesData.containsKey(encodedGlobalQueueName)) {
            this.queuesData.put(encodedGlobalQueueName, null);
        }
    }

    public boolean hasRegisteredQueues() {
        return !this.queuesData.isEmpty();
    }
}

