/**
 * 
 */
package org.ajax4jsf.config;

/**
 * @author asmirnov
 *
 */
class FilterMapping {
	
	private final String filterName;
	private final String servletName;
	private final String urlPattern;


	public FilterMapping(String filterName, String servletName,
			String urlPattern) {
		this.filterName = filterName;
		this.servletName = servletName;
		this.urlPattern = urlPattern;
	}

	public String getFilterName() {
		return filterName;
	}

	public String getServletName() {
		return servletName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((filterName == null) ? 0 : filterName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		FilterMapping other = (FilterMapping) obj;
		if (filterName == null) {
			if (other.filterName != null)
				return false;
		} else if (!filterName.equals(other.filterName))
			return false;
		return true;
	}

	public String getUrlPattern() {
		return urlPattern;
	}
	
}
