/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.Messages;
import org.ajax4jsf.application.ViewHandlerWrapper;
import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.context.ViewResources;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.RenderPhaseComponentListener;

public class AjaxViewHandler
extends ViewHandlerWrapper {
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    public static final String STATE_MARKER_KEY = "org.ajax4jsf.view.state";
    public static final String SERIALIZED_STATE_KEY = "org.ajax4jsf.view.serializedstate";
    private static final Log _log = LogFactory.getLog(AjaxViewHandler.class);
    public static final String VIEW_EXPIRED = "org.ajax4jsf.view.EXPIRED";
    public static final String VIEW_ID_KEY = "org.ajax4jsf.VIEW_ID";
    private static final String INIT_PARAMETER_PREFIX = "_init_parameter_";
    private static final Object NULL = new Object();

    public AjaxViewHandler(ViewHandler parent) {
        super(parent);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Create instance of Ajax ViewHandler");
        }
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        UIViewRoot riRoot;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        ViewIdHolder viewIdHolder = ajaxContext.getViewIdHolder();
        if (null != viewIdHolder && viewIdHolder.skipNavigation(viewId)) {
            viewIdHolder.setViewId(viewId);
            riRoot = facesContext.getViewRoot();
        } else {
            riRoot = super.createView(facesContext, viewId);
            if (null != facesContext.getViewRoot()) {
                ajaxContext.setAjaxRequest(false);
            }
        }
        riRoot.addPhaseListener((PhaseListener)new RenderPhaseComponentListener());
        return riRoot;
    }

    public void writeState(FacesContext context) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest() && ajaxContext.isSelfRender()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)STATE_MARKER_KEY, null);
            writer.writeAttribute("name", (Object)STATE_MARKER_KEY, null);
            writer.endElement("span");
        } else {
            super.writeState(context);
        }
    }

    public String getResourceURL(FacesContext context, String url) {
        String resourceURL;
        if (url.startsWith("resource://")) {
            InternetResource resource = InternetResourceBuilder.getInstance().createResource(null, url.substring(InternetResource.RESOURCE_URI_PREFIX_LENGTH));
            resourceURL = resource.getUri(context, null);
        } else {
            resourceURL = super.getResourceURL(context, url);
        }
        return resourceURL;
    }

    public void renderView(FacesContext context, UIViewRoot root) throws IOException, FacesException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (root instanceof AjaxViewRoot) {
            AjaxViewRoot ajaxRoot = (AjaxViewRoot)root;
            if (ajaxContext.isAjaxRequest()) {
                this.processAjaxEvents(context, ajaxRoot);
                if (ajaxContext.isSelfRender()) {
                    ajaxContext.renderAjax(context);
                }
            }
            if (!context.getResponseComplete()) {
                super.renderView(context, root);
            }
        } else {
            super.renderView(context, root);
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        if (null != requestMap.get("com.exade.vcp.Filter.ResponseWrapper")) {
            if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED))) {
                ViewResources viewResources = new ViewResources();
                boolean extendedSkinningAllowed = true;
                String skinningLevel = AjaxViewHandler.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING_LEVEL");
                if (skinningLevel != null && skinningLevel.length() > 0) {
                    if ("basic".equals(skinningLevel)) {
                        extendedSkinningAllowed = false;
                    } else if (!"extended".equals(skinningLevel)) {
                        throw new IllegalArgumentException("Value: " + skinningLevel + " of " + "org.richfaces.CONTROL_SKINNING_LEVEL" + " init parameter is invalid! Only " + "extended" + ", " + "basic" + " can be used");
                    }
                }
                viewResources.setExtendedSkinningAllowed(extendedSkinningAllowed);
                viewResources.setScriptStrategy(AjaxViewHandler.getInitParameterValue(context, "org.richfaces.LoadScriptStrategy"));
                boolean useStdControlsSkinning = false;
                String stdControlsSkinning = AjaxViewHandler.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING");
                if (stdControlsSkinning != null) {
                    useStdControlsSkinning = "enable".equals(stdControlsSkinning);
                }
                viewResources.setUseStdControlsSkinning(useStdControlsSkinning);
                boolean useStdControlsSkinningClasses = true;
                String stdControlsSkinningClasses = AjaxViewHandler.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING_CLASSES");
                if (stdControlsSkinningClasses != null) {
                    useStdControlsSkinningClasses = "enable".equals(stdControlsSkinningClasses);
                }
                viewResources.setUseStdControlsSkinningClasses(useStdControlsSkinningClasses);
                viewResources.setStyleStrategy(AjaxViewHandler.getInitParameterValue(context, "org.richfaces.LoadStyleStrategy"));
                viewResources.processHeadResources(context);
                requestMap.put("org.ajax4jsf.framework.HEAD_EVENTS_LIST", viewResources.getHeadEvents());
                requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
            }
            requestMap.put(VIEW_ID_KEY, context.getViewRoot().getViewId());
        }
    }

    private void processAjaxEvents(FacesContext context, AjaxViewRoot ajaxRoot) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)Messages.getMessage((String)"PROCESS_AJAX_EVENTS_INFO"));
        }
        ajaxRoot.broadcastAjaxEvents(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitParameterValue(FacesContext context, String parameterName) {
        String key = INIT_PARAMETER_PREFIX + parameterName;
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Object mutex = externalContext.getRequest();
        Object parameterValue = null;
        Object object = mutex;
        synchronized (object) {
            parameterValue = applicationMap.get(key);
            if (parameterValue == null) {
                String initParameter = externalContext.getInitParameter(parameterName);
                if (initParameter != null) {
                    if (ELUtils.isValueReference(initParameter)) {
                        Application application = context.getApplication();
                        ExpressionFactory expressionFactory = application.getExpressionFactory();
                        parameterValue = expressionFactory.createValueExpression(context.getELContext(), initParameter, String.class);
                    } else {
                        parameterValue = initParameter;
                    }
                } else {
                    parameterValue = NULL;
                }
                applicationMap.put(key, parameterValue);
            }
        }
        return AjaxViewHandler.evaluate(context, parameterValue);
    }

    private static String evaluate(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }
}

