/**
 * 
 */
package org.richfaces.model;

import java.util.List;

/**
 * @author pawelgo
 *
 */
public class ExtendedTableDataModelWrapper<T> extends ExtendedTableDataModel<T> {

	private static final long serialVersionUID = 6932958007982793632L;
	
	protected List<T> wrappedList;
	
	/**
	 * 
	 * @param dataProvider
	 * @param wrappedList
	 */
	public ExtendedTableDataModelWrapper(DataProvider<T> dataProvider, List<T> wrappedList) {
		super(dataProvider);
		this.wrappedList = wrappedList;
	}

	protected List<T> loadData(int startRow, int endRow) {
		//return super.loadData(startRow, endRow);
		return wrappedList.subList(startRow, endRow);
	}

	public int getRowCount() {
		return wrappedList.size();
	}
	
	
	

}
