/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.SAXEndElementEvent;
import org.ajax4jsf.context.SAXStartElementEvent;
import org.ajax4jsf.context.SAXTextEvent;
import org.ajax4jsf.io.SAXResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourceProducer;
import org.ajax4jsf.renderkit.HeaderResourceProducer2;
import org.ajax4jsf.renderkit.UserResourceRenderer;
import org.ajax4jsf.renderkit.UserResourceRenderer2;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.URIInternetResource;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.RenderPhaseComponentVisitor;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinNotFoundException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPhaseViewResourcesVisitor
implements RenderPhaseComponentVisitor {
    public static final String COMPONENT_RESOURCE_LINK_CLASS = "component";
    public static final String USER_RESOURCE_LINK_CLASS = "user";
    private static final Log log = LogFactory.getLog(RenderPhaseViewResourcesVisitor.class);
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    private static final String INIT_PARAMETER_PREFIX = "_init_parameter_";
    private static final Object NULL = new Object();
    private static final Map<String, Object> EXTENDED_SKINNING = new HashMap<String, Object>(1);
    public static final String SKINNING_STYLES_PATH = "/org/richfaces/renderkit/html/css/";
    private boolean extendedSkinningAllowed = true;

    private boolean encodeSkinningResources(FacesContext context, InternetResourceBuilder resourceBuilder) throws IOException, FacesException {
        boolean useStdControlsSkinning = false;
        String stdControlsSkinning = RenderPhaseViewResourcesVisitor.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING");
        if (stdControlsSkinning != null) {
            useStdControlsSkinning = "enable".equals(stdControlsSkinning);
        }
        boolean useStdControlsSkinningClasses = true;
        String stdControlsSkinningClasses = RenderPhaseViewResourcesVisitor.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING_CLASSES");
        if (stdControlsSkinningClasses != null) {
            useStdControlsSkinningClasses = "enable".equals(stdControlsSkinningClasses);
        }
        String resourceSuffix = null;
        if (useStdControlsSkinning) {
            resourceSuffix = useStdControlsSkinningClasses ? "_both.xcss" : ".xcss";
        } else if (useStdControlsSkinningClasses) {
            resourceSuffix = "_classes.xcss";
        }
        if (resourceSuffix != null) {
            resourceBuilder.createResource((Object)this, SKINNING_STYLES_PATH.concat("basic").concat(resourceSuffix)).encode(context, null);
            if (this.extendedSkinningAllowed) {
                resourceBuilder.createResource((Object)this, SKINNING_STYLES_PATH.concat("extended").concat(resourceSuffix)).encode(context, null, EXTENDED_SKINNING);
            }
            return true;
        }
        return false;
    }

    public Object beforeRoot(PhaseEvent event) {
        State result = null;
        FacesContext context = event.getFacesContext();
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED)) && null != requestMap.get("com.exade.vcp.Filter.ResponseWrapper")) {
            HeadResponseWriter userWriter;
            HeadResponseWriter componentWriter;
            InternetResourceBuilder internetResourceBuilder;
            Skin skin;
            boolean ajaxRequest;
            boolean useSkinning;
            boolean processScripts;
            boolean processStyles;
            block23: {
                processStyles = true;
                processScripts = true;
                useSkinning = false;
                ajaxRequest = AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest(context);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Process component tree for collect used scripts and styles");
                }
                skin = null;
                try {
                    skin = SkinFactory.getInstance().getSkin(context);
                    if ("false".equals(skin.getParameter(context, "loadStyleSheets"))) {
                        processStyles = false;
                    }
                }
                catch (SkinNotFoundException e) {
                    log.warn((Object)"Current Skin is not found", (Throwable)e);
                }
                internetResourceBuilder = InternetResourceBuilder.getInstance();
                ResponseWriter oldResponseWriter = context.getResponseWriter();
                componentWriter = new HeadResponseWriter(COMPONENT_RESOURCE_LINK_CLASS);
                userWriter = new HeadResponseWriter(USER_RESOURCE_LINK_CLASS);
                try {
                    String styleStrategy;
                    block22: {
                        componentWriter.startDocument();
                        userWriter.startDocument();
                        context.setResponseWriter((ResponseWriter)componentWriter);
                        String scriptStrategy = externalContext.getInitParameter("org.richfaces.LoadScriptStrategy");
                        if (null != scriptStrategy) {
                            if ("NONE".equals(scriptStrategy)) {
                                processScripts = false;
                            } else if ("ALL".equals(scriptStrategy)) {
                                processScripts = false;
                                if (!ajaxRequest) {
                                    try {
                                        internetResourceBuilder.createResource((Object)this, "/org/ajax4jsf/framework.pack.js").encode(context, null);
                                        internetResourceBuilder.createResource((Object)this, "/org/richfaces/ui.pack.js").encode(context, null);
                                    }
                                    catch (ResourceNotFoundException e) {
                                        if (!log.isWarnEnabled()) break block22;
                                        log.warn((Object)("No aggregated javaScript library found " + e.getMessage()));
                                    }
                                }
                            }
                        }
                    }
                    if ("NONE".equals(styleStrategy = externalContext.getInitParameter("org.richfaces.LoadStyleStrategy"))) {
                        processStyles = false;
                        break block23;
                    }
                    if ("ALL".equals(styleStrategy)) {
                        processStyles = false;
                        if (ajaxRequest) break block23;
                        try {
                            useSkinning = this.encodeSkinningResources(context, internetResourceBuilder);
                            internetResourceBuilder.createResource((Object)this, "/org/richfaces/skin.xcss").encode(context, null);
                        }
                        catch (ResourceNotFoundException e) {
                            if (log.isWarnEnabled()) {
                                log.warn((Object)("No stylesheet found " + e.getMessage()));
                            }
                            break block23;
                        }
                    }
                    useSkinning = this.encodeSkinningResources(context, internetResourceBuilder);
                }
                catch (IOException e) {
                    throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
                }
                finally {
                    context.setResponseWriter(oldResponseWriter);
                }
            }
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            result = new State(processScripts, processStyles, useSkinning, renderKit, internetResourceBuilder, componentWriter, userWriter, ajaxRequest, skin);
        }
        return result;
    }

    private void encodeResources(FacesContext context, ResourceRenderer renderer, Set<String> set) throws IOException {
        if (set != null) {
            URIInternetResource resourceImpl = new URIInternetResource();
            for (String uri : set) {
                resourceImpl.setUri(uri);
                renderer.encode((InternetResource)resourceImpl, context, null);
            }
        }
    }

    public void beforeComponent(UIComponent component, PhaseEvent event, Object object) {
        if (object != null) {
            State state = (State)object;
            FacesContext context = event.getFacesContext();
            Renderer renderer = RenderPhaseViewResourcesVisitor.getRenderer(context, component, state.renderKit);
            if (null != renderer) {
                ResponseWriter oldResponseWriter = context.getResponseWriter();
                try {
                    if ((state.processScripts || state.processStyles) && (renderer instanceof HeaderResourceProducer2 || renderer instanceof HeaderResourceProducer)) {
                        context.setResponseWriter((ResponseWriter)state.getComponentWriter());
                        if (renderer instanceof HeaderResourceProducer2) {
                            HeaderResourceProducer2 producer = (HeaderResourceProducer2)renderer;
                            producer.encodeToHead(context, component, state.processStyles, state.processScripts);
                        } else if (renderer instanceof HeaderResourceProducer) {
                            HeaderResourceProducer producer = (HeaderResourceProducer)renderer;
                            if (state.processScripts) {
                                this.encodeResources(context, state.resourceBuilder.getScriptRenderer(), producer.getHeaderScripts(context, component));
                            }
                            if (state.processStyles) {
                                this.encodeResources(context, state.resourceBuilder.getStyleRenderer(), producer.getHeaderStyles(context, component));
                            }
                        }
                    } else if (renderer instanceof UserResourceRenderer2) {
                        context.setResponseWriter((ResponseWriter)state.getUserWriter());
                        UserResourceRenderer2 producer = (UserResourceRenderer2)renderer;
                        producer.encodeToHead(context, component);
                    } else if (renderer instanceof UserResourceRenderer) {
                        context.setResponseWriter((ResponseWriter)state.getUserWriter());
                        UserResourceRenderer producer = (UserResourceRenderer)renderer;
                        this.encodeResources(context, state.resourceBuilder.getScriptRenderer(), producer.getHeaderScripts(context, component));
                        this.encodeResources(context, state.resourceBuilder.getStyleRenderer(), producer.getHeaderStyles(context, component));
                    }
                }
                catch (IOException e) {
                    throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
                }
                finally {
                    context.setResponseWriter(oldResponseWriter);
                }
            }
        }
    }

    public void afterComponent(UIComponent component, PhaseEvent event, Object state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRoot(PhaseEvent event, Object object) {
        if (object != null) {
            FacesContext context = event.getFacesContext();
            ExternalContext externalContext = context.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            State state = (State)object;
            String skinStyleSheetUri = null;
            String skinExtendedStyleSheetUri = null;
            if (state.skin != null) {
                skinStyleSheetUri = (String)state.skin.getParameter(context, "generalStyleSheet");
                skinExtendedStyleSheetUri = (String)state.skin.getParameter(context, "extendedStyleSheet");
            }
            boolean useSkinning = state.useSkinning;
            try {
                ResponseWriter oldWriter = context.getResponseWriter();
                try {
                    URIInternetResource resourceImpl;
                    String resourceURL;
                    HeadResponseWriter responseWriter = state.getComponentWriter();
                    context.setResponseWriter((ResponseWriter)responseWriter);
                    if (null != skinStyleSheetUri) {
                        resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinStyleSheetUri);
                        resourceImpl = new URIInternetResource();
                        resourceImpl.setUri(resourceURL);
                        resourceImpl.setRenderer(state.resourceBuilder.getStyleRenderer());
                        resourceImpl.encode(context, null);
                        useSkinning = true;
                    }
                    if (null != skinExtendedStyleSheetUri && this.extendedSkinningAllowed) {
                        resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinExtendedStyleSheetUri);
                        resourceImpl = new URIInternetResource();
                        resourceImpl.setUri(resourceURL);
                        resourceImpl.setRenderer(state.resourceBuilder.getStyleRenderer());
                        resourceImpl.encode(context, null, EXTENDED_SKINNING);
                        useSkinning = true;
                    }
                    if (!state.ajaxRequest && useSkinning && this.extendedSkinningAllowed) {
                        responseWriter.startElement("script", null);
                        responseWriter.writeAttribute("type", "text/javascript", null);
                        responseWriter.writeText("window.RICH_FACES_EXTENDED_SKINNING_ON=true;", null);
                        responseWriter.endElement("script");
                    }
                    if (state.processScripts) {
                        InternetResource resource = state.resourceBuilder.createResource(null, "/org/richfaces/renderkit/html/scripts/skinning.js");
                        resource.encode(context, null);
                    }
                }
                finally {
                    context.setResponseWriter(oldWriter);
                }
                state.getComponentWriter().endDocument();
                state.getUserWriter().endDocument();
            }
            catch (IOException e) {
                throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
            }
            Object[] stateEvents = state.getEvents();
            if (log.isDebugEnabled()) {
                log.debug((Object)Arrays.toString(stateEvents));
            }
            requestMap.put("org.ajax4jsf.framework.HEAD_EVENTS_LIST", stateEvents);
            requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
        }
    }

    private static Renderer getRenderer(FacesContext context, UIComponent comp, RenderKit renderKit) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitParameterValue(FacesContext context, String parameterName) {
        String key = INIT_PARAMETER_PREFIX + parameterName;
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Object mutex = externalContext.getRequest();
        Object parameterValue = null;
        Object object = mutex;
        synchronized (object) {
            parameterValue = applicationMap.get(key);
            if (parameterValue == null) {
                String initParameter = externalContext.getInitParameter(parameterName);
                if (initParameter != null) {
                    if (ELUtils.isValueReference(initParameter)) {
                        Application application = context.getApplication();
                        ExpressionFactory expressionFactory = application.getExpressionFactory();
                        parameterValue = expressionFactory.createValueExpression(context.getELContext(), initParameter, String.class);
                    } else {
                        parameterValue = initParameter;
                    }
                } else {
                    parameterValue = NULL;
                }
                applicationMap.put(key, parameterValue);
            }
        }
        return RenderPhaseViewResourcesVisitor.evaluate(context, parameterValue);
    }

    private static String evaluate(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }

    static {
        EXTENDED_SKINNING.put("media", "rich-extended-skinning");
    }

    private class State {
        private RenderKit renderKit;
        private boolean processStyles;
        private boolean processScripts;
        private HeadResponseWriter component;
        private HeadResponseWriter user;
        private InternetResourceBuilder resourceBuilder;
        private boolean useSkinning;
        private boolean ajaxRequest;
        private Skin skin;

        protected HeadResponseWriter getComponentWriter() {
            return this.component;
        }

        protected HeadResponseWriter getUserWriter() {
            return this.user;
        }

        protected Object[] getEvents() {
            List componentList = this.component.getEventsList();
            List userList = this.user.getEventsList();
            Object[] result = new Object[componentList.size() + userList.size()];
            componentList.toArray(result);
            System.arraycopy(userList.toArray(), 0, result, componentList.size(), userList.size());
            return result;
        }

        public State(boolean processScripts, boolean processStyles, boolean useSkinning, RenderKit renderKit, InternetResourceBuilder resourceBuilder, HeadResponseWriter component, HeadResponseWriter user, boolean ajaxRequest, Skin skin) {
            this.processScripts = processScripts;
            this.processStyles = processStyles;
            this.useSkinning = useSkinning;
            this.renderKit = renderKit;
            this.resourceBuilder = resourceBuilder;
            this.component = component;
            this.user = user;
            this.ajaxRequest = ajaxRequest;
            this.skin = skin;
        }
    }

    class HeadResponseWriter
    extends SAXResponseWriter {
        public List getEventsList() {
            return ((ResponseWriterContentHandler)this.getXmlConsumer()).events;
        }

        public HeadResponseWriter(String linkClass) {
            super(new ResponseWriterContentHandler(linkClass));
        }
    }

    private class ResponseWriterContentHandler
    implements ContentHandler {
        private List<Object> events = new ArrayList<Object>();
        private String linkClass;

        public ResponseWriterContentHandler(String linkClass) {
            this.linkClass = linkClass;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.events.add(new SAXTextEvent(new String(ch, start, length)));
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            this.events.add(new SAXEndElementEvent(localName));
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public void setDocumentLocator(Locator locator) {
            throw new UnsupportedOperationException();
        }

        public void skippedEntity(String name) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            HashMap<String, String> attsMap = new HashMap<String, String>(atts.getLength());
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                attsMap.put(atts.getLocalName(i), atts.getValue(i));
            }
            if ("link".equals(localName)) {
                attsMap.put("class", this.linkClass);
            }
            this.events.add(new SAXStartElementEvent(localName, attsMap));
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            throw new UnsupportedOperationException();
        }
    }
}

