/**
 * 
 */
package org.ajax4jsf.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;

import org.ajax4jsf.io.SAXResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourceProducer;
import org.ajax4jsf.renderkit.HeaderResourceProducer2;
import org.ajax4jsf.renderkit.UserResourceRenderer;
import org.ajax4jsf.renderkit.UserResourceRenderer2;
import org.ajax4jsf.renderkit.RendererUtils.HTML;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBase;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.util.ELUtils;
import org.ajax4jsf.webapp.BaseFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.RenderPhaseComponentVisitor;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinNotFoundException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RenderPhaseViewResourcesVisitor implements
		RenderPhaseComponentVisitor {
	
	public static final String COMPONENT_RESOURCE_LINK_CLASS = "component";

	public static final String USER_RESOURCE_LINK_CLASS = "user";

	private class ResponseWriterContentHandler implements ContentHandler {

		private List<Object> events = new ArrayList<Object>();

		private String linkClass;

		public ResponseWriterContentHandler(String linkClass) {
			super();
			this.linkClass = linkClass;
		}

		public void characters(char[] ch, int start, int length)
				throws SAXException {

			events.add(new SAXTextEvent(new String(ch, start, length)));
		}

		public void endDocument() throws SAXException {
		}

		public void endElement(String uri, String localName, String name)
				throws SAXException {
			events.add(new SAXEndElementEvent(localName));
		}

		public void endPrefixMapping(String prefix) throws SAXException {
			throw new UnsupportedOperationException();
		}

		public void ignorableWhitespace(char[] ch, int start, int length)
				throws SAXException {
		}

		public void processingInstruction(String target, String data)
				throws SAXException {
			throw new UnsupportedOperationException();
		}

		public void setDocumentLocator(Locator locator) {
			throw new UnsupportedOperationException();
		}

		public void skippedEntity(String name) throws SAXException {
			throw new UnsupportedOperationException();
		}

		public void startDocument() throws SAXException {
		}

		public void startElement(String uri, String localName,
				String name, Attributes atts) throws SAXException {

			Map<String, String> attsMap = new HashMap<String, String>(atts.getLength());
			int length = atts.getLength();

			for (int i = 0; i < length; i++) {
				attsMap.put(atts.getLocalName(i), atts.getValue(i));
			}
			
			if (HTML.LINK_ELEMENT.equals(localName)) {
				attsMap.put(HTML.class_ATTRIBUTE, linkClass);
			}
			
			events.add(new SAXStartElementEvent(localName, attsMap));
		}

		public void startPrefixMapping(String prefix, String uri)
				throws SAXException {
			throw new UnsupportedOperationException();
		}
		
	};
	
	class HeadResponseWriter extends SAXResponseWriter {
	
		public List getEventsList() {
			return ((ResponseWriterContentHandler) getXmlConsumer()).events;
		}
		
		public HeadResponseWriter(String linkClass) {
			super(new ResponseWriterContentHandler(linkClass));
			
		}
	}

	private class State {
		
		private RenderKit renderKit;
		private boolean processStyles;
		private boolean processScripts;
		
		private HeadResponseWriter component;
		private HeadResponseWriter user;
		
		private InternetResourceBuilder resourceBuilder;
		private ResourceRenderer scriptRenderer;
		private ResourceRenderer styleRenderer;
		private boolean useSkinning;
		private boolean ajaxRequest;
		
		protected ResourceRenderer getScriptRenderer() {
			return scriptRenderer;
		}
		
		protected ResourceRenderer getStyleRenderer() {
			return styleRenderer;
		}
		
		protected HeadResponseWriter getComponentWriter() {
			return component;
		}
		
		protected HeadResponseWriter getUserWriter() {
			return user;
		}

		protected Object[] getEvents() {
			List componentList = component.getEventsList();
			List userList = user.getEventsList();
		
			Object[] result = new Object[componentList.size() + userList.size()];
			componentList.toArray(result);
			System.arraycopy(userList.toArray(), 0, result, componentList.size(), userList.size());

			return result;
		}
		
		public State(boolean processScripts, boolean processStyles, boolean useSkinning,
				RenderKit renderKit, InternetResourceBuilder resourceBuilder,
				HeadResponseWriter component,
				HeadResponseWriter user, 
				ResourceRenderer scriptRenderer, 
				ResourceRenderer styleRenderer, boolean ajaxRequest) {
			super();
			this.processScripts = processScripts;
			this.processStyles = processStyles;
			this.useSkinning = useSkinning;
			this.renderKit = renderKit;
			this.resourceBuilder = resourceBuilder;
			this.component = component;
			this.user = user;
			
			this.scriptRenderer = scriptRenderer;
			this.styleRenderer = styleRenderer;
		
			this.ajaxRequest = ajaxRequest;
		}

	}

	private static final Log log = LogFactory.getLog(RenderPhaseViewResourcesVisitor.class);

	//TODO remove this in other
	public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
	private static final String INIT_PARAMETER_PREFIX = "_init_parameter_";
	private static final Object NULL = new Object();
	//todo
	
	private static final Map<String, Object> EXTENDED_SKINNING = new HashMap<String, Object>(1);
	
	static {
		EXTENDED_SKINNING.put(HTML.media_ATTRIBUTE, "rich-extended-skinning");
	}
	
	public static final String SKINNING_STYLES_PATH = "/org/richfaces/renderkit/html/css/";

	private boolean extendedSkinningAllowed = true;
	
	private boolean encodeSkinningResources(FacesContext context, InternetResourceBuilder resourceBuilder) throws IOException, FacesException {
		boolean useStdControlsSkinning = false;

		String stdControlsSkinning = getInitParameterValue(context, InternetResourceBuilder.STD_CONTROLS_SKINNING_PARAM);
		if (stdControlsSkinning != null) {
			useStdControlsSkinning = InternetResourceBuilder.ENABLE.equals(stdControlsSkinning);
		}
		
		boolean useStdControlsSkinningClasses = true;

		String stdControlsSkinningClasses = getInitParameterValue(context, InternetResourceBuilder.STD_CONTROLS_SKINNING_CLASSES_PARAM);
		if (stdControlsSkinningClasses != null) {
			useStdControlsSkinningClasses = InternetResourceBuilder.ENABLE.equals(stdControlsSkinningClasses);
		}

		String resourceSuffix = null;
		
		if (useStdControlsSkinning) {
			if (useStdControlsSkinningClasses) {
				resourceSuffix = "_both.xcss";
			} else {
				resourceSuffix = ".xcss";
			}
		} else {
			if (useStdControlsSkinningClasses) {
				resourceSuffix = "_classes.xcss";
			} else {
				//no resources
			}
		}

		if (resourceSuffix != null) {
			resourceBuilder.createResource(
					this, SKINNING_STYLES_PATH.concat("basic").concat(resourceSuffix)).encode(context, null);

			if (extendedSkinningAllowed) {
				resourceBuilder.createResource(
						this, SKINNING_STYLES_PATH.concat("extended").concat(resourceSuffix)).encode(context, null, EXTENDED_SKINNING);
			}
			
			return true;
		}
		
		return false;
	}
	
	/* (non-Javadoc)
	 * @see org.richfaces.event.ComponentPhaseEventHandler#beforePhaseBegin(javax.faces.event.PhaseEvent)
	 */
	public Object beforeRoot(PhaseEvent event) {
		Object result = null;
		FacesContext context = event.getFacesContext();

		ExternalContext externalContext = context.getExternalContext();
		Map<String,Object> requestMap = externalContext.getRequestMap();
		if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED))) {
			if (null != requestMap.get(BaseFilter.RESPONSE_WRAPPER_ATTRIBUTE)) {

				boolean processStyles = true;
				boolean processScripts = true;
				boolean useSkinning = false;
				
				boolean ajaxRequest = AjaxContext.getCurrentInstance(context).isAjaxRequest(context);

				if (log.isDebugEnabled()) {
					log
					.debug("Process component tree for collect used scripts and styles");
				}

				String skinStyleSheetUri = null;
				String skinExtendedStyleSheetUri = null;

				try {
					Skin skin = SkinFactory.getInstance().getSkin(context);
					// For a "NULL" skin, do not collect components stylesheets
					if ("false".equals(skin.getParameter(context,
							Skin.loadStyleSheets))) {
						processStyles = false;
					}

					// Set default style sheet for current skin.
					skinStyleSheetUri = (String) skin.getParameter(context,
							Skin.generalStyleSheet);
					// Set default style sheet for current skin.
					skinExtendedStyleSheetUri = (String) skin.getParameter(context,
							Skin.extendedStyleSheet);
				} catch (SkinNotFoundException e) {
					log.warn("Current Skin is not found", e);
				}
				InternetResourceBuilder internetResourceBuilder = InternetResourceBuilder
				.getInstance();

				ResourceRenderer scriptRenderer = internetResourceBuilder.getRenderer(".js");
				ResourceRenderer styleRenderer = internetResourceBuilder.getRenderer(".css");
				
				ResponseWriter oldResponseWriter = context.getResponseWriter();
				
				HeadResponseWriter componentWriter = new HeadResponseWriter("component");
				HeadResponseWriter userWriter = new HeadResponseWriter("user");
				
				try {
					componentWriter.startDocument();
					userWriter.startDocument();

					context.setResponseWriter(componentWriter);
					
					// Append Skin StyleSheet after a
					if (null != skinStyleSheetUri) {
						String resourceURL = context.getApplication()
						.getViewHandler().getResourceURL(context,
								skinStyleSheetUri);

						InternetResourceImpl resourceImpl = new InternetResourceImpl();
						resourceImpl.setUri(resourceURL);
						resourceImpl.setRenderer(styleRenderer);
						resourceImpl.encode(context, null);

						useSkinning = true;
					}

					if (null != skinExtendedStyleSheetUri && extendedSkinningAllowed) {
						String resourceURL = context.getApplication().getViewHandler().getResourceURL(context,
								skinExtendedStyleSheetUri);

						InternetResourceImpl resourceImpl = new InternetResourceImpl();
						resourceImpl.setUri(resourceURL);
						resourceImpl.setRenderer(styleRenderer);
						resourceImpl.encode(context, null, EXTENDED_SKINNING);

						useSkinning = true;
					}

					// Check init parameters for a resources processing.
					String scriptStrategy = externalContext
					.getInitParameter(InternetResourceBuilder.LOAD_SCRIPT_STRATEGY_PARAM);
					if (null != scriptStrategy) {
						if (InternetResourceBuilder.LOAD_NONE
								.equals(scriptStrategy)) {
							processScripts = false;
						} else if (InternetResourceBuilder.LOAD_ALL
								.equals(scriptStrategy)) {
							processScripts = false;
							// For an "ALL" strategy, it is not necessary to load scripts in the ajax request
							if (!ajaxRequest) {
								try {
									internetResourceBuilder
									.createResource(
											this,
											InternetResourceBuilder.COMMON_FRAMEWORK_SCRIPT).encode(context, null);
									internetResourceBuilder
									.createResource(
											this,
											InternetResourceBuilder.COMMON_UI_SCRIPT).encode(context, null);

								} catch (ResourceNotFoundException e) {
									if (log.isWarnEnabled()) {
										log
										.warn("No aggregated javaScript library found "
												+ e.getMessage());
									}
								}

							}
						}
					}

					String styleStrategy = externalContext
					.getInitParameter(InternetResourceBuilder.LOAD_STYLE_STRATEGY_PARAM);

					if (InternetResourceBuilder.LOAD_NONE.equals(styleStrategy)) {
						processStyles = false;
					} else if (InternetResourceBuilder.LOAD_ALL
							.equals(styleStrategy)) {
						processStyles = false;
						// For an "ALL" strategy, it is not necessary to load styles
						// in the ajax request
						if (!ajaxRequest) {

							try {
								useSkinning = encodeSkinningResources(context, internetResourceBuilder);

								internetResourceBuilder
								.createResource(this, InternetResourceBuilder.COMMON_STYLE).encode(context, null);

							} catch (ResourceNotFoundException e) {
								if (log.isWarnEnabled()) {
									log.warn("No stylesheet found "
											+ e.getMessage());
								}
							}

						}
					} else {
						useSkinning = encodeSkinningResources(context, internetResourceBuilder);
					}
				} catch (IOException e) {
					throw new FacesException(e.getLocalizedMessage(), e);
				} finally {
					context.setResponseWriter(oldResponseWriter);
				}

				RenderKitFactory rkFactory = (RenderKitFactory) FactoryFinder
				.getFactory(FactoryFinder.RENDER_KIT_FACTORY);
				RenderKit renderKit = rkFactory.getRenderKit(context, context
						.getViewRoot().getRenderKitId());
				
				result = new State(processScripts, processStyles, useSkinning, renderKit, 
						internetResourceBuilder, componentWriter, userWriter,
						scriptRenderer, styleRenderer, ajaxRequest);
			}
		}
		return result;
	}

	public static final class InternetResourceImpl extends InternetResourceBase {
		public String getUri() {
			return getKey();
		}

		public void setUri(String uri) {
			setKey(uri);
		}
		
		@Override
		public String getUri(FacesContext context, Object data) {
			return getUri();
		}
	};

	private void encodeResources(FacesContext context, ResourceRenderer renderer, Set<String> set) throws IOException {
		
		if (set != null) {
			InternetResourceImpl resourceImpl = new InternetResourceImpl();
			
			for (String uri : set) {
				resourceImpl.setUri(uri);
				renderer.encode(resourceImpl, context, null);
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.richfaces.event.ComponentPhaseEventHandler#componentBegin(javax.faces.component.UIComponent, javax.faces.event.PhaseEvent, java.lang.Object)
	 */
	public void beforeComponent(UIComponent component, PhaseEvent event,
			Object object) {
		if (object != null) {
			State state = (State) object;
			FacesContext context = event.getFacesContext();
			Renderer renderer = getRenderer(context, component, state.renderKit);
			if (null != renderer) {
				ResponseWriter oldResponseWriter = context.getResponseWriter();
				try {
					if ((state.processScripts || state.processStyles)
							&& (renderer instanceof HeaderResourceProducer2 || renderer instanceof HeaderResourceProducer)) {
						
						context.setResponseWriter(state.getComponentWriter());
						
						if (renderer instanceof HeaderResourceProducer2) {
							HeaderResourceProducer2 producer = (HeaderResourceProducer2) renderer;
							
							producer.encodeToHead(context, state.processStyles, state.processScripts);
						} else if (renderer instanceof HeaderResourceProducer) {
							HeaderResourceProducer producer = (HeaderResourceProducer) renderer;
							
							if (state.processScripts) {
								encodeResources(context, state.getScriptRenderer(), producer.getHeaderScripts(context,
										component));
							}
							if (state.processStyles) {
								encodeResources(context, state.getStyleRenderer(), producer.getHeaderStyles(context,
										component));
							}
						}
					} else if (renderer instanceof UserResourceRenderer2) {
						context.setResponseWriter(state.getUserWriter());

						UserResourceRenderer2 producer = (UserResourceRenderer2) renderer;
						producer.encodeToHead(context);
					} else if (renderer instanceof UserResourceRenderer) {
						context.setResponseWriter(state.getUserWriter());

						UserResourceRenderer producer = (UserResourceRenderer) renderer;
						
						encodeResources(context, state.getScriptRenderer(), producer.getHeaderScripts(context,
								component));

						encodeResources(context, state.getStyleRenderer(), producer.getHeaderStyles(context,
								component));
					}
				} catch (IOException e) {
					throw new FacesException(e.getLocalizedMessage(), e);
				} finally {
					context.setResponseWriter(oldResponseWriter);
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.richfaces.event.ComponentPhaseEventHandler#componentEnd(javax.faces.component.UIComponent, javax.faces.event.PhaseEvent, java.lang.Object)
	 */
	public void afterComponent(UIComponent component, PhaseEvent event,
			Object state) {}

	/* (non-Javadoc)
	 * @see org.richfaces.event.ComponentPhaseEventHandler#beforePhaseEnd(javax.faces.event.PhaseEvent, java.lang.Object)
	 */
	public void afterRoot(PhaseEvent event, Object object) {
		if (object != null) {
			FacesContext context = event.getFacesContext();
			ExternalContext externalContext = context.getExternalContext();
			Map<String,Object> requestMap = externalContext.getRequestMap();
			State state = (State) object;

			try {
				if (state.useSkinning && extendedSkinningAllowed) {
					ResponseWriter oldWriter = context.getResponseWriter();
					
					try {
						HeadResponseWriter responseWriter = state.getComponentWriter();
						if (!state.ajaxRequest) {
							//skinning levels aren't dynamic, page-level setting cannot be changed 
							//by AJAX request
							responseWriter.startElement("script", null);
							responseWriter.writeAttribute(HTML.TYPE_ATTR, "text/javascript", null);
							responseWriter.writeText("window.RICH_FACES_SKINNING_ON=true;", null);
							responseWriter.endElement("script");
						}
						
						context.setResponseWriter(responseWriter);
						
						if (state.processScripts) {
							InternetResource resource = state.resourceBuilder.createResource(null, 
									"/org/richfaces/renderkit/html/scripts/skinning.js");

							resource.encode(context, null);
						}
						
					} finally {
						context.setResponseWriter(oldWriter);
					}
				}
				
				state.getComponentWriter().endDocument();
				state.getUserWriter().endDocument();
			} catch (IOException e) {
				throw new FacesException(e.getLocalizedMessage(), e);
			}
			
			Object[] stateEvents = state.getEvents();
			
			log.debug(Arrays.toString(stateEvents));
			if (log.isDebugEnabled()) {
				log.debug(Arrays.toString(stateEvents));
			}
			
			requestMap.put(AjaxContext.HEAD_EVENTS_PARAMETER, stateEvents);
			
			// Mark as processed.
			requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
		}
	}

	/**
	 * Find renderer for given component.
	 * 
	 * @param context
	 * @param comp
	 * @param renderKit
	 * @return
	 */
	private static Renderer getRenderer(FacesContext context, UIComponent comp, RenderKit renderKit) {
		String rendererType = comp.getRendererType();
		if (rendererType != null) {
			return (renderKit.getRenderer(comp.getFamily(), rendererType));
		} else {
			return (null);
		}

	}
	
	private static String getInitParameterValue(FacesContext context, String parameterName) {
		
		String key = INIT_PARAMETER_PREFIX + parameterName;
		
		ExternalContext externalContext = context.getExternalContext();
		Map<String, Object> applicationMap = externalContext.getApplicationMap();
		Object mutex = externalContext.getRequest();
		Object parameterValue = null;
		
		synchronized (mutex) {
			parameterValue = applicationMap.get(key);

			if (parameterValue == null) {

				String initParameter = externalContext.getInitParameter(parameterName);
				if (initParameter != null) {
					
					if (ELUtils.isValueReference(initParameter)) {
						Application application = context.getApplication();
						ExpressionFactory expressionFactory = application.getExpressionFactory();
						
						parameterValue = expressionFactory.createValueExpression(context.getELContext(), 
								initParameter,
								String.class);
					} else {
						parameterValue = initParameter;
					}
					
				} else {
					parameterValue = NULL;
				}
				
				applicationMap.put(key, parameterValue);
			}
		}
		
		return evaluate(context, parameterValue);
	}
	
	private static String evaluate(FacesContext context, Object parameterValue) {
		if (parameterValue == NULL || parameterValue == null) {
			return null;
		} else if (parameterValue instanceof ValueExpression) {
			ValueExpression expression = (ValueExpression) parameterValue;
			
			return (String) expression.getValue(context.getELContext());
		} else {
			return parameterValue.toString();
		}
	}
	
}
