package org.ajax4jsf.component;

import java.util.ArrayList;
import java.util.List;

import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/**
 * @author Anton Belevich
 *
 */
public class ContextCallbackWrapper implements ContextCallback {
    
    ContextCallback callback;
    
    public ContextCallbackWrapper(ContextCallback callback) {
	this.callback = callback;
    }
    
    public void invokeContextCallback(FacesContext context, UIComponent target) {
	if(isParentRendered(target)) {
	    callback.invokeContextCallback(context, target);
	}    
    }
    
    public boolean isParentRendered( UIComponent target) {

	List <UIComponent> componentsList = new ArrayList<UIComponent>();
	UIComponent component = target;	
	
	while (component != null) {
	    componentsList.add(component);
	    component = component.getParent();
	}
	
	for (int i = 0; i < componentsList.size(); i++) {
	    UIComponent parent = componentsList.get(i);
	    if(!parent.isRendered()) {
		return false;
	    }
	}
	return true;
    }
}
