/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.request.MultipartRequest;
import org.ajax4jsf.resource.InternetResourceService;
import org.ajax4jsf.webapp.BaseXMLFilter;
import org.ajax4jsf.webapp.PollEventsManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFilter
implements Filter {
    public static final String AJAX_PUSH_READY = "READY";
    public static final String AJAX_PUSH_STATUS_HEADER = "Ajax-Push-Status";
    public static final String AJAX_PUSH_KEY_HEADER = "Ajax-Push-Key";
    private static final Log log = LogFactory.getLog(BaseFilter.class);
    public static final boolean DEBUG = true;
    private FilterConfig filterConfig;
    private static final String FUNCTION_NAME_PARAMETER = "function";
    private String function = "alert('Data received');JSHttpRequest.dataReady";
    private String attributesNames;
    private boolean rewriteid = false;
    public static final String REWRITEID_PARAMETER = "rewriteid";
    public static final String STYLESHEET_PARAMETER = "xsl";
    public static final String ABSOLUTE_TAGS_PARAMETER = "absolute-attributes";
    private static final long serialVersionUID = -2295534611886142935L;
    public static final String DATA_PARAMETER = "DATA";
    public static final String DEFAULT_SERVLET_PATH = "/resource";
    public static final String RENDERER_PREFIX = "/renderer";
    public static final String CACHEABLE_PREFIX = "/cache";
    public static final String FILTER_PERFORMED = "com.exade.vcp.Filter.done";
    public static final String RESPONSE_WRAPPER_ATTRIBUTE = "com.exade.vcp.Filter.ResponseWrapper";
    protected BaseXMLFilter xmlFilter = null;
    protected InternetResourceService resourceService = null;
    protected PollEventsManager eventsManager;
    private boolean createTempFiles = false;
    private int maxRequestSize = 0;
    public static final String MULTIPART = "multipart/";
    public static final String REQUESTS_SESSIONS_BEAN_NAME = "_richfaces_upload_sessions";
    public static final String PERCENT_BEAN_NAME = "_richfaces_upload_percents";
    public static final String UPLOAD_FILES_ID = "_richfaces_upload_uid";
    public static final String UPLOADED_COUNTER = "_richfaces_uploaded_file_counter";
    public static final String FILE_UPLOAD_INDICATOR = "_richfaces_upload_file_indicator";
    public static final String SEND_HTTP_ERROR = "_richfaces_send_http_error";

    public void init(FilterConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Init ajax4jsf filter with nane: " + config.getFilterName()));
            Enumeration parameterNames = config.getInitParameterNames();
            StringBuffer parameters = new StringBuffer("Init parameters :\n");
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                parameters.append(name).append(" : '").append(config.getInitParameter(name)).append('\n');
            }
            log.debug((Object)parameters);
        }
        this.filterConfig = config;
        this.setFunction((String)this.nz(this.filterConfig.getInitParameter(FUNCTION_NAME_PARAMETER), this.getFunction()));
        this.setAttributesNames(this.filterConfig.getInitParameter(ABSOLUTE_TAGS_PARAMETER));
        this.xmlFilter.init(config);
        if ("true".equalsIgnoreCase(this.filterConfig.getInitParameter(REWRITEID_PARAMETER))) {
            this.setRewriteid(true);
        }
        this.resourceService = new InternetResourceService();
        this.resourceService.init(this.filterConfig);
        this.eventsManager = new PollEventsManager();
        this.eventsManager.init(this.filterConfig.getServletContext());
        String param = this.filterConfig.getInitParameter("createTempFiles");
        this.createTempFiles = param != null ? Boolean.parseBoolean(param) : true;
        param = this.filterConfig.getInitParameter("maxRequestSize");
        if (param != null) {
            this.maxRequestSize = Integer.parseInt(param);
        }
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    private boolean isFileSizeRestricted(ServletRequest request, int maxSize) {
        return maxSize != 0 && request.getContentLength() > maxSize;
    }

    private boolean checkFileCount(HttpServletRequest request) {
        Integer i;
        String id;
        HttpSession session = request.getSession();
        Map map = (Map)session.getAttribute(UPLOADED_COUNTER);
        return map == null || (id = request.getParameter("id")) == null || (i = (Integer)map.get(id)) == null || i != 0;
    }

    private void printResponse(ServletResponse response, String message) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(200);
        httpResponse.setContentType("text/html");
        PrintWriter writer = httpResponse.getWriter();
        writer.write(message);
        writer.close();
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"FILTER_XML_OUTPUT"));
        }
        this.xmlFilter.doXmlFilter(chain, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUploadsAndHandleRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = request;
        String uid = httpRequest.getParameter(UPLOAD_FILES_ID);
        String mimeType = this.xmlFilter.getMimetype();
        if (uid != null) {
            if (this.isMultipartRequest(httpRequest)) {
                MultipartRequest multipartRequest = new MultipartRequest(httpRequest, this.createTempFiles, this.maxRequestSize, uid);
                Map<String, MultipartRequest> sessionsMap = null;
                HashMap<String, Integer> percentMap = null;
                try {
                    HttpSession session;
                    if (this.isFileSizeRestricted((ServletRequest)request, this.maxRequestSize)) {
                        boolean sendError = Boolean.parseBoolean(request.getParameter(SEND_HTTP_ERROR));
                        if (sendError) {
                            response.sendError(413);
                            System.err.println("ERROR 413request entity is larger than the server is willing or able to process.");
                            return;
                        }
                        this.printResponse((ServletResponse)response, "<html id=\"_richfaces_file_upload_size_restricted\"></html>");
                    }
                    if (!this.checkFileCount(httpRequest)) {
                        this.printResponse((ServletResponse)response, "<html id=\"_richfaces_file_upload_forbidden\"></html>");
                    }
                    HttpSession httpSession = session = httpRequest.getSession();
                    synchronized (httpSession) {
                        sessionsMap = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
                        percentMap = (Map)session.getAttribute(PERCENT_BEAN_NAME);
                        if (sessionsMap == null) {
                            sessionsMap = Collections.synchronizedMap(new HashMap());
                            session.setAttribute(REQUESTS_SESSIONS_BEAN_NAME, sessionsMap);
                        }
                        if (percentMap == null) {
                            percentMap = new HashMap<String, Integer>();
                            session.setAttribute(PERCENT_BEAN_NAME, percentMap);
                        }
                    }
                    percentMap.put(uid, 0);
                    sessionsMap.put(uid, multipartRequest);
                    if (multipartRequest.parseRequest()) {
                        this.xmlFilter.setMimetype("text/html");
                        this.handleRequest((HttpServletRequest)multipartRequest, response, chain);
                    }
                    this.printResponse((ServletResponse)response, "<html id=\"_richfaces_file_upload_stopped\"></html>");
                }
                finally {
                    if (sessionsMap != null) {
                        this.xmlFilter.setMimetype(mimeType);
                        sessionsMap.remove(uid);
                        percentMap.remove(uid);
                    }
                }
            } else if ("richfaces_file_upload_action_stop".equals(httpRequest.getParameter("action"))) {
                MultipartRequest multipartRequest;
                HttpSession session = httpRequest.getSession();
                Map sessions = (Map)session.getAttribute(REQUESTS_SESSIONS_BEAN_NAME);
                if (sessions != null && (multipartRequest = (MultipartRequest)((Object)sessions.get(uid))) != null) {
                    multipartRequest.stop();
                    this.handleRequest(request, response, chain);
                }
            } else {
                this.handleRequest(request, response, chain);
            }
        } else {
            this.handleRequest(request, response, chain);
        }
    }

    protected void setupRequestEncoding(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        String contentType = httpServletRequest.getHeader("Content-Type");
        String characterEncoding = this.lookupCharacterEncoding(contentType);
        if (characterEncoding == null) {
            HttpSession session = httpServletRequest.getSession(false);
            if (session != null) {
                characterEncoding = (String)session.getAttribute("javax.faces.request.charset");
            }
            if (characterEncoding != null) {
                httpServletRequest.setCharacterEncoding(characterEncoding);
            }
        }
    }

    private String lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage((String)"CONTENT_TYPE_ENCODING", (Object)characterEncoding));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"CONTENT_TYPE_NO_ENCODING", (Object)contentType));
            }
        }
        return characterEncoding;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        startTimeMills = 0L;
        httpServletRequest = (HttpServletRequest)request;
        httpServletResponse = (HttpServletResponse)response;
        if (BaseFilter.log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis();
            BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_START_INFO", (Object)new Date(startTimeMills), (Object)httpServletRequest.getRequestURI()));
        }
        if (request.getAttribute("com.exade.vcp.Filter.done") != Boolean.TRUE) {
            try {
                request.setAttribute("com.exade.vcp.Filter.done", (Object)Boolean.TRUE);
                ajaxPushHeader = httpServletRequest.getHeader("Ajax-Push-Key");
                if (httpServletRequest.getMethod().equals("HEAD") && null != ajaxPushHeader) {
                    listener = this.eventsManager.getListener(ajaxPushHeader);
                    httpServletResponse.setContentType("text/plain");
                    if (listener.isPerformed()) {
                        listener.processed();
                        httpServletResponse.setStatus(200);
                        httpServletResponse.setHeader("Ajax-Push-Status", "READY");
                        if (BaseFilter.log.isDebugEnabled()) {
                            BaseFilter.log.debug((Object)("Occurs event for a id " + ajaxPushHeader));
                        }
                    } else {
                        httpServletResponse.setStatus(202);
                        if (BaseFilter.log.isDebugEnabled()) {
                            BaseFilter.log.debug((Object)("No event for a id " + ajaxPushHeader));
                        }
                    }
                    httpServletResponse.setContentLength(0);
                }
                if (this.getResourceService().serviceResource(httpServletRequest, httpServletResponse)) ** GOTO lbl40
                this.setupRequestEncoding(httpServletRequest);
                this.processUploadsAndHandleRequest(httpServletRequest, httpServletResponse, chain);
            }
            finally {
                request.removeAttribute("com.exade.vcp.Filter.done");
                ajaxContext = request.getAttribute("ajaxContext");
                if (null != ajaxContext && ajaxContext instanceof AjaxContext) {
                    ((AjaxContext)ajaxContext).release();
                    request.removeAttribute("ajaxContext");
                }
            }
        } else {
            if (BaseFilter.log.isDebugEnabled()) {
                BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_NO_XML_CHAIN_2"));
            }
            chain.doFilter(request, response);
        }
lbl40:
        // 4 sources

        if (BaseFilter.log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis() - startTimeMills;
            BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_STOP_INFO", (Object)("" + startTimeMills), (Object)httpServletRequest.getRequestURI()));
        }
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroy() {
    }

    ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected synchronized InternetResourceService getResourceService() throws ServletException {
        return this.resourceService;
    }

    protected void setFunction(String function) {
        this.function = function;
    }

    protected String getFunction() {
        return this.function;
    }

    protected void setRewriteid(boolean rewriteid) {
        this.rewriteid = rewriteid;
    }

    protected boolean isRewriteid() {
        return this.rewriteid;
    }

    protected void setAttributesNames(String attributesNames) {
        this.attributesNames = attributesNames;
    }

    protected String getAttributesNames() {
        return this.attributesNames;
    }
}

