/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.HeaderResourceProducer;
import org.ajax4jsf.renderkit.UserResourceRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.event.RenderPhaseComponentVisitor;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinNotFoundException;

public class RenderPhaseViewResourcesVisitor
implements RenderPhaseComponentVisitor {
    private static final Log log = LogFactory.getLog(RenderPhaseViewResourcesVisitor.class);
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    private static final String INIT_PARAMETER_PREFIX = "_init_parameter_";
    private static final Object NULL = new Object();
    private static final Pattern USER_AGENTS = Pattern.compile(" AppleWebKit/|^Opera/| Opera ");

    public Object beforeRoot(PhaseEvent event) {
        State result = null;
        FacesContext context = event.getFacesContext();
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED)) && null != requestMap.get("com.exade.vcp.Filter.ResponseWrapper")) {
            InternetResourceBuilder internetResourceBuilder;
            boolean ajaxRequest;
            LinkedHashSet userStyles;
            LinkedHashSet userScripts;
            LinkedHashSet<String> styles;
            LinkedHashSet<String> scripts;
            Boolean processScripts;
            Boolean processStyles;
            block32: {
                processStyles = true;
                processScripts = true;
                scripts = new LinkedHashSet<String>();
                styles = new LinkedHashSet<String>();
                userScripts = new LinkedHashSet();
                userStyles = new LinkedHashSet();
                ajaxRequest = AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest(context);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Process component tree for collect used scripts and styles");
                }
                try {
                    Skin skin = SkinFactory.getInstance().getSkin(context);
                    if ("false".equals(skin.getParameter(context, "loadStyleSheets"))) {
                        processStyles = false;
                    }
                }
                catch (SkinNotFoundException e) {
                    log.warn((Object)"Current Skin is not found", (Throwable)e);
                }
                internetResourceBuilder = InternetResourceBuilder.getInstance();
                String scriptStrategy = externalContext.getInitParameter("org.richfaces.LoadScriptStrategy");
                if (null != scriptStrategy) {
                    if ("NONE".equals(scriptStrategy)) {
                        processScripts = false;
                    } else if ("ALL".equals(scriptStrategy)) {
                        processScripts = false;
                        if (!ajaxRequest) {
                            try {
                                scripts.add(internetResourceBuilder.createResource((Object)this, "/org/ajax4jsf/framework.pack.js").getUri(context, null));
                                scripts.add(internetResourceBuilder.createResource((Object)this, "/org/richfaces/ui.pack.js").getUri(context, null));
                            }
                            catch (ResourceNotFoundException e) {
                                if (!log.isWarnEnabled()) break block32;
                                log.warn((Object)("No aggregated javaScript library found " + e.getMessage()));
                            }
                        }
                    }
                }
            }
            boolean useStdControlsSkinning = false;
            String stdControlsSkinning = RenderPhaseViewResourcesVisitor.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING");
            if (stdControlsSkinning != null) {
                useStdControlsSkinning = "enable".equals(stdControlsSkinning);
            }
            boolean useStdControlsSkinningClasses = true;
            String stdControlsSkinningClasses = RenderPhaseViewResourcesVisitor.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING_CLASSES");
            if (stdControlsSkinningClasses != null) {
                useStdControlsSkinningClasses = "enable".equals(stdControlsSkinningClasses);
            }
            boolean useExtendedSkinning = RenderPhaseViewResourcesVisitor.isExtendedSkinningEnabled(externalContext);
            String styleStrategy = externalContext.getInitParameter("org.richfaces.LoadStyleStrategy");
            if ("NONE".equals(styleStrategy)) {
                processStyles = false;
            } else if ("ALL".equals(styleStrategy)) {
                processStyles = false;
                if (!ajaxRequest) {
                    String commonStyle = "/org/richfaces/skin";
                    if (useStdControlsSkinning || useStdControlsSkinningClasses) {
                        commonStyle = RenderPhaseViewResourcesVisitor.isExtendedSkinningEnabled(externalContext) ? commonStyle + "-ext" : commonStyle + "-bas";
                        if (useStdControlsSkinning && useStdControlsSkinningClasses) {
                            commonStyle = commonStyle + "-both";
                        } else if (useStdControlsSkinning) {
                            commonStyle = commonStyle + "-styles";
                        } else if (useStdControlsSkinningClasses) {
                            commonStyle = commonStyle + "-classes";
                        }
                    }
                    commonStyle = commonStyle + ".xcss";
                    try {
                        styles.add(internetResourceBuilder.createResource((Object)this, commonStyle).getUri(context, null));
                    }
                    catch (ResourceNotFoundException e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("No aggregated stylesheet found " + e.getMessage()));
                        }
                    }
                }
            } else {
                if (useStdControlsSkinning) {
                    styles.add(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/basic.xcss").getUri(context, null));
                    if (useExtendedSkinning) {
                        styles.add(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/extended.xcss").getUri(context, null));
                    }
                }
                if (useStdControlsSkinningClasses) {
                    styles.add(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/basic_classes.xcss").getUri(context, null));
                    if (useExtendedSkinning) {
                        styles.add(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/extended_classes.xcss").getUri(context, null));
                    }
                }
            }
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            result = new State(processScripts, processStyles, renderKit, scripts, styles, userScripts, userStyles);
        }
        return result;
    }

    public void beforeComponent(UIComponent component, PhaseEvent event, Object object) {
        if (object != null) {
            State state = (State)object;
            FacesContext context = event.getFacesContext();
            Renderer renderer = RenderPhaseViewResourcesVisitor.getRenderer(context, component, state.renderKit);
            if (null != renderer) {
                if ((state.processScripts || state.processStyles) && renderer instanceof HeaderResourceProducer) {
                    LinkedHashSet set;
                    HeaderResourceProducer producer = (HeaderResourceProducer)renderer;
                    if (state.processScripts && null != (set = producer.getHeaderScripts(context, component))) {
                        state.scripts.addAll(set);
                    }
                    if (state.processStyles && null != (set = producer.getHeaderStyles(context, component))) {
                        state.styles.addAll(set);
                    }
                } else if (renderer instanceof UserResourceRenderer) {
                    UserResourceRenderer producer = (UserResourceRenderer)renderer;
                    LinkedHashSet set = producer.getHeaderScripts(context, component);
                    if (null != set) {
                        state.userScripts.addAll(set);
                    }
                    if (null != (set = producer.getHeaderStyles(context, component))) {
                        state.userStyles.addAll(set);
                    }
                }
            }
        }
    }

    public void afterComponent(UIComponent component, PhaseEvent event, Object state) {
    }

    public void afterRoot(PhaseEvent event, Object object) {
        if (object != null) {
            StringBuffer buff;
            String resourceURL;
            FacesContext context = event.getFacesContext();
            ExternalContext externalContext = context.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            State state = (State)object;
            state.scripts.addAll(state.userScripts);
            if (state.scripts.size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff2 = new StringBuffer("Scripts for insert into head : \n");
                    for (String script : state.scripts) {
                        buff2.append(script).append("\n");
                    }
                    log.debug((Object)buff2.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_SCRIPTS", state.scripts);
            }
            String skinStyleSheetUri = null;
            String skinExtendedStyleSheetUri = null;
            try {
                Skin skin = SkinFactory.getInstance().getSkin(context);
                skinStyleSheetUri = (String)skin.getParameter(context, "generalStyleSheet");
                skinExtendedStyleSheetUri = (String)skin.getParameter(context, "extendedStyleSheet");
            }
            catch (SkinNotFoundException e) {
                log.warn((Object)"Current Skin is not found", (Throwable)e);
            }
            if (null != skinStyleSheetUri) {
                resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinStyleSheetUri);
                state.styles.add(resourceURL);
            }
            if (null != skinExtendedStyleSheetUri && RenderPhaseViewResourcesVisitor.isExtendedSkinningEnabled(externalContext)) {
                resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinExtendedStyleSheetUri);
                state.styles.add(resourceURL);
            }
            if (state.styles.size() > 0) {
                if (log.isDebugEnabled()) {
                    buff = new StringBuffer("Styles for insert into head : \n");
                    for (String style : state.styles) {
                        buff.append(style).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_STYLES", state.styles);
            }
            if (state.userStyles.size() > 0) {
                if (log.isDebugEnabled()) {
                    buff = new StringBuffer("User styles for insert into head : \n");
                    for (String style : state.userStyles) {
                        buff.append(style).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_USER_STYLES", state.userStyles);
            }
            requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
            requestMap.put("org.ajax4jsf.VIEW_ID", context.getViewRoot().getViewId());
        }
    }

    private static Renderer getRenderer(FacesContext context, UIComponent comp, RenderKit renderKit) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitParameterValue(FacesContext context, String parameterName) {
        String key = INIT_PARAMETER_PREFIX + parameterName;
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Object mutex = externalContext.getRequest();
        Object parameterValue = null;
        Object object = mutex;
        synchronized (object) {
            parameterValue = applicationMap.get(key);
            if (parameterValue == null) {
                String initParameter = externalContext.getInitParameter(parameterName);
                if (initParameter != null) {
                    if (ELUtils.isValueReference(initParameter)) {
                        Application application = context.getApplication();
                        ExpressionFactory expressionFactory = application.getExpressionFactory();
                        parameterValue = expressionFactory.createValueExpression(context.getELContext(), initParameter, String.class);
                    } else {
                        parameterValue = initParameter;
                    }
                } else {
                    parameterValue = NULL;
                }
                applicationMap.put(key, parameterValue);
            }
        }
        return RenderPhaseViewResourcesVisitor.evaluate(context, parameterValue);
    }

    private static String evaluate(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }

    private static boolean isExtendedSkinningEnabled(ExternalContext context) {
        String userAgent = (String)context.getRequestHeaderMap().get("User-Agent");
        if (userAgent != null) {
            boolean apply;
            boolean bl = apply = !USER_AGENTS.matcher(userAgent).find();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got User-Agent: " + userAgent));
                log.debug((Object)("Applying extended CSS controls styling = " + apply));
            }
            return apply;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User-Agent is null, applying extended CSS controls styling");
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class State {
        private RenderKit renderKit;
        private boolean processStyles;
        private boolean processScripts;
        private LinkedHashSet<String> scripts;
        private LinkedHashSet<String> styles;
        private LinkedHashSet<String> userScripts;
        private LinkedHashSet<String> userStyles;

        private State(boolean processScripts, boolean processStyles, RenderKit renderKit, LinkedHashSet<String> scripts, LinkedHashSet<String> styles, LinkedHashSet<String> userScripts, LinkedHashSet<String> userStyles) {
            this.processScripts = processScripts;
            this.processStyles = processStyles;
            this.renderKit = renderKit;
            this.scripts = scripts;
            this.styles = styles;
            this.userScripts = userScripts;
            this.userStyles = userStyles;
        }
    }
}

