/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.util.Map;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheConfigurationLoader;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.LRUMapCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUMapCacheFactory
implements CacheFactory {
    private static final Log log = LogFactory.getLog(LRUMapCacheFactory.class);
    public static final String CACHE_SIZE_PARAMETER = "org.ajax4jsf.cache.LRU_MAP_CACHE_SIZE";

    public Cache createCache(Map env, CacheLoader cacheLoader, CacheConfigurationLoader cacheConfigurationloader) throws CacheException {
        log.info((Object)("Creating LRUMap cache instance using parameters: " + env));
        String size = (String)env.get(CACHE_SIZE_PARAMETER);
        if (size == null || size.length() == 0) {
            log.info((Object)"Creating LRUMap cache instance of default capacity");
            return new LRUMapCache(cacheLoader);
        }
        int parsedSize = Integer.parseInt(size);
        log.info((Object)("Creating LRUMap cache instance of " + parsedSize + " items capacity"));
        return new LRUMapCache(cacheLoader, parsedSize);
    }
}

