/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.richfaces.model.SortOrder;
import org.richfaces.model.impl.SimpleGridDataModel;

public class ListDataModel
extends SimpleGridDataModel {
    private List data;

    public ListDataModel() {
        this(null);
    }

    public ListDataModel(List data) {
        this.setWrappedData(data);
    }

    public List loadData(int startRow, int endRow, SortOrder sortOrder) {
        if (this.data != null && this.getRowCount() > 0) {
            ArrayList sortedList = this.data;
            if (sortOrder != null) {
                sortedList = new ArrayList(this.data);
                Comparator comparator = this.createComparator(sortOrder);
                if (comparator == null) {
                    Collections.sort(sortedList);
                } else {
                    Collections.sort(sortedList, comparator);
                }
            }
            return sortedList.subList(startRow, endRow);
        }
        return Collections.EMPTY_LIST;
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public Object getWrappedData() {
        return this.data;
    }

    public void setWrappedData(Object data) {
        this.data = (List)data;
    }
}

