/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.io.FastBufferWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheContent
implements Serializable {
    private static final long serialVersionUID = 8120940486890871177L;
    private static final Log _log = LogFactory.getLog(CacheContent.class);
    private transient FastBufferOutputStream outputStream;
    private transient FastBufferWriter stringOutputWriter;
    private transient PrintWriter servletWriter;
    private transient ServletOutputStream servletStream;
    private byte[] content = null;
    private String writerContent = null;
    boolean filledOutputStream = false;
    boolean filledOutputWriter = false;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private String contentType;

    public void send(HttpServletResponse response) throws IOException {
        if (this.filledOutputStream) {
            ServletOutputStream out = response.getOutputStream();
            if (this.content != null) {
                out.write(this.content);
            } else {
                this.outputStream.writeTo((OutputStream)out);
            }
        } else if (this.filledOutputWriter) {
            PrintWriter out = response.getWriter();
            if (null != this.writerContent) {
                ((Writer)out).write(this.writerContent);
            } else {
                this.stringOutputWriter.writeTo(out);
            }
        }
    }

    public void sendHeaders(HttpServletResponse response) {
        for (Map.Entry<String, Object> element : this.headers.entrySet()) {
            String header = element.getKey();
            Object headerValue = element.getValue();
            try {
                if (headerValue instanceof Long) {
                    Long time = (Long)headerValue;
                    response.setDateHeader(header, time.longValue());
                } else if (headerValue instanceof Integer) {
                    Integer value = (Integer)headerValue;
                    response.setIntHeader(header, value.intValue());
                } else {
                    response.setHeader(header, (String)headerValue);
                }
            }
            catch (Exception e) {
                _log.error((Object)("Error set response header " + header + "for value " + headerValue), (Throwable)e);
            }
            if (this.filledOutputStream) {
                if (null != this.content && this.content.length > 0) {
                    response.setIntHeader("Content-Length", this.content.length);
                } else if (null != this.outputStream && this.outputStream.getLength() > 0) {
                    response.setIntHeader("Content-Length", this.outputStream.getLength());
                }
            }
            if (null == this.contentType) continue;
            response.setContentType(this.contentType);
        }
    }

    public void setDateHeader(String name, long value) {
        if (!"Expires".equals(name)) {
            this.headers.put(name, new Long(value));
        }
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, new Integer(value));
    }

    public OutputStream getOutputStream() {
        if (null == this.servletStream) {
            this.outputStream = new FastBufferOutputStream(1024);
            this.servletStream = new ServletOutputStream(){

                public void close() throws IOException {
                    CacheContent.this.filledOutputStream = true;
                    CacheContent.access$002(CacheContent.this, null);
                }

                public void flush() throws IOException {
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    CacheContent.this.outputStream.write(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                }

                public void write(int b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                }
            };
        }
        return this.servletStream;
    }

    public PrintWriter getWriter() {
        if (null == this.servletWriter) {
            this.stringOutputWriter = new FastBufferWriter(1024);
            Writer out = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    CacheContent.this.stringOutputWriter.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                    CacheContent.this.filledOutputWriter = true;
                    CacheContent.this.writerContent = null;
                }
            };
            this.servletWriter = new PrintWriter(out);
        }
        return this.servletWriter;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.filledOutputStream) {
            if (this.outputStream != null) {
                this.content = this.outputStream.toByteArray();
            }
        } else if (this.filledOutputWriter && this.stringOutputWriter != null) {
            char[] cs = this.stringOutputWriter.toCharArray();
            this.writerContent = new String(cs);
        }
        s.defaultWriteObject();
    }

    static /* synthetic */ byte[] access$002(CacheContent x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }
}

