/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.ComponentsLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TreeStrutureNode
implements Externalizable {
    private static final long serialVersionUID = -9038742487716977911L;
    private static final String NULL_ID = "";
    private Map<String, TreeStrutureNode> facets = null;
    private List<TreeStrutureNode> children = null;
    private String type;
    private String id;

    public void apply(FacesContext context, UIComponent component, Set<String> uniqueIds) {
        this.type = component.getClass().getName();
        this.id = component.getId();
        String clientId = component.getClientId(context);
        if (!uniqueIds.add(clientId)) {
            throw new IllegalStateException("duplicate Id for a component " + clientId);
        }
        Map componentFacets = component.getFacets();
        for (Map.Entry element : componentFacets.entrySet()) {
            UIComponent f = (UIComponent)element.getValue();
            if (f.isTransient()) continue;
            TreeStrutureNode facet = new TreeStrutureNode();
            facet.apply(context, f, uniqueIds);
            if (null == this.facets) {
                this.facets = new HashMap<String, TreeStrutureNode>();
            }
            this.facets.put((String)element.getKey(), facet);
        }
        for (UIComponent child : component.getChildren()) {
            if (child.isTransient()) continue;
            TreeStrutureNode t = new TreeStrutureNode();
            t.apply(context, child, uniqueIds);
            if (null == this.children) {
                this.children = new ArrayList<TreeStrutureNode>();
            }
            this.children.add(t);
        }
    }

    public UIComponent restore(ComponentsLoader loader) {
        UIComponent component = loader.createComponent(this.type);
        component.setId(this.id);
        if (null != this.facets) {
            for (Map.Entry entry : this.facets.entrySet()) {
                UIComponent facet = ((TreeStrutureNode)entry.getValue()).restore(loader);
                component.getFacets().put(entry.getKey(), facet);
            }
        }
        if (null != this.children) {
            for (TreeStrutureNode treeStrutureNode : this.children) {
                UIComponent child = treeStrutureNode.restore(loader);
                component.getChildren().add(child);
            }
        }
        return component;
    }

    public Map<String, TreeStrutureNode> getFacets() {
        return this.facets;
    }

    public void setFacets(Map<String, TreeStrutureNode> facets) {
        this.facets = facets;
    }

    public List<TreeStrutureNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeStrutureNode> children) {
        this.children = children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int childrenSize;
        int facetsSize;
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (NULL_ID.equals(this.id)) {
            this.id = null;
        }
        if ((facetsSize = in.readInt()) > 0) {
            this.facets = new HashMap<String, TreeStrutureNode>(facetsSize);
            for (int i = 0; i < facetsSize; ++i) {
                String facetName = in.readUTF();
                TreeStrutureNode facet = new TreeStrutureNode();
                facet.readExternal(in);
                this.facets.put(facetName, facet);
            }
        }
        if ((childrenSize = in.readInt()) > 0) {
            this.children = new ArrayList<TreeStrutureNode>(childrenSize);
            for (int i = 0; i < childrenSize; ++i) {
                TreeStrutureNode child = new TreeStrutureNode();
                child.readExternal(in);
                this.children.add(child);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.type);
        out.writeUTF(null == this.id ? NULL_ID : this.id);
        if (null != this.facets) {
            out.writeInt(this.facets.size());
            for (Map.Entry<String, TreeStrutureNode> entry : this.facets.entrySet()) {
                out.writeUTF(entry.getKey());
                TreeStrutureNode node = entry.getValue();
                node.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
        if (null != this.children) {
            out.writeInt(this.children.size());
            for (TreeStrutureNode child : this.children) {
                child.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
    }
}

