/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GradientType {
    GLASS{

        public BiColor getFirstLayerColors(BiColor biColor) {
            Color bottomColor = biColor.getBottomColor();
            float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);
            hsb[2] = 0.2f * hsb[2] + 0.8f;
            hsb[1] = 0.5f * hsb[1];
            Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            return new BiColor(bottomColor, topColor);
        }

        public BiColor getSecondLayerColors(BiColor biColor) {
            return WHITE;
        }
    }
    ,
    PLASTIC{

        public BiColor getFirstLayerColors(BiColor biColor) {
            Color bottomColor = biColor.getBottomColor();
            float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);
            hsb[2] = 0.25f * hsb[2] + 0.75f;
            hsb[1] = 0.75f * hsb[1];
            Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            return new BiColor(topColor, bottomColor);
        }

        public BiColor getSecondLayerColors(BiColor biColor) {
            return WHITE;
        }
    }
    ,
    PLAIN{

        public BiColor getFirstLayerColors(BiColor biColor) {
            return biColor;
        }

        public BiColor getSecondLayerColors(BiColor biColor) {
            return null;
        }
    };

    private static final BiColor WHITE;

    public static final GradientType getBySkinParameter(String string) {
        if (string == null || string.length() == 0) {
            return PLAIN;
        }
        return GradientType.valueOf(string.toUpperCase());
    }

    public abstract BiColor getFirstLayerColors(BiColor var1);

    public abstract BiColor getSecondLayerColors(BiColor var1);

    static {
        WHITE = new BiColor(new Color(255, 255, 255, 165), new Color(255, 255, 255, 51));
    }

    public static class BiColor {
        private Color topColor;
        private Color bottomColor;

        public BiColor(Color topColor, Color bottomColor) {
            if (topColor == null || bottomColor == null) {
                throw new NullPointerException("Color is null!");
            }
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        public Color getTopColor() {
            return this.topColor;
        }

        public Color getBottomColor() {
            return this.bottomColor;
        }

        public String toString() {
            return "BiColor: [" + this.topColor + " -> " + this.bottomColor + "]";
        }
    }
}

