/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class BaseGradient
extends Java2Dresource {
    private int width;
    private int height;
    private int gradientHeight;
    private String baseColor;
    private String gradientColor;
    private boolean horizontal = false;

    public BaseGradient(int width, int height, int gradientHeight) {
        this.width = width;
        this.height = height;
        this.gradientHeight = gradientHeight;
        this.setRenderer(new PngRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
    }

    public BaseGradient(int width, int height, int gradientHeight, boolean horizontal) {
        this(width, height, gradientHeight);
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, gradientHeight);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, boolean horizontal) {
        this(width, height, horizontal ? width : height);
        this.horizontal = horizontal;
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, horizontal ? width : height);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public BaseGradient(boolean horizontal) {
        this(30, 50, 20);
        this.horizontal = horizontal;
    }

    public BaseGradient(String baseColor, String gradientColor, boolean horizontal) {
        this(30, 50, 20);
        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.horizontal = horizontal;
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return new Dimension(this.width, this.height);
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.getDimensions(null, this.restoreData(resourceContext));
    }

    private void drawGradient(Graphics2D g2d, Rectangle2D rectangle, GradientType.BiColor colors, int height, boolean horizontal) {
        if (colors != null) {
            GradientPaint gragient = horizontal ? new GradientPaint(0.0f, 0.0f, colors.getTopColor(), height, 0.0f, colors.getBottomColor()) : new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(rectangle);
        }
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Data dataToStore = (Data)this.restoreData(resourceContext);
        if (dataToStore != null && dataToStore.headerBackgroundColor != null && dataToStore.headerGradientColor != null) {
            Color baseColor = new Color(dataToStore.headerBackgroundColor);
            Color alternateColor = new Color(dataToStore.headerGradientColor);
            GradientType.BiColor biColor = new GradientType.BiColor(baseColor, alternateColor);
            GradientType type = dataToStore.gradientType;
            GradientType.BiColor firstLayer = type.getFirstLayerColors(biColor);
            GradientType.BiColor secondLayer = type.getSecondLayerColors(biColor);
            Dimension dim = this.getDimensions(resourceContext);
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            this.drawGradient(g2d, rect, firstLayer, this.gradientHeight, this.horizontal);
            this.drawGradient(g2d, rect, secondLayer, this.gradientHeight / 2, this.horizontal);
        }
    }

    protected void restoreData(Data data, Zipper2 zipper2) {
        if (zipper2.hasMore()) {
            data.headerBackgroundColor = new Integer(zipper2.nextIntColor());
            data.headerGradientColor = new Integer(zipper2.nextIntColor());
            data.gradientType = GradientType.values()[zipper2.nextByte()];
        }
    }

    protected Object deserializeData(byte[] objectArray) {
        Data data = this.createData();
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            this.restoreData(data, zipper2);
        }
        return data;
    }

    protected Data createData() {
        return new Data();
    }

    private void saveData(FacesContext context, Data data, String baseColor, String gradientColor) {
        data.headerBackgroundColor = this.getColorValueParameter(context, baseColor, false);
        data.headerGradientColor = this.getColorValueParameter(context, gradientColor, false);
        if (data.headerBackgroundColor != null || data.headerGradientColor != null) {
            if (data.headerBackgroundColor == null) {
                data.headerBackgroundColor = this.getColorValueParameter(context, baseColor, true);
            }
            if (data.headerGradientColor == null) {
                data.headerGradientColor = this.getColorValueParameter(context, gradientColor, true);
            }
        }
        data.gradientType = GradientType.getBySkinParameter(this.getValueParameter(context, "gradientType"));
    }

    protected void saveData(FacesContext context, Data data) {
        if (this.baseColor == null) {
            this.saveData(context, data, "headerBackgroundColor", "headerGradientColor");
        } else {
            this.saveData(context, data, this.baseColor, this.gradientColor);
        }
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Data dataObject = this.createData();
        this.saveData(context, dataObject);
        return dataObject.toByteArray();
    }

    public boolean isCacheable() {
        return true;
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
        String tmp = (String)skin.getParameter(context, name);
        if (tmp != null && tmp.length() != 0) {
            return new Integer(HtmlColor.decode(tmp).getRGB());
        }
        return null;
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = 1732700513743861250L;
        protected Integer headerBackgroundColor;
        protected Integer headerGradientColor;
        protected GradientType gradientType;

        public byte[] toByteArray() {
            if (this.headerBackgroundColor != null && this.headerGradientColor != null && this.gradientType != null) {
                byte[] ret = new byte[7];
                new Zipper2(ret).addColor(this.headerBackgroundColor).addColor(this.headerGradientColor).addByte((byte)this.gradientType.ordinal());
                return ret;
            }
            return null;
        }
    }
}

