/**
 * 
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;

/**
 * @author Nick Belaevski
 *         mailto:nbelaevski@exadel.com
 *         created 16.04.2008
 *
 */
public enum GradientType {

    GLASS {

	@Override
	public BiColor getFirstLayerColors(BiColor biColor) {
//	    Color topColor = biColor.getTopColor();
//	    
//	    float[] hsb = Color.RGBtoHSB(topColor.getRed(), topColor.getGreen(), topColor.getBlue(), null);
//
//	    hsb[2] = 0.2f * hsb[2] + 80; //(hsb[2] * 2) / 10 + 80;
//	    hsb[1] = 0.5f * hsb[1];
//
//	    Color bottomColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
//	    
//	    return new BiColor(topColor, bottomColor);

	    Color bottomColor = biColor.getBottomColor();
	    
	    float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);

	    hsb[2] = 0.2f * hsb[2] + 0.80f; //(hsb[2] * 2) / 10 + 80;
	    hsb[1] = 0.5f * hsb[1];

	    Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
	    
	    return new BiColor(bottomColor, topColor);
	}

	@Override
	public BiColor getSecondLayerColors(BiColor biColor) {
	    return WHITE;
	}
	
    },
    
    PLASTIC {

	@Override
	public BiColor getFirstLayerColors(BiColor biColor) {
	    Color bottomColor = biColor.getBottomColor();

	    float[] hsb = Color.RGBtoHSB(bottomColor.getRed(), bottomColor.getGreen(), bottomColor.getBlue(), null);

	    hsb[2] = 0.25f * hsb[2] + 0.75f; //(100 - hsb[2]) * 0.75f + hsb[2];
	    hsb[1] = 0.75f * hsb[1];

	    Color topColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
	    
	    return new BiColor(topColor, bottomColor);
	}

	@Override
	public BiColor getSecondLayerColors(BiColor biColor) {
	    return WHITE;
	}
	
    },
    
    PLAIN {

	@Override
	public BiColor getFirstLayerColors(BiColor biColor) {
	    return biColor;
	}

	@Override
	public BiColor getSecondLayerColors(BiColor biColor) {
	    return null;
	}
	
    };
    
    public static final GradientType getBySkinParameter(String string) {
	if (string == null || string.length() == 0) {
	    return PLAIN;
	}
	
	return GradientType.valueOf(string.toUpperCase());
    }
    
    public abstract BiColor getFirstLayerColors(BiColor biColor);
    public abstract BiColor getSecondLayerColors(BiColor biColor);
    
    private static final BiColor WHITE = new BiColor(new Color(0xff, 0xff, 0xff, (int) (0.65f * 0xff)),
	    new Color(0xff, 0xff, 0xff, (int) (0.20f * 0xff)));
	
    public static class BiColor {
	private Color topColor;
	private Color bottomColor;

	public BiColor(Color topColor, Color bottomColor) {
	    super();

	    if (topColor == null || bottomColor == null) {
		throw new NullPointerException("Color is null!");
	    }

	    this.topColor = topColor;
	    this.bottomColor = bottomColor;
	}

	public Color getTopColor() {
	    return topColor;
	}

	public Color getBottomColor() {
	    return bottomColor;
	}

	@Override
	public String toString() {
	    return "BiColor: [" + topColor + " -> " + bottomColor + "]";
	}
    };
    
}
