/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.HtmlDimensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererUtils {
    private static final RendererUtils instance = new RendererUtils();
    public static final String DUMMY_FORM_ID = ":_form";
    private static Map<String, String> substitutions = new HashMap<String, String>();

    protected RendererUtils() {
    }

    public static RendererUtils getInstance() {
        return instance;
    }

    public void encodeId(FacesContext context, UIComponent component) throws IOException {
        this.encodeId(context, component, "id");
    }

    public void encodeId(FacesContext context, UIComponent component, String attribute) throws IOException {
        String clientId = null;
        try {
            clientId = component.getClientId(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null != clientId) {
            context.getResponseWriter().writeAttribute(attribute, (Object)clientId, (String)this.getComponentAttributeName(attribute));
        }
    }

    public void encodeCustomId(FacesContext context, UIComponent component) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("j_id")) {
            context.getResponseWriter().writeAttribute("id", (Object)component.getClientId(context), "id");
        }
    }

    public void encodePassThru(FacesContext context, UIComponent component) throws IOException {
        this.encodeAttributesFromArray(context, component, HTML.PASS_THRU);
    }

    public void encodePassThruWithExclusions(FacesContext context, UIComponent component, String exclusions) throws IOException {
        if (null != exclusions) {
            Object[] exclusionsArray = exclusions.split(",");
            this.encodePassThruWithExclusionsArray(context, component, exclusionsArray);
        }
    }

    public void encodePassThruWithExclusionsArray(FacesContext context, UIComponent component, Object[] exclusions) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = component.getAttributes();
        Arrays.sort(exclusions);
        for (int i = 0; i < HTML.PASS_THRU.length; ++i) {
            String attribute = HTML.PASS_THRU[i];
            if (Arrays.binarySearch(exclusions, attribute) >= 0) continue;
            this.encodePassThruAttribute(context, attributes, writer, attribute);
        }
    }

    public void encodePassThruAttribute(FacesContext context, Map<String, Object> attributes, ResponseWriter writer, String attribute) throws IOException {
        Object value = this.attributeValue(attribute, attributes.get(this.getComponentAttributeName(attribute)));
        if (null != value && this.shouldRenderAttribute(value)) {
            if (Arrays.binarySearch(HTML.PASS_THRU_URI, attribute) >= 0) {
                String url = context.getApplication().getViewHandler().getResourceURL(context, value.toString());
                url = context.getExternalContext().encodeResourceURL(url);
                writer.writeURIAttribute(attribute, (Object)url, attribute);
            } else {
                writer.writeAttribute(attribute, value, attribute);
            }
        }
    }

    public void encodeAttributesFromArray(FacesContext context, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = component.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            String attribute = attrs[i];
            this.encodePassThruAttribute(context, attributes, writer, attribute);
        }
    }

    public void encodeAttributes(FacesContext context, UIComponent component, String attrs) throws IOException {
        if (null != attrs) {
            String[] attrsArray = attrs.split(",");
            this.encodeAttributesFromArray(context, component, attrsArray);
        }
    }

    public void encodeAttribute(FacesContext context, UIComponent component, Object property, String attributeName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = component.getAttributes().get(property);
        if (this.shouldRenderAttribute(value)) {
            writer.writeAttribute(attributeName, value, property.toString());
        }
    }

    public void encodeAttribute(FacesContext context, UIComponent component, String attribute) throws IOException {
        this.encodeAttribute(context, component, this.getComponentAttributeName(attribute), attribute);
    }

    public void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (this.shouldRenderAttribute(value)) {
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }

    public boolean shouldRenderAttribute(Object attributeVal) {
        if (null == attributeVal) {
            return false;
        }
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal.toString().length() == 0) {
            return false;
        }
        return this.isValidProperty(attributeVal);
    }

    public boolean isValidProperty(Object property) {
        if (null == property) {
            return false;
        }
        if (property instanceof Integer && (Integer)property == Integer.MIN_VALUE) {
            return false;
        }
        if (property instanceof Double && (Double)property == Double.MIN_VALUE) {
            return false;
        }
        if (property instanceof Character && ((Character)property).charValue() == '\u0000') {
            return false;
        }
        if (property instanceof Float && ((Float)property).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (property instanceof Short && (Short)property == Short.MIN_VALUE) {
            return false;
        }
        if (property instanceof Byte && (Byte)property == -128) {
            return false;
        }
        return !(property instanceof Long) || (Long)property != Long.MIN_VALUE;
    }

    protected Object getComponentAttributeName(Object key) {
        String converted = substitutions.get(key);
        if (null == converted) {
            return key;
        }
        return converted;
    }

    protected Object attributeValue(String name, Object value) {
        if (null != value && Arrays.binarySearch(HTML.PASS_THRU_BOOLEAN, name) >= 0) {
            boolean checked = false;
            if (value instanceof Boolean) {
                checked = (Boolean)value;
            } else {
                if (!(value instanceof String)) {
                    value = value.toString();
                }
                checked = new Boolean((String)value);
            }
            return checked ? name : null;
        }
        return value;
    }

    public boolean isBooleanAttribute(UIComponent component, String name) {
        Object attrValue = component.getAttributes().get(name);
        boolean result = false;
        if (null != attrValue) {
            result = attrValue instanceof String ? "true".equalsIgnoreCase((String)attrValue) : Boolean.TRUE.equals(attrValue);
        }
        return result;
    }

    public String getValueAsString(FacesContext context, UIComponent component) {
        EditableValueHolder input;
        String submittedValue;
        if (component instanceof EditableValueHolder && null != (submittedValue = (String)(input = (EditableValueHolder)component).getSubmittedValue())) {
            return submittedValue;
        }
        if (component instanceof ValueHolder) {
            return this.formatValue(context, component, ((ValueHolder)component).getValue());
        }
        throw new IllegalArgumentException(Messages.getMessage((String)"CONVERTING_NON_VALUE_HOLDER_COMPONENT_ERROR", (Object)component.getId()));
    }

    public String formatValue(FacesContext context, UIComponent component, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        Converter converter = null;
        if (component instanceof ValueHolder) {
            ValueHolder holder = (ValueHolder)component;
            converter = holder.getConverter();
        }
        if (null == converter && null != value) {
            try {
                converter = context.getApplication().createConverter(value.getClass());
            }
            catch (FacesException e) {
                // empty catch block
            }
        }
        if (null == converter) {
            if (null != value) {
                return value.toString();
            }
        } else {
            return converter.getAsString(context, component, value);
        }
        return "";
    }

    public void encodeDimensions(FacesContext context, UIComponent component, InternetResource resource) throws IOException {
        if (resource instanceof Java2Dresource) {
            Java2Dresource j2d = (Java2Dresource)resource;
            Dimension dim = j2d.getDimensions(context, component);
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("width", (Object)String.valueOf(dim.width), "width");
            writer.writeAttribute("height", (Object)String.valueOf(dim.height), "height");
        }
    }

    public String encodePx(String value) {
        return HtmlDimensions.formatPx(HtmlDimensions.decode(value));
    }

    public String encodePctOrPx(String value) {
        if (value.indexOf(37) > 0) {
            return value;
        }
        return this.encodePx(value);
    }

    public UIForm getNestingForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm nestingForm = null;
        if (parent != null) {
            nestingForm = (UIForm)parent;
        }
        return nestingForm;
    }

    public void encodeBeginFormIfNessesary(FacesContext context, UIComponent component) throws IOException {
        UIForm form = this.getNestingForm(context, component);
        if (null == form) {
            ResponseWriter writer = context.getResponseWriter();
            String clientId = component.getClientId(context) + DUMMY_FORM_ID;
            this.encodeBeginForm(context, component, writer, clientId);
        }
    }

    public void encodeBeginForm(FacesContext context, UIComponent component, ResponseWriter writer, String clientId) throws IOException {
        String actionURL = this.getActionUrl(context);
        String encodeActionURL = context.getExternalContext().encodeActionURL(actionURL);
        writer.startElement("form", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeAttribute("style", (Object)"margin:0; padding:0; display: inline;", null);
        writer.writeURIAttribute("action", (Object)encodeActionURL, "action");
    }

    public void encodeEndFormIfNessesary(FacesContext context, UIComponent component) throws IOException {
        UIForm form = this.getNestingForm(context, component);
        if (null == form) {
            ResponseWriter writer = context.getResponseWriter();
            this.encodeEndForm(context, writer);
        }
    }

    public void encodeEndForm(FacesContext context, ResponseWriter writer) throws IOException {
        AjaxRendererUtils.writeState(context);
        writer.endElement("form");
    }

    public String getActionUrl(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        return viewHandler.getActionURL(facesContext, viewId);
    }

    public String encodeResourceURL(TemplateContext context, Object value) {
        if (value == null) {
            return "";
        }
        FacesContext facesContext = context.getFacesContext();
        value = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, value.toString());
        return facesContext.getExternalContext().encodeResourceURL((String)value);
    }

    public String clientId(FacesContext context, UIComponent component) {
        String clientId = "";
        try {
            clientId = component.getClientId(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        return clientId;
    }

    public void writeScript(FacesContext context, UIComponent component, Object script) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeText(script, null);
        writer.endElement("script");
    }

    public UIComponent findComponentFor(FacesContext context, UIComponent component, String id) {
        return this.findComponentFor(component, id);
    }

    public UIComponent findComponentFor(UIComponent component, String id) {
        UIComponent target = null;
        UIComponent root = component;
        for (UIComponent parent = component; null == target && null != parent; parent = parent.getParent()) {
            target = parent.findComponent(id);
            root = parent;
        }
        if (null == target) {
            target = this.findUIComponentBelow(root, id);
        }
        return target;
    }

    public String correctForIdReference(String forAttr, UIComponent component) {
        String id;
        int pos;
        int contains = forAttr.indexOf("j_id");
        if (contains <= 0 && (pos = (id = component.getId()).indexOf("j_id")) > 0) {
            forAttr = forAttr.concat(id.substring(pos));
        }
        return forAttr;
    }

    private UIComponent findUIComponentBelow(UIComponent root, String id) {
        UIComponent target = null;
        Iterator iter = root.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (child instanceof NamingContainer) {
                try {
                    target = child.findComponent(id);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
            }
            if (target == null && child.getChildCount() > 0) {
                target = this.findUIComponentBelow(child, id);
            }
            if (target == null) continue;
            break;
        }
        return target;
    }

    public static void writeEventHandlerFunction(FacesContext context, UIComponent component, String eventName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object script = component.getAttributes().get(eventName);
        if (script != null && !script.equals("")) {
            JSFunctionDefinition onEventDefinition = new JSFunctionDefinition(new Object[0]);
            onEventDefinition.addParameter((Object)"event");
            onEventDefinition.addToBody(script);
            writer.writeText((Object)(eventName + ": " + onEventDefinition.toScript()), null);
        } else {
            writer.writeText((Object)(eventName + ": ''"), null);
        }
    }

    public JSFunctionDefinition getAsEventHandler(FacesContext context, UIComponent component, String attributeName, String append) {
        String event = (String)component.getAttributes().get(attributeName);
        if (event != null && (event = event.trim()).length() != 0) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[0]);
            function.addParameter((Object)"event");
            if (null != append && append.length() > 0) {
                function.addToBody((Object)(event + append));
            } else {
                function.addToBody((Object)event);
            }
            return function;
        }
        return null;
    }

    static {
        substitutions.put("class", "styleClass");
        Arrays.sort(HTML.PASS_THRU);
        Arrays.sort(HTML.PASS_THRU_BOOLEAN);
        Arrays.sort(HTML.PASS_THRU_URI);
    }

    public static interface HTML {
        public static final String BUTTON = "button";
        public static final String id_ATTRIBUTE = "id";
        public static final String class_ATTRIBUTE = "class";
        public static final String accesskey_ATTRIBUTE = "accesskey";
        public static final String alt_ATTRIBUTE = "alt";
        public static final String cols_ATTRIBUTE = "cols";
        public static final String height_ATTRIBUTE = "height";
        public static final String lang_ATTRIBUTE = "lang";
        public static final String longdesc_ATTRIBUTE = "longdesc";
        public static final String maxlength_ATTRIBUTE = "maxlength";
        public static final String onblur_ATTRIBUTE = "onblur";
        public static final String onchange_ATTRIBUTE = "onchange";
        public static final String onclick_ATTRIBUTE = "onclick";
        public static final String ondblclick_ATTRIBUTE = "ondblclick";
        public static final String onfocus_ATTRIBUTE = "onfocus";
        public static final String onkeydown_ATTRIBUTE = "onkeydown";
        public static final String onkeypress_ATTRIBUTE = "onkeypress";
        public static final String onkeyup_ATTRIBUTE = "onkeyup";
        public static final String onload_ATTRIBUTE = "onload";
        public static final String onmousedown_ATTRIBUTE = "onmousedown";
        public static final String onmousemove_ATTRIBUTE = "onmousemove";
        public static final String onmouseout_ATTRIBUTE = "onmouseout";
        public static final String onmouseover_ATTRIBUTE = "onmouseover";
        public static final String onmouseup_ATTRIBUTE = "onmouseup";
        public static final String onreset_ATTRIBUTE = "onreset";
        public static final String onselect_ATTRIBUTE = "onselect";
        public static final String onunload_ATTRIBUTE = "onunload";
        public static final String rows_ATTRIBUTE = "rows";
        public static final String size_ATTRIBUTE = "size";
        public static final String tabindex_ATTRIBUTE = "tabindex";
        public static final String title_ATTRIBUTE = "title";
        public static final String style_ATTRIBUTE = "style";
        public static final String align_ATTRIBUTE = "align";
        public static final String width_ATTRIBUTE = "width";
        public static final String dir_ATTRIBUTE = "dir";
        public static final String rules_ATTRIBUTE = "rules";
        public static final String frame_ATTRIBUTE = "frame";
        public static final String border_ATTRIBUTE = "border";
        public static final String cellspacing_ATTRIBUTE = "cellspacing";
        public static final String cellpadding_ATTRIBUTE = "cellpadding";
        public static final String summary_ATTRIBUTE = "summary";
        public static final String bgcolor_ATTRIBUTE = "bgcolor";
        public static final String usemap_ATTRIBUTE = "usemap";
        public static final String enctype_ATTRIBUTE = "enctype";
        public static final String accept_charset_ATTRIBUTE = "accept-charset";
        public static final String accept_ATTRIBUTE = "accept";
        public static final String target_ATTRIBUTE = "target";
        public static final String onsubmit_ATTRIBUTE = "onsubmit";
        public static final String readonly_ATTRIBUTE = "readonly";
        public static final String nowrap_ATTRIBUTE = "nowrap";
        public static final String src_ATTRIBUTE = "src";
        public static final String[] PASS_THRU = new String[]{"accesskey", "alt", "cols", "height", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rows", "size", "tabindex", "title", "width", "dir", "rules", "frame", "border", "cellspacing", "cellpadding", "summary", "bgcolor", "usemap", "enctype", "accept-charset", "accept", "target", "charset", "coords", "hreflang", "rel", "rev", "shape", "disabled", "readonly", "ismap", "align"};
        public static final String[] PASS_THRU_BOOLEAN = new String[]{"disabled", "declare", "readonly", "compact", "ismap", "selected", "checked", "nowrap", "noresize", "nohref", "noshade", "multiple"};
        public static final String[] PASS_THRU_URI = new String[]{"usemap", "background", "codebase", "cite", "data", "classid", "href", "longdesc", "profile", "src"};
        public static final String[] PASS_THRU_STYLES = new String[]{"style", "class"};
        public static final String SPAN_ELEM = "span";
        public static final String DIV_ELEM = "div";
        public static final String SCRIPT_ELEM = "script";
        public static final String LINK_ELEMENT = "link";
        public static final String STYLE_CLASS_ATTR = "styleClass";
        public static final String DISABLED_ATTR = "disabled";
        public static final String TYPE_ATTR = "type";
        public static final String CHARSET_ATTR = "charset";
        public static final String COORDS_ATTR = "coords";
        public static final String HREFLANG_ATTR = "hreflang";
        public static final String HREF_ATTR = "href";
        public static final String REL_ATTR = "rel";
        public static final String REV_ATTR = "rev";
        public static final String SHAPE_ATTR = "shape";
        public static final String title_ELEM = "title";
        public static final String FORM_ELEMENT = "form";
        public static final String NAME_ATTRIBUTE = "name";
        public static final String METHOD_ATTRIBUTE = "method";
        public static final String ACTION_ATTRIBUTE = "action";
        public static final String INPUT_ELEM = "input";
        public static final Object INPUT_TYPE_HIDDEN = "hidden";
        public static final String value_ATTRIBUTE = "value";
        public static final String td_ELEM = "td";
        public static final String th_ELEM = "th";
        public static final String valign_ATTRIBUTE = "valign";
        public static final String a_ELEMENT = "a";
        public static final String HTML_ELEMENT = "html";
        public static final String HEAD_ELEMENT = "head";
        public static final String BODY_ELEMENT = "body";
        public static final String TABLE_ELEMENT = "table";
        public static final String TR_ELEMENT = "tr";
        public static final String CAPTION_ELEMENT = "caption";
        public static final String TBOBY_ELEMENT = "tbody";
        public static final String THEAD_ELEMENT = "thead";
        public static final String TFOOT_ELEMENT = "tfoot";
        public static final String IMG_ELEMENT = "img";
        public static final String DT_ELEMENT = "dt";
        public static final String DL_ELEMENT = "dl";
    }
}

