/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.ajax4jsf.application.AjaxStateHolder;
import org.ajax4jsf.application.ComponentsLoader;
import org.ajax4jsf.application.ComponentsLoaderImpl;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.application.TreeStrutureNode;
import org.ajax4jsf.context.AjaxContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxStateManager
extends StateManager {
    private static final Class<StateManager> STATE_MANAGER_ARGUMENTS = StateManager.class;
    public static final int DEFAULT_NUMBER_OF_VIEWS = 16;
    public static final String VIEW_SEQUENCE = AjaxStateManager.class.getName() + ".VIEW_SEQUENCE";
    private final StateManager parent;
    private StateManager seamStateManager;
    private final ComponentsLoader componentLoader;
    private volatile int viewSequence;
    private Object viewSequenceMutex;
    private static final Log _log = LogFactory.getLog(AjaxStateManager.class);

    public AjaxStateManager(StateManager parent) {
        block4: {
            this.viewSequence = 0;
            this.viewSequenceMutex = "MUTEX";
            this.parent = parent;
            this.componentLoader = new ComponentsLoaderImpl();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = AjaxStateManager.class.getClassLoader();
            }
            try {
                Class<StateManager> seamStateManagerClass = classLoader.loadClass("org.jboss.seam.jsf.SeamStateManager").asSubclass(StateManager.class);
                Constructor<StateManager> constructor = seamStateManagerClass.getConstructor(STATE_MANAGER_ARGUMENTS);
                this.seamStateManager = constructor.newInstance(new Object[]{new SeamStateManagerWrapper()});
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Create instance of the SeamStateManager");
                }
            }
            catch (Exception e) {
                this.seamStateManager = null;
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"SeamStateManager is not present");
            }
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        Object treeState = context.getViewRoot().processSaveState(context);
        Object[] state = new Object[]{treeState, this.getAdditionalState(context)};
        return state;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStrutureNode treeStructure = new TreeStrutureNode();
        treeStructure.apply(context, (UIComponent)context.getViewRoot(), new HashSet<String>());
        return treeStructure;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        this.parent.writeState(context, state);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Write view state to the response");
        }
        context.getExternalContext().getRequestMap().put("org.ajax4jsf.VIEW_STATE_SAVED", Boolean.TRUE);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot = null;
        ResponseStateManager responseStateManager = this.getRenderKit(context, renderKitId).getResponseStateManager();
        TreeStrutureNode treeStructure = null;
        Object[] state = null;
        if (this.isSavingStateInClient(context)) {
            treeStructure = (TreeStrutureNode)responseStateManager.getTreeStructureToRestore(context, viewId);
            state = (Object[])responseStateManager.getComponentStateToRestore(context);
        } else {
            Object[] serializedView = this.restoreStateFromSession(context, viewId, renderKitId);
            if (null != serializedView) {
                treeStructure = (TreeStrutureNode)serializedView[0];
                state = (Object[])serializedView[1];
            }
        }
        if (null != treeStructure && null != (viewRoot = (UIViewRoot)treeStructure.restore(this.componentLoader)) && null != state) {
            viewRoot.processRestoreState(context, state[0]);
            this.restoreAdditionalState(context, state[1]);
        }
        return viewRoot;
    }

    protected Object[] restoreStateFromSession(FacesContext context, String viewId, String renderKitId) {
        Object id = this.restoreLogicalViewId(context, viewId, renderKitId);
        StateHolder stateHolder = this.getStateHolder(context);
        Object[] restoredState = (Object[])stateHolder.getState(viewId, id);
        return restoredState;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        if (null == this.seamStateManager) {
            return this.buildSerializedView(context);
        }
        return this.seamStateManager.saveSerializedView(context);
    }

    protected StateManager.SerializedView buildSerializedView(FacesContext context) {
        StateManager.SerializedView serializedView = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot && !viewRoot.isTransient()) {
            TreeStrutureNode treeStructure = (TreeStrutureNode)this.getTreeStructureToSave(context);
            Object state = this.getComponentStateToSave(context);
            serializedView = this.isSavingStateInClient(context) ? new StateManager.SerializedView((StateManager)this, (Object)treeStructure, state) : this.saveStateInSession(context, treeStructure, state);
        }
        return serializedView;
    }

    protected StateManager.SerializedView saveStateInSession(FacesContext context, Object treeStructure, Object state) {
        UIViewRoot viewRoot = context.getViewRoot();
        StateHolder stateHolder = this.getStateHolder(context);
        Object id = this.getLogicalViewId(context);
        stateHolder.saveState(viewRoot.getViewId(), id, (Object)new Object[]{treeStructure, state});
        StateManager.SerializedView serializedView = new StateManager.SerializedView((StateManager)this, id, null);
        return serializedView;
    }

    protected StateHolder getStateHolder(FacesContext context) {
        return AjaxStateHolder.getInstance(context);
    }

    protected Object getAdditionalState(FacesContext context) {
        return null;
    }

    protected void restoreAdditionalState(FacesContext context, Object state) {
    }

    protected Object restoreLogicalViewId(FacesContext context, String viewId, String renderKitId) {
        Object id = this.getRenderKit(context, renderKitId).getResponseStateManager().getTreeStructureToRestore(context, viewId);
        if (null != id) {
            context.getExternalContext().getRequestMap().put(VIEW_SEQUENCE, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getLogicalViewId(FacesContext context) {
        Object id;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        if (ajaxContext.isAjaxRequest() && null != (id = context.getExternalContext().getRequestMap().get(VIEW_SEQUENCE))) {
            return id;
        }
        Object object = this.viewSequenceMutex;
        synchronized (object) {
            if (this.viewSequence++ == 65535) {
                this.viewSequence = 0;
            }
        }
        return "j_id" + this.viewSequence;
    }

    protected RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKit renderKit = context.getRenderKit();
        if (null == renderKit) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            renderKit = factory.getRenderKit(context, renderKitId);
        }
        return renderKit;
    }

    private final class SeamStateManagerWrapper
    extends StateManager {
        private SeamStateManagerWrapper() {
        }

        protected Object getComponentStateToSave(FacesContext arg0) {
            return null;
        }

        protected Object getTreeStructureToSave(FacesContext arg0) {
            return null;
        }

        protected void restoreComponentState(FacesContext arg0, UIViewRoot arg1, String arg2) {
        }

        protected UIViewRoot restoreTreeStructure(FacesContext arg0, String arg1, String arg2) {
            return null;
        }

        public UIViewRoot restoreView(FacesContext arg0, String arg1, String arg2) {
            return null;
        }

        public StateManager.SerializedView saveSerializedView(FacesContext arg0) {
            return AjaxStateManager.this.buildSerializedView(arg0);
        }

        public void writeState(FacesContext arg0, StateManager.SerializedView arg1) throws IOException {
        }
    }
}

