/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.Messages;
import org.ajax4jsf.webapp.FilterBean;
import org.ajax4jsf.webapp.ServletBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXml
implements Serializable {
    public static final String CONTEXT_ATTRIBUTE = WebXml.class.getName();
    private static final long serialVersionUID = -9042908418843695017L;
    private static final Log _log = LogFactory.getLog(WebXml.class);
    static final String WEB_XML = "/WEB-INF/web.xml";
    public static final String RESOURCE_URI_PREFIX = "a4j_3_2_0.CR7";
    static final String RESOURCE_URI_PREFIX_WITH_SLASH = "/a4j_3_2_0.CR7";
    public static final String RESOURCE_URI_PREFIX_PARAM = "org.ajax4jsf.RESOURCE_URI_PREFIX";
    private String _facesFilterPrefix = null;
    private String _facesFilterSuffix = null;
    private String _facesServletPrefix = null;
    private String _facesServletSuffix = null;
    private boolean _prefixMapping = false;
    private String _filterName;
    private Map<String, ServletBean> _servlets = new HashMap<String, ServletBean>();
    private Map<String, FilterBean> _filters = new HashMap<String, FilterBean>();
    private String _resourcePrefix = "/a4j_3_2_0.CR7";

    public static WebXml getInstance() {
        return WebXml.getInstance(FacesContext.getCurrentInstance());
    }

    public static WebXml getInstance(FacesContext context) {
        WebXml webXml = (WebXml)context.getExternalContext().getApplicationMap().get(CONTEXT_ATTRIBUTE);
        return webXml;
    }

    public void init(ServletContext context, String filterName) throws ServletException {
        InputStream webXml = context.getResourceAsStream(WEB_XML);
        if (null == webXml) {
            throw new ServletException(Messages.getMessage((String)"GET_RESOURCE_AS_STREAM_ERROR", (Object)WEB_XML));
        }
        Digester dig = new Digester();
        dig.setDocumentLocator((Locator)new LocatorImpl());
        dig.setValidating(false);
        dig.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        dig.setNamespaceAware(false);
        dig.setClassLoader(this.getClass().getClassLoader());
        String path = "web-app/servlet";
        dig.addObjectCreate(path, ServletBean.class);
        dig.addBeanPropertySetter(path + "/servlet-name", "servletName");
        dig.addBeanPropertySetter(path + "/servlet-class", "servletClass");
        dig.addBeanPropertySetter(path + "/display-name", "displayName");
        dig.addBeanPropertySetter(path + "/description");
        dig.addSetNext(path, "addServlet");
        path = "web-app/filter";
        dig.addObjectCreate(path, FilterBean.class);
        dig.addBeanPropertySetter(path + "/filter-name", "filterName");
        dig.addBeanPropertySetter(path + "/filter-class", "filterClass");
        dig.addBeanPropertySetter(path + "/display-name", "displayName");
        dig.addBeanPropertySetter(path + "/description");
        dig.addSetNext(path, "addFilter");
        path = "web-app/servlet-mapping";
        dig.addCallMethod(path, "addServletMapping", 2);
        dig.addCallParam(path + "/servlet-name", 0);
        dig.addCallParam(path + "/url-pattern", 1);
        path = "web-app/filter-mapping";
        dig.addCallMethod(path, "addFilterMapping", 3);
        dig.addCallParam(path + "/filter-name", 0);
        dig.addCallParam(path + "/url-pattern", 1);
        dig.addCallParam(path + "/servlet-name", 2);
        dig.push((Object)this);
        try {
            dig.parse(webXml);
            this.setFilterName(filterName, context);
            this.findFacesServlet(context);
            context.setAttribute(CONTEXT_ATTRIBUTE, (Object)this);
        }
        catch (IOException e) {
            String message = Messages.getMessage((String)"PARSING_WEB_XML_IO_ERROR");
            _log.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = Messages.getMessage((String)"PARSING_WEB_XML_SAX_ERROR");
            _log.error((Object)message, (Throwable)e);
            throw new ServletException(message, (Throwable)e);
        }
        finally {
            try {
                webXml.close();
            }
            catch (IOException e) {}
        }
    }

    private void findFacesServlet(ServletContext context) {
        for (Map.Entry<String, ServletBean> servletEntry : this._servlets.entrySet()) {
            Mapping mapping;
            String servletClass = servletEntry.getValue().getServletClass();
            if (!"javax.faces.webapp.FacesServlet".equals(servletClass) || null == (mapping = this.checkMapping(servletEntry.getValue().getMappings()))) continue;
            this._facesServletPrefix = mapping.getPrefix();
            this._facesServletSuffix = mapping.getSuffix();
        }
    }

    public void addServlet(ServletBean bean) {
        String name = bean.getServletName();
        if (null != name) {
            this._servlets.put(name, bean);
        }
    }

    public void addFilter(FilterBean bean) {
        String name = bean.getFilterName();
        if (null != name) {
            this._filters.put(name, bean);
        }
    }

    public void addServletMapping(String servletName, String mapping) {
        ServletBean servletBean = this._servlets.get(servletName);
        if (null != servletBean) {
            servletBean.addMapping(mapping);
        }
    }

    public void addFilterMapping(String filterName, String mapping, String servlet) {
        FilterBean filterBean = this._filters.get(filterName);
        if (null != filterBean) {
            if (null != mapping) {
                filterBean.addMapping(mapping);
            }
            if (null != servlet) {
                filterBean.addServlet(servlet);
            }
        }
    }

    public String getFacesResourceURL(FacesContext context, String Url) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getResourcePrefix()).append(Url);
        if (this.isPrefixMapping()) {
            buf.insert(0, this.getFacesFilterPrefix());
        } else {
            int index = buf.indexOf("?");
            if (index >= 0) {
                buf.insert(index, this.getFacesFilterSuffix());
            } else {
                buf.append(this.getFacesFilterSuffix());
            }
        }
        String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, buf.toString());
        return resourceURL;
    }

    public String getFacesResourceKey(HttpServletRequest request) {
        String resourcePath = request.getRequestURI().substring(request.getContextPath().length());
        int jsesionidStart = resourcePath.lastIndexOf(";jsessionid");
        if (jsesionidStart >= 0) {
            resourcePath = resourcePath.substring(0, jsesionidStart);
        }
        if (this.isPrefixMapping()) {
            if (resourcePath.startsWith(this.getFacesFilterPrefix() + this.getResourcePrefix())) {
                return resourcePath.substring(this.getFacesFilterPrefix().length() + this.getResourcePrefix().length());
            }
        } else if (resourcePath.startsWith(this.getResourcePrefix())) {
            return resourcePath.substring(this.getResourcePrefix().length(), resourcePath.length() - this.getFacesFilterSuffix().length());
        }
        return null;
    }

    public boolean isFacesRequest(HttpServletRequest request) {
        return true;
    }

    public String getFacesFilterPrefix() {
        return this._facesFilterPrefix;
    }

    void setFacesFilterPrefix(String facesFilterPrefix) {
        this._facesFilterPrefix = facesFilterPrefix;
    }

    public String getFacesFilterSuffix() {
        return this._facesFilterSuffix;
    }

    void setFacesFilterSuffix(String facesFilterSuffix) {
        this._facesFilterSuffix = facesFilterSuffix;
    }

    public String getResourcePrefix() {
        return this._resourcePrefix;
    }

    void setResourcePrefix(String resourcePrefix) {
        this._resourcePrefix = resourcePrefix;
    }

    public String getFilterName() {
        return this._filterName;
    }

    void setFilterName(String filterName, ServletContext context) {
        if (null == filterName) {
            _log.warn((Object)Messages.getMessage((String)"NULL_FILTER_NAME_WARNING"));
            return;
        }
        this._filterName = filterName.trim();
        FilterBean filter = this._filters.get(this._filterName);
        if (null == filter) {
            _log.warn((Object)Messages.getMessage((String)"FILTER_NOT_FOUND_ERROR", (Object)this._filterName));
            throw new IllegalStateException(Messages.getMessage((String)"FILTER_NOT_FOUND_ERROR", (Object)filterName));
        }
        Mapping mapping = this.checkMapping(filter.getMappings());
        if (null == mapping) {
            Iterator<String> sevlets = filter.getServlets().iterator();
            while (sevlets.hasNext() && this._facesFilterPrefix == null && this._facesFilterSuffix == null) {
                String servletname = sevlets.next();
                ServletBean servlet = this._servlets.get(servletname);
                if (null == servlet) continue;
                mapping = this.checkMapping(servlet.getMappings());
            }
        }
        if (null == mapping) {
            throw new IllegalStateException(Messages.getMessage((String)"NO_PREFIX_OR_SUFFIX_IN_FILTER_MAPPING_ERROR", (Object)filterName));
        }
        this.setFacesFilterPrefix(mapping.getPrefix());
        this.setFacesFilterSuffix(mapping.getSuffix());
        String resourcePrefix = context.getInitParameter(RESOURCE_URI_PREFIX_PARAM);
        if (null == resourcePrefix) {
            resourcePrefix = RESOURCE_URI_PREFIX;
        }
        if (null != this._facesFilterPrefix) {
            this._prefixMapping = true;
            if (this._facesFilterPrefix.endsWith("/")) {
                this.setResourcePrefix(resourcePrefix);
            } else {
                this.setResourcePrefix("/" + resourcePrefix);
            }
        } else if (null != this._facesFilterSuffix) {
            this._prefixMapping = false;
            this.setResourcePrefix("/" + resourcePrefix);
        }
    }

    private Mapping checkMapping(Set<String> mappings) {
        Mapping mapping = null;
        if (null != mappings) {
            for (String mappingPattern : mappings) {
                if (mappingPattern.endsWith("*")) {
                    if (null == mapping) {
                        mapping = new Mapping();
                    }
                    int cut = mappingPattern.endsWith("/*") ? 2 : 1;
                    mapping.setPrefix(mappingPattern.substring(0, mappingPattern.length() - cut));
                    break;
                }
                if (!mappingPattern.startsWith("*")) continue;
                if (null == mapping) {
                    mapping = new Mapping();
                }
                mapping.setSuffix(mappingPattern.substring(1));
            }
        }
        return mapping;
    }

    public boolean isPrefixMapping() {
        return this._prefixMapping;
    }

    public String getFacesServletPrefix() {
        return this._facesServletPrefix;
    }

    public String getFacesServletSuffix() {
        return this._facesServletSuffix;
    }

    private static class Mapping {
        private String prefix;
        private String suffix;

        private Mapping() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }
}

