/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InternetResourceBase
implements InternetResource {
    private static final Log log = LogFactory.getLog(InternetResourceBase.class);
    static final int BUFFER_SIZE = 1024;
    private int contentLength = -1;
    private Date lastModified = new Date(System.currentTimeMillis());
    private Date expired;
    private boolean cacheable = true;
    private boolean sessionAware = true;
    private ResourceRenderer renderer = null;
    private Map<Object, Object> customProperties = new HashMap<Object, Object>();
    private String key;

    public int getContentLength(ResourceContext resourceContext) {
        return this.contentLength;
    }

    protected void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Date getExpired(ResourceContext resourceContext) {
        return this.expired;
    }

    public void setExpired(Date expired) {
        this.expired = expired;
    }

    public Date getLastModified(ResourceContext resourceContext) {
        if (null != this.lastModified) {
            return this.lastModified;
        }
        return new Date(System.currentTimeMillis());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isCacheable(ResourceContext resourceContext) {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public boolean isSessionAware() {
        return this.requireFacesContext();
    }

    public void setSessionAware(boolean sessionAware) {
        this.sessionAware = sessionAware;
    }

    public String getContentType(ResourceContext resourceContext) {
        return this.getRenderer(resourceContext).getContentType();
    }

    public ResourceRenderer getRenderer(ResourceContext resourceContext) {
        return this.renderer;
    }

    public void setRenderer(ResourceRenderer renderer) {
        this.renderer = renderer;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUri(FacesContext context, Object data) {
        return InternetResourceBuilder.getInstance().getUri((InternetResource)this, context, this.getDataToStore(context, data));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        return this.getRenderer(new FacesResourceContext(context)).getData((InternetResource)this, context, data);
    }

    protected Object restoreData(ResourceContext context) {
        Object data = context.getResourceData();
        if (data instanceof byte[]) {
            byte[] objectArray = (byte[])data;
            data = this.deserializeData(objectArray);
        }
        return data;
    }

    protected Object deserializeData(byte[] objectArray) {
        return objectArray;
    }

    public InputStream getResourceAsStream(ResourceContext context) {
        throw new UnsupportedOperationException(Messages.getMessage((String)"METHOD_NOT_IMPLEMENTED", (Object)"getResourceAsStream"));
    }

    public Object getProperty(Object key) {
        return this.customProperties.get(key);
    }

    public void setProperty(Object key, Object value) {
        this.customProperties.put(key, value);
    }

    public void encode(FacesContext context, Object data) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"ENCODE_HTML_INFO", (Object)this.getKey()));
        }
        this.getRenderer(new FacesResourceContext(context)).encode((InternetResource)this, context, data);
    }

    public void encode(FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"ENCODE_HTML_INFO_2", (Object)this.getKey(), attributes));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeBegin((InternetResource)this, context, data, attributes);
        this.getRenderer(new FacesResourceContext(context)).encodeEnd((InternetResource)this, context, data);
    }

    public void encodeBegin(FacesContext context, Object component, Map<String, Object> attrs) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"ENCODE_BEGIN_HTML_INFO", (Object)this.getKey(), attrs));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeBegin((InternetResource)this, context, component, attrs);
    }

    public void encodeEnd(FacesContext context, Object component) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"ENCODE_END_HTML_INFO", (Object)this.getKey()));
        }
        this.getRenderer(new FacesResourceContext(context)).encodeEnd((InternetResource)this, context, component);
    }

    public void send(ResourceContext context) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"SEND_CONTENT_INFO", (Object)this.getKey()));
        }
        int total = this.getRenderer(context).send((InternetResource)this, context);
        if (this.isCacheable(context)) {
            this.setContentLength(total);
        }
    }

    public void sendHeaders(ResourceContext context) {
        Date lastModified;
        boolean cached;
        boolean bl = cached = context.isCacheEnabled() && this.isCacheable(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"SET_RESPONSE_HEADERS_INFO", (Object)this.getKey()));
        }
        context.setContentType(this.getContentType(context));
        if (!cached && this.getContentLength(context) > 0) {
            context.setIntHeader("Content-Length", this.getContentLength(context));
        }
        if ((lastModified = this.getLastModified(context)) != null) {
            context.setDateHeader("Last-Modified", lastModified.getTime());
        }
        if (cached) {
            Date expired = this.getExpired(context);
            if (expired != null) {
                context.setDateHeader("Expires", expired.getTime());
            } else {
                context.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
                context.setHeader("Cache-control", "max-age=86400");
            }
        } else {
            context.setHeader("Cache-control", "max-age=0, no-store, no-cache");
            context.setHeader("Pragma", "no-cache");
            context.setIntHeader("Expires", 0);
        }
    }

    public boolean requireFacesContext() {
        return this.getRenderer(null).requireFacesContext();
    }
}

