/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.ImageRenderer;
import org.ajax4jsf.resource.InternetResourceBase;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.image.animatedgif.AnimatedGifEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AnimationResource
extends InternetResourceBase {
    private static final Log log = LogFactory.getLog(AnimationResource.class);
    private int[] delays;
    private int currFrameIndex = 0;

    protected abstract Dimension getFrameSize(ResourceContext var1);

    public AnimationResource() {
        this.setRenderer(new GifRenderer());
    }

    protected abstract int getNumberOfFrames();

    protected int getRepeat() {
        return -1;
    }

    protected int[] getFrameDelays() {
        if (this.delays == null) {
            this.delays = new int[this.getNumberOfFrames()];
            Arrays.fill(this.delays, 0);
        }
        return this.delays;
    }

    public void send(ResourceContext context) throws IOException {
        try {
            DataOutputStream output = new DataOutputStream(context.getOutputStream());
            Dimension frameSize = this.getFrameSize(context);
            int numberOfFrames = this.getNumberOfFrames();
            BufferedImage frame = null;
            if (frameSize.getHeight() > 0.0 && frameSize.getWidth() > 0.0 && numberOfFrames > 0) {
                AnimatedGifEncoder encoder = new AnimatedGifEncoder();
                encoder.start(output);
                encoder.setRepeat(this.getRepeat());
                int[] delays = this.getFrameDelays();
                ImageRenderer renderer = (ImageRenderer)this.getRenderer(null);
                while (this.currFrameIndex < numberOfFrames) {
                    frame = renderer.createImage(frameSize.width, frameSize.height);
                    Graphics2D graphics = frame.createGraphics();
                    this.paint(context, graphics, this.currFrameIndex++);
                    graphics.dispose();
                    encoder.addFrame(frame);
                    if (delays == null || delays.length <= this.currFrameIndex) continue;
                    encoder.setDelay(delays[this.currFrameIndex]);
                }
                encoder.finish();
            }
            output.flush();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract void paint(ResourceContext var1, Graphics2D var2, int var3);
}

