/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;

import javax.faces.context.FacesContext;

import org.ajax4jsf.resource.GifRenderer;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/**
 * Created 23.02.2008
 * 
 * @author Nick Belaevski
 * @since 3.2
 */

public class BaseControlBackgroundImage extends Java2Dresource {

    private static final Dimension DIMENSION = new Dimension(1, 1);

    private String baseColor;

    private String gradientColor;

    private int width;

    public BaseControlBackgroundImage(String baseColor, String gradientColor, int width) {
        super();

        this.baseColor = baseColor;
        this.gradientColor = gradientColor;
        this.width = width;

        setRenderer(new GifRenderer());
        setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        Data d = (Data) data;
        if (d != null) {
            return new Dimension(width, d.height.intValue());
        } else {
            return DIMENSION;
        }
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return getDimensions(null, restoreData(resourceContext));
    }

    protected void paint(ResourceContext resourceContext, Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        Data dataToStore = (Data) restoreData(resourceContext);
        if (dataToStore != null && dataToStore.headerBackgroundColor != null && dataToStore.headerGradientColor != null) {
            Color baseColor = new Color(dataToStore.headerBackgroundColor.intValue());
            Dimension dim = getDimensions(resourceContext);
            Rectangle2D rect = new Rectangle2D.Float(0, 0, dim.width, dim.height);
            Color alternateColor = new Color(dataToStore.headerGradientColor.intValue());
            GradientPaint gragient = new GradientPaint(0, 0, baseColor, 0, dim.height, alternateColor);
            g2d.setPaint(gragient);
            g2d.fill(rect);
        }
    }

    protected final Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);

        String height = (String) skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String) skin.getParameter(context, heightParamName);
        }

        if (height != null && height.length() != 0) {
            return Integer.valueOf(HtmlDimensions.decode(height).intValue());
        } else {
            return Integer.valueOf(16);
        }
    }

    protected Integer getHeight(FacesContext context) {
        return getHeight(context, Skin.generalSizeFont);
    }

    protected Object deserializeData(byte[] objectArray) {
        Data data = new Data();
        if (objectArray != null) {
            Zipper2 zipper2 = new Zipper2(objectArray);
            data.headerBackgroundColor = new Integer(zipper2.nextIntColor());
            data.headerGradientColor = new Integer(zipper2.nextIntColor());
            data.height = new Integer(zipper2.nextInt());
        }

        return data;
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Integer h = getHeight(context);
        if (baseColor == null) {
            return new Data(context, h).toByteArray();
        } else {
            return new Data(context, baseColor, gradientColor, h).toByteArray();
        }
    }

    public boolean isCacheable() {
        return true;
    }

    protected static class Data implements Serializable {
        public Data() {
        }

        protected Data(FacesContext context, Integer height) {
            this(context, Skin.headerBackgroundColor, "headerGradientColor", height);
        }

        protected Data(FacesContext context, String baseColor, String gradientColor, Integer height) {
            this.headerBackgroundColor = getColorValueParameter(context, baseColor, false);
            this.headerGradientColor = getColorValueParameter(context, gradientColor, false);
            this.height = height;

            if (!(this.headerBackgroundColor == null && this.headerGradientColor == null)) {
                if (this.headerBackgroundColor == null) {
                    this.headerBackgroundColor = getColorValueParameter(context, baseColor, true);
                }

                if (this.headerGradientColor == null) {
                    this.headerGradientColor = getColorValueParameter(context, gradientColor, true);
                }
            }
        }

        private Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
            Skin skin;
            if (useDefault) {
                skin = SkinFactory.getInstance().getDefaultSkin(context);
            } else {
                skin = SkinFactory.getInstance().getSkin(context);
            }

            String tmp = (String) skin.getParameter(context, name);
            if (tmp != null && tmp.length() != 0) {
                return new Integer(HtmlColor.decode(tmp).getRGB());
            } else {
                return null;
            }
        }

        /**
         * 
         */
        private static final long serialVersionUID = 1732700513743861250L;

        protected Integer headerBackgroundColor;

        protected Integer headerGradientColor;

        protected Integer height;

        public byte[] toByteArray() {
            if (headerBackgroundColor != null && headerGradientColor != null) {
                byte[] ret = new byte[10];
                new Zipper2(ret).addColor(headerBackgroundColor.intValue()).addColor(headerGradientColor.intValue())
                        .addInt(height);
                return ret;
            } else {
                return null;
            }
        }
    }

}
