/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;
import org.ajax4jsf.io.parser.KeywordState;
import org.ajax4jsf.io.parser.ParserState;

public class ParsingContext {
    private int _currentStatePosition = 0;
    private StringBuffer buff = new StringBuffer(64);
    private ParserState baseState;
    private Stack<ParserState> parsersStack = new Stack();
    private OutputStream _stream;
    private Writer _writer;
    private KeywordState _lastMatched;

    public ParsingContext(OutputStream stream) {
        this._stream = stream;
    }

    public ParsingContext(Writer writer) {
        this._writer = writer;
    }

    public ParserState getBaseState() {
        return this.baseState;
    }

    public void setBaseState(ParserState baseState) {
        this.baseState = baseState;
    }

    public void pushState(ParserState baseState) {
        this.parsersStack.push(this.baseState);
        this.baseState = baseState;
    }

    public ParserState popState() {
        this.baseState = this.parsersStack.pop();
        return this.baseState;
    }

    public int getCurrentStatePosition() {
        return this._currentStatePosition;
    }

    public int incCurrentStatePosition() {
        return this._currentStatePosition++;
    }

    public void setCurrentStatePosition(int currentStatePosition) {
        this._currentStatePosition = currentStatePosition;
    }

    public void putChar(char c) {
        this.buff.append(c);
    }

    private void sendBuffer(Writer out) throws IOException {
        out.write(this.buff.toString());
        this.buff.setLength(0);
    }

    private void sendBuffer(OutputStream out) throws IOException {
        for (int i = 0; i < this.buff.length(); ++i) {
            out.write(this.buff.charAt(i));
        }
        this.buff.setLength(0);
    }

    public void send() throws IOException {
        if (null != this._writer) {
            this.sendBuffer(this._writer);
        } else {
            this.sendBuffer(this._stream);
        }
    }

    public void send(char c) throws IOException {
        if (this.buff.length() > 0) {
            this.send();
        }
        if (null != this._writer) {
            this._writer.write(c);
        } else {
            this._stream.write(c);
        }
    }

    public void setLastMatched(KeywordState state) {
        this._lastMatched = state;
    }

    public KeywordState getLastMatched() {
        return this._lastMatched;
    }
}

