/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.context.ViewResources;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxContextImpl
extends AjaxContext {
    public static final String SERVLET_ERROR_EXCEPTION_ATTRIBUTE = "javax.servlet.error.exception";
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    private static final Pattern USER_AGENTS = Pattern.compile(" AppleWebKit/|^Opera/| Opera ");
    private static final String INIT_PARAMETER_PREFIX = "_init_parameter_";
    private static final Object NULL = new Object();
    private static final Log log = LogFactory.getLog(AjaxContext.class);
    Set<String> ajaxAreasToRender = new HashSet<String>();
    Set<String> ajaxAreasToProcess = null;
    Set<String> ajaxRenderedAreas = new LinkedHashSet<String>();
    boolean ajaxRequest = false;
    boolean selfRender = false;
    Integer viewSequence = new Integer(1);
    String submittedRegionClientId = null;
    String ajaxSingleClientId = null;
    ViewIdHolder viewIdHolder = null;
    Map<String, Object> responseDataMap = new HashMap<String, Object>();
    Map<String, Object> commonAjaxParameters = new HashMap<String, Object>();
    Object oncomplete = null;

    @PreDestroy
    public void release() {
        this.ajaxAreasToRender = new HashSet<String>();
        this.ajaxAreasToProcess = null;
        this.ajaxRenderedAreas = new LinkedHashSet<String>();
        this.ajaxRequest = false;
        this.selfRender = false;
        this.viewSequence = new Integer(1);
        this.submittedRegionClientId = null;
        this.viewIdHolder = null;
        this.responseDataMap = new HashMap<String, Object>();
        this.commonAjaxParameters = new HashMap<String, Object>();
    }

    @PostConstruct
    public void decode(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (null == externalContext.getRequestMap().get(SERVLET_ERROR_EXCEPTION_ATTRIBUTE)) {
            Map requestParameterMap = externalContext.getRequestParameterMap();
            String ajaxRegionId = (String)requestParameterMap.get("AJAXREQUEST");
            this.setSubmittedRegionClientId(ajaxRegionId);
            this.setAjaxRequest(null != ajaxRegionId);
            this.setAjaxSingleClientId((String)requestParameterMap.get("ajaxSingle"));
        } else {
            this.setAjaxRequest(false);
            this.setSubmittedRegionClientId(null);
            this.setAjaxSingleClientId(null);
        }
    }

    public void renderAjax(FacesContext context) throws FacesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"RENDER_AJAX_REQUEST", (Object)this.getSubmittedRegionClientId()));
        }
        try {
            String encoding;
            this.setSelfRender(true);
            this.setAjaxRequest(true);
            ExternalContext extContext = context.getExternalContext();
            RenderKit renderKit = context.getRenderKit();
            if (extContext.getRequest() instanceof ServletRequest) {
                ServletRequest request = (ServletRequest)extContext.getRequest();
                ServletResponse response = (ServletResponse)extContext.getResponse();
                String contentType = "text/xml";
                encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                response.setContentType(contentType + ";charset=" + encoding);
            } else {
                encoding = "UTF-8";
            }
            PrintWriter servletWriter = this.getWriter(extContext);
            ResponseWriter writer = renderKit.createResponseWriter((Writer)servletWriter, null, encoding);
            context.setResponseWriter(writer);
            writer.startDocument();
            this.encodeAjaxBegin(context);
            context.getViewRoot().encodeAll(context);
            this.saveViewState(context);
            this.encodeAjaxEnd(context);
            writer.endDocument();
            writer.flush();
            writer.close();
            servletWriter.close();
        }
        catch (IOException e) {
            throw new FacesException(Messages.getMessage((String)"RENDERING_AJAX_REGION_ERROR", (Object)this.getSubmittedRegionClientId()), (Throwable)e);
        }
        finally {
            context.responseComplete();
        }
    }

    public void encodeAjaxBegin(FacesContext context) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", (UIComponent)viewRoot);
        Locale locale = viewRoot.getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        out.startElement("body", (UIComponent)viewRoot);
    }

    public void encodeAjaxEnd(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("body");
        out.endElement("html");
    }

    public void processHeadResources(FacesContext context) throws FacesException {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED)) && null != requestMap.get("com.exade.vcp.Filter.ResponseWrapper")) {
            Set<String> usersStyles;
            Set<String> styles;
            InternetResourceBuilder internetResourceBuilder;
            ViewResources viewResources;
            UIViewRoot root;
            block40: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Process component tree for collect used scripts and styles");
                }
                root = context.getViewRoot();
                viewResources = new ViewResources();
                try {
                    Skin skin = SkinFactory.getInstance().getSkin(context);
                    String styleSheetUri = (String)skin.getParameter(context, "generalStyleSheet");
                    if (null != styleSheetUri) {
                        String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, styleSheetUri);
                        viewResources.addStyle(resourceURL);
                    }
                    if ("false".equals(skin.getParameter(context, "loadStyleSheets"))) {
                        viewResources.setProcessStyles(false);
                    }
                }
                catch (SkinNotFoundException e) {
                    log.warn((Object)"Current Skin is not found", (Throwable)e);
                }
                internetResourceBuilder = InternetResourceBuilder.getInstance();
                String scriptStrategy = externalContext.getInitParameter("org.richfaces.LoadScriptStrategy");
                if (null != scriptStrategy) {
                    if ("NONE".equals(scriptStrategy)) {
                        viewResources.setProcessScripts(false);
                    } else if ("ALL".equals(scriptStrategy)) {
                        viewResources.setProcessScripts(false);
                        try {
                            viewResources.addScript(internetResourceBuilder.createResource((Object)this, "/org/ajax4jsf/framework.pack.js").getUri(context, null));
                            viewResources.addScript(internetResourceBuilder.createResource((Object)this, "/org/richfaces/ui.pack.js").getUri(context, null));
                        }
                        catch (ResourceNotFoundException e) {
                            if (!log.isWarnEnabled()) break block40;
                            log.warn((Object)("No aggregated javaScript library found " + e.getMessage()));
                        }
                    }
                }
            }
            boolean useStdControlsSkinning = false;
            String stdControlsSkinning = this.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING");
            if (stdControlsSkinning != null) {
                useStdControlsSkinning = "enable".equals(stdControlsSkinning);
            }
            boolean useStdControlsSkinningClasses = true;
            String stdControlsSkinningClasses = this.getInitParameterValue(context, "org.richfaces.CONTROL_SKINNING_CLASSES");
            if (stdControlsSkinningClasses != null) {
                useStdControlsSkinningClasses = "enable".equals(stdControlsSkinningClasses);
            }
            boolean useExtendedSkinning = this.isExtendedSkinningEnabled(externalContext);
            String styleStrategy = externalContext.getInitParameter("org.richfaces.LoadStyleStrategy");
            if ("NONE".equals(styleStrategy)) {
                viewResources.setProcessStyles(false);
            } else if ("ALL".equals(styleStrategy)) {
                viewResources.setProcessStyles(false);
                String commonStyle = "/org/richfaces/skin";
                if (useStdControlsSkinning || useStdControlsSkinningClasses) {
                    commonStyle = useExtendedSkinning ? commonStyle + "-ext" : commonStyle + "-bas";
                    if (useStdControlsSkinning && useStdControlsSkinningClasses) {
                        commonStyle = commonStyle + "-both";
                    } else if (useStdControlsSkinning) {
                        commonStyle = commonStyle + "-styles";
                    } else if (useStdControlsSkinningClasses) {
                        commonStyle = commonStyle + "-classes";
                    }
                }
                commonStyle = commonStyle + ".xcss";
                try {
                    viewResources.addStyle(internetResourceBuilder.createResource((Object)this, commonStyle).getUri(context, null));
                }
                catch (ResourceNotFoundException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("No aggregated stylesheet found " + e.getMessage()));
                    }
                }
            } else {
                if (useStdControlsSkinning) {
                    viewResources.addStyle(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/basic.xcss").getUri(context, null));
                    if (useExtendedSkinning) {
                        viewResources.addStyle(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/extended.xcss").getUri(context, null));
                    }
                }
                if (useStdControlsSkinningClasses) {
                    viewResources.addStyle(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/basic_classes.xcss").getUri(context, null));
                    if (useExtendedSkinning) {
                        viewResources.addStyle(internetResourceBuilder.createResource((Object)this, "/org/richfaces/renderkit/html/css/extended_classes.xcss").getUri(context, null));
                    }
                }
            }
            viewResources.collect(context);
            Set<String> scripts = viewResources.getScripts();
            if (scripts.size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff = new StringBuffer("Scripts for insert into head : \n");
                    for (String script : scripts) {
                        buff.append(script).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_SCRIPTS", scripts);
            }
            if ((styles = viewResources.getStyles()).size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff = new StringBuffer("Styles for insert into head : \n");
                    for (String style : styles) {
                        buff.append(style).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_STYLES", styles);
            }
            if ((usersStyles = viewResources.getUserStyles()).size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff = new StringBuffer("User styles for insert into head : \n");
                    for (String style : usersStyles) {
                        buff.append(style).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put("org.ajax4jsf.framework.HEADER_USER_STYLES", usersStyles);
            }
            requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
            requestMap.put("org.ajax4jsf.VIEW_ID", root.getViewId());
        }
    }

    public void saveViewState(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StateManager stateManager = context.getApplication().getStateManager();
        StateManager.SerializedView serializedView = stateManager.saveSerializedView(context);
        if (null != serializedView && null != writer) {
            StringWriter bufWriter = new StringWriter();
            ResponseWriter tempWriter = writer.cloneWithWriter((Writer)bufWriter);
            context.setResponseWriter(tempWriter);
            stateManager.writeState(context, serializedView);
            tempWriter.flush();
            if (bufWriter.getBuffer().length() > 0) {
                context.getExternalContext().getRequestMap().put("org.ajax4jsf.view.serializedstate", bufWriter.toString());
            }
            context.setResponseWriter(writer);
        }
    }

    protected RenderKit getRenderKit(FacesContext context) {
        RenderKit renderKit = context.getRenderKit();
        if (null == renderKit) {
            String renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            renderKit = factory.getRenderKit(context, renderKitId);
        }
        return renderKit;
    }

    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public Set<String> getAjaxAreasToRender() {
        return this.ajaxAreasToRender;
    }

    public Set<String> getAjaxAreasToProcess() {
        return this.ajaxAreasToProcess;
    }

    public void setAjaxAreasToProcess(Set<String> ajaxAreasToProcess) {
        this.ajaxAreasToProcess = ajaxAreasToProcess;
    }

    public void addRegionsFromComponent(UIComponent component) {
        Set<String> ajaxRegions = AjaxRendererUtils.getAjaxAreas(component);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"INVOKE_AJAX_REGION_LISTENER", (Object)component.getId()));
        }
        if (ajaxRegions != null) {
            Iterator<String> iter = ajaxRegions.iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                this.ajaxAreasToRender.add(this.convertId(component, id));
            }
        }
    }

    public void addComponentToAjaxRender(UIComponent component) {
        this.ajaxAreasToRender.add(AjaxRendererUtils.getAbsoluteId(component));
    }

    public void addComponentToAjaxRender(UIComponent base, String id) {
        this.ajaxAreasToRender.add(this.convertId(base, id));
    }

    private String convertId(UIComponent component, String id) {
        if (id.charAt(0) == ':') {
            return id;
        }
        if (null == component) {
            throw new NullPointerException("Base component for search re-rendered compnnent is null");
        }
        UIComponent target = RendererUtils.getInstance().findComponentFor(component, id);
        if (null != target) {
            return AjaxRendererUtils.getAbsoluteId(target);
        }
        log.warn((Object)("Target component for id " + id + " not found"));
        return id;
    }

    public Set<String> getAjaxRenderedAreas() {
        return this.ajaxRenderedAreas;
    }

    public void addRenderedArea(String id) {
        this.ajaxRenderedAreas.add(id);
    }

    public boolean removeRenderedArea(String id) {
        return this.ajaxRenderedAreas.remove(id);
    }

    public String getSubmittedRegionClientId() {
        return this.submittedRegionClientId;
    }

    public void setSubmittedRegionClientId(String submittedClientId) {
        this.submittedRegionClientId = submittedClientId;
    }

    public String getAjaxSingleClientId() {
        return this.ajaxSingleClientId;
    }

    public void setAjaxSingleClientId(String ajaxSingleClientId) {
        this.ajaxSingleClientId = ajaxSingleClientId;
    }

    public boolean isSelfRender() {
        return this.selfRender;
    }

    public void setSelfRender(boolean selfRender) {
        this.selfRender = selfRender;
    }

    public ViewIdHolder getViewIdHolder() {
        return this.viewIdHolder;
    }

    public void setViewIdHolder(ViewIdHolder viewIdHolder) {
        this.viewIdHolder = viewIdHolder;
    }

    public Object getResponseData() {
        return this.responseDataMap.get("_ajax:data");
    }

    public void setResponseData(Object responseData) {
        this.responseDataMap.put("_ajax:data", responseData);
    }

    public Map<String, Object> getResponseDataMap() {
        return this.responseDataMap;
    }

    protected PrintWriter getWriter(ExternalContext extContext) throws FacesException {
        PrintWriter writer = null;
        Object response = extContext.getResponse();
        try {
            Method gW = response.getClass().getMethod("getWriter", new Class[0]);
            writer = (PrintWriter)gW.invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return writer;
    }

    public String getAjaxActionURL(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("Faces context for build AJAX Action URL is null");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (null == viewRoot) {
            throw new NullPointerException("Faces view tree for build AJAX Action URL is null");
        }
        String viewId = viewRoot.getViewId();
        if (null == viewId) {
            throw new NullPointerException("View id for build AJAX Action URL is null");
        }
        if (!viewId.startsWith("/")) {
            throw new IllegalArgumentException("Illegal view Id for build AJAX Action URL: " + viewId);
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        String actionURL = viewHandler.getActionURL(context, viewId);
        actionURL = actionURL + (actionURL.lastIndexOf(63) > 0 ? "&" : "?") + "javax.portlet.faces.DirectLink=true";
        return context.getExternalContext().encodeActionURL(actionURL);
    }

    public Map<String, Object> getCommonAjaxParameters() {
        return this.commonAjaxParameters;
    }

    public Object getOncomplete() {
        return this.oncomplete;
    }

    public void setOncomplete(Object oncomplete) {
        this.oncomplete = oncomplete;
    }

    private boolean isExtendedSkinningEnabled(ExternalContext context) {
        String userAgent = (String)context.getRequestHeaderMap().get("User-Agent");
        if (userAgent != null) {
            boolean apply;
            boolean bl = apply = !USER_AGENTS.matcher(userAgent).find();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Got User-Agent: " + userAgent));
                log.debug((Object)("Applying extended CSS controls styling = " + apply));
            }
            return apply;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"User-Agent is null, applying extended CSS controls styling");
        }
        return true;
    }

    private String evaluate(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInitParameterValue(FacesContext context, String parameterName) {
        String key = INIT_PARAMETER_PREFIX + parameterName;
        ExternalContext externalContext = context.getExternalContext();
        Map applicationMap = externalContext.getApplicationMap();
        Object mutex = externalContext.getRequest();
        Object parameterValue = null;
        Object object = mutex;
        synchronized (object) {
            parameterValue = applicationMap.get(key);
            if (parameterValue == null) {
                String initParameter = externalContext.getInitParameter(parameterName);
                if (initParameter != null) {
                    if (ELUtils.isValueReference(initParameter)) {
                        Application application = context.getApplication();
                        ExpressionFactory expressionFactory = application.getExpressionFactory();
                        parameterValue = expressionFactory.createValueExpression(context.getELContext(), initParameter, String.class);
                    } else {
                        parameterValue = initParameter;
                    }
                } else {
                    parameterValue = NULL;
                }
                applicationMap.put(key, parameterValue);
            }
        }
        return this.evaluate(context, parameterValue);
    }
}

